/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.navigation.editpolicy;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.navigation.Activator;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationMenu;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Shell;

public class NavigationEditPolicy
extends GraphicalEditPolicy {
    public static final String EDIT_POLICY_ID = "org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationEditPolicy";
    protected NavigationMenu navigationMenu;

    public void activate() {
        super.activate();
        this.initViewerContext();
        if (this.navigationMenu == null) {
            return;
        }
    }

    private void initViewerContext() {
        if (this.getHost() == this.getRoot()) {
            EditPartViewer viewer = this.getHost().getViewer();
            try {
                ServicesRegistry registry = ServiceUtilsForEditPart.getInstance().getServiceRegistry((EditPart)this.getHost());
                Shell parentShell = viewer.getControl().getShell();
                this.navigationMenu = ((NavigationService)registry.getService(NavigationService.class)).createNavigationList();
                if (this.navigationMenu != null) {
                    this.navigationMenu.setServicesRegistry(registry);
                    this.navigationMenu.setParentShell(parentShell);
                    viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            NavigationEditPolicy.this.navigationMenu.exitItem();
                        }
                    });
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            EditPolicy rootNavigationEditPolicy = this.getRoot().getEditPolicy((Object)EDIT_POLICY_ID);
            if (rootNavigationEditPolicy instanceof NavigationEditPolicy) {
                this.navigationMenu = ((NavigationEditPolicy)rootNavigationEditPolicy).navigationMenu;
            }
        }
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        if (this.navigationMenu == null) {
            return;
        }
        if (this.getRoot() == this.getHost()) {
            return;
        }
        if (request instanceof SelectionRequest) {
            SelectionRequest selectionRequest = (SelectionRequest)request;
            if (this.navigationMenu.willEnter((Object)selectionRequest, null)) {
                EditPart targetEditPart = this.getHost().getViewer().findObjectAt(selectionRequest.getLocation());
                this.prependNavigationMenuItem();
                this.appendNavigationMenuItem();
                this.navigationMenu.handleRequest((Object)selectionRequest, (Object)targetEditPart);
            } else {
                this.navigationMenu.exitItem();
            }
        }
    }

    public Command getCommand(Request request) {
        SelectionRequest selectionRequest;
        Object command;
        if (request instanceof SelectionRequest && this.navigationMenu != null && (command = this.navigationMenu.navigate((Object)(selectionRequest = (SelectionRequest)request), (Object)this.getHost())) instanceof Command) {
            return (Command)command;
        }
        return super.getCommand(request);
    }

    private EditPart getRoot() {
        RootEditPart rootEditPart = this.getHost().getRoot();
        return rootEditPart.getContents();
    }

    protected void prependNavigationMenuItem() {
    }

    protected void appendNavigationMenuItem() {
    }

    protected void clearAppendObjects() {
        if (this.navigationMenu != null && this.navigationMenu.getAppendObjects() != null) {
            this.navigationMenu.getAppendObjects().clear();
        }
    }

    protected void clearPrependObjects() {
        if (this.navigationMenu != null && this.navigationMenu.getPrependObjects() != null) {
            this.navigationMenu.getPrependObjects().clear();
        }
    }
}

