/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification.command;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.InstanceSpecificationSlotCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.InstanceSpecificationSlotCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification.ui.SlotSelectionDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class SelectAndCreateSlotsCommand
extends AbstractCommand {
    protected final List<Classifier> classifiers;
    protected final EditPart targetEditPart;
    protected final InstanceSpecification specification;
    protected final boolean headless;

    public SelectAndCreateSlotsCommand(List<Classifier> classifiers, EditPart targetEditPart) {
        this(classifiers, targetEditPart, false);
    }

    public SelectAndCreateSlotsCommand(List<Classifier> classifiers, EditPart targetEditPart, boolean headless) {
        super("Create slots");
        this.classifiers = classifiers;
        this.targetEditPart = targetEditPart;
        this.specification = (InstanceSpecification)EMFHelper.getEObject((Object)targetEditPart);
        this.headless = headless;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Object[] propertiesToInstantiate = this.getProperties();
        if (propertiesToInstantiate == null) {
            return CommandResult.newCancelledCommandResult();
        }
        Object[] objectArray = propertiesToInstantiate;
        int n = propertiesToInstantiate.length;
        int n2 = 0;
        while (n2 < n) {
            CreateElementCommand slotCreationCommand;
            Object propertyObject = objectArray[n2];
            Property property = (Property)propertyObject;
            TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)this.targetEditPart);
            CreateElementRequest createElementRequest = new CreateElementRequest(domain, (EObject)this.specification, UMLElementTypes.Slot_SlotLabel);
            if (this.isSlotCompartmentAvailable(this.targetEditPart)) {
                CreateElementRequestAdapter adapter = new CreateElementRequestAdapter(createElementRequest);
                CreateViewAndElementRequest.ViewAndElementDescriptor descriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(adapter, Node.class, UMLVisualIDRegistry.getType((String)"Slot_SlotLabel"), ((IGraphicalEditPart)this.targetEditPart).getDiagramPreferencesHint());
                CreateViewAndElementRequest createRequest = new CreateViewAndElementRequest(descriptor);
                EditPart realTarget = this.targetEditPart.getTargetEditPart((Request)createRequest);
                Command gefCommand = realTarget.getCommand((Request)createRequest);
                if (gefCommand instanceof ICommandProxy) {
                    slotCreationCommand = ((ICommandProxy)gefCommand).getICommand();
                    slotCreationCommand = slotCreationCommand.reduce();
                } else {
                    slotCreationCommand = new CommandProxy(gefCommand);
                }
            } else {
                slotCreationCommand = new CreateElementCommand(createElementRequest);
            }
            slotCreationCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            CommandResult commandResult = slotCreationCommand.getCommandResult();
            if (commandResult != null && !commandResult.getStatus().isOK()) {
                return commandResult;
            }
            Slot newSlot = this.getNewSlot(commandResult);
            if (newSlot == null) {
                newSlot = this.getNewSlot(createElementRequest);
            }
            if (newSlot == null) {
                return CommandResult.newErrorCommandResult((String)("Could not create the slot for property " + property.getName()));
            }
            this.updateSlotProperties(newSlot, property);
            ++n2;
        }
        return CommandResult.newOKCommandResult();
    }

    protected Object[] getProperties() {
        if (this.headless) {
            return this.getAllProperties();
        }
        SlotSelectionDialog dialog = new SlotSelectionDialog(Display.getCurrent().getActiveShell(), this.specification, this.classifiers);
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getResult();
    }

    protected Property[] getAllProperties() {
        HashSet allProperties = new HashSet();
        for (Classifier classifier : this.classifiers) {
            allProperties.addAll(classifier.getAllAttributes());
        }
        return allProperties.toArray(new Property[allProperties.size()]);
    }

    protected Slot getNewSlot(CreateElementRequest request) {
        if (request.getNewElement() instanceof Slot) {
            return (Slot)request.getNewElement();
        }
        return null;
    }

    protected Slot getNewSlot(CommandResult commandResult) {
        Object objectResult = commandResult.getReturnValue();
        if (objectResult instanceof List) {
            List listResult = (List)objectResult;
            for (Object elementResult : listResult) {
                EObject newElement;
                CreateElementRequest request;
                if (!(elementResult instanceof CreateElementRequestAdapter) || (request = (CreateElementRequest)((CreateElementRequestAdapter)elementResult).getAdapter(CreateElementRequest.class)) == null || !((newElement = request.getNewElement()) instanceof Slot)) continue;
                Slot slot = (Slot)newElement;
                return slot;
            }
        } else if (commandResult.getReturnValue() instanceof Slot) {
            return (Slot)commandResult.getReturnValue();
        }
        return null;
    }

    protected void updateSlotProperties(Slot slot, Property property) throws ExecutionException {
        SetRequest setFeatureRequest = new SetRequest((EObject)slot, (EStructuralFeature)UMLPackage.eINSTANCE.getSlot_DefiningFeature(), (Object)property);
        SetValueCommand setFeatureCommand = new SetValueCommand(setFeatureRequest);
        setFeatureCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        if (property.getDefaultValue() != null) {
            ValueSpecification defaultValue = property.getDefaultValue();
            ValueSpecification currentValue = (ValueSpecification)EcoreUtil.copy((EObject)defaultValue);
            currentValue.setName(property.getName());
            SetRequest setValueRequest = new SetRequest((EObject)slot, (EStructuralFeature)UMLPackage.eINSTANCE.getSlot_Value(), (Object)currentValue);
            SetValueCommand setValueCommand = new SetValueCommand(setValueRequest);
            setValueCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
    }

    protected boolean isSlotCompartmentAvailable(EditPart targetEditPart) {
        if (targetEditPart instanceof InstanceSpecificationSlotCompartmentEditPart || targetEditPart instanceof InstanceSpecificationSlotCompartmentEditPartCN) {
            return true;
        }
        for (Object editPartObject : targetEditPart.getChildren()) {
            if (!this.isSlotCompartmentAvailable((EditPart)editPartObject)) continue;
            return true;
        }
        return false;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

