/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.property.xtext.validation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.MultiplicityRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.PropertyRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.RedefinesRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.SubsetsRule;
import org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty.UmlPropertyPackage;
import org.eclipse.papyrus.uml.textedit.property.xtext.validation.AbstractUmlPropertyJavaValidator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class UmlPropertyJavaValidator
extends AbstractUmlPropertyJavaValidator {
    public void register(EValidatorRegistrar registrar) {
        super.register(registrar);
    }

    @Check
    public void checkMultiplicityRule(MultiplicityRule rule) {
        int lowerValue = 0;
        int upperValue = 0;
        String errorMessage = "The upper bound of a multiplicity cannot be lower than the lower bound.";
        try {
            if (rule.getBounds().size() == 2) {
                lowerValue = ((BoundSpecification)rule.getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)rule.getBounds().get(0)).getValue());
                int n = upperValue = ((BoundSpecification)rule.getBounds().get(1)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)rule.getBounds().get(1)).getValue());
                if (lowerValue == -1 && upperValue != -1 || lowerValue > upperValue && upperValue != -1) {
                    this.error(errorMessage, null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkRedefinesRule(RedefinesRule rule) {
        try {
            Property redefinedProperty = rule.getProperty();
            String typeErrorMessage = "The type of the redefining property must conform to the type of the redefined property";
            String multiplicityErrorMessage = "The multiplicity of the redefining property must be contained in the multiplicity of the redefined property";
            String isDerivedErrorMessage = "Since the redefined property is derived, the redefining property must be derived";
            EObject container = rule.eContainer();
            while (container != null && !(container instanceof PropertyRule)) {
                container = container.eContainer();
            }
            if (container == null) {
                return;
            }
            PropertyRule propertyRule = (PropertyRule)container;
            Classifier typeOfRedefiningProperty = propertyRule.getType().getType();
            boolean isRedefiningPropertyDerived = propertyRule.isDerived();
            boolean valid_RedefinesRule = typeOfRedefiningProperty.conformsTo(redefinedProperty.getType());
            if (!valid_RedefinesRule) {
                this.error(typeErrorMessage, (EStructuralFeature)UmlPropertyPackage.eINSTANCE.getRedefinesRule_Property());
                return;
            }
            int lowerBoundOfRedefinedProperty = redefinedProperty.getLower();
            int upperBoundOfRedefinedProperty = redefinedProperty.getUpper();
            int lowerBound = 1;
            int upperBound = 1;
            if (propertyRule.getMultiplicity() != null) {
                if (propertyRule.getMultiplicity().getBounds().size() == 1) {
                    upperBound = lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                } else if (propertyRule.getMultiplicity().getBounds().size() == 2) {
                    lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                    upperBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue());
                }
            }
            valid_RedefinesRule = lowerBound >= lowerBoundOfRedefinedProperty;
            switch (upperBoundOfRedefinedProperty) {
                case -1: {
                    break;
                }
                default: {
                    boolean bl = valid_RedefinesRule = valid_RedefinesRule && upperBound <= upperBoundOfRedefinedProperty;
                }
            }
            if (!valid_RedefinesRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPropertyPackage.eINSTANCE.getRedefinesRule_Property());
                return;
            }
            if (redefinedProperty.isDerived() && !isRedefiningPropertyDerived) {
                valid_RedefinesRule = false;
            }
            if (!valid_RedefinesRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPropertyPackage.eINSTANCE.getRedefinesRule_Property());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Check
    public void checkSubsetsRule(SubsetsRule rule) {
        try {
            Property subsettedProperty = rule.getProperty();
            String typeErrorMessage = "The type of the subsetting property must conform to the type of the subsetted property";
            String multiplicityErrorMessage = "The multiplicity of the subsetting property must be contained in the multiplicity of the subsetted property";
            EObject container = rule.eContainer();
            while (container != null && !(container instanceof PropertyRule)) {
                container = container.eContainer();
            }
            if (container == null) {
                return;
            }
            PropertyRule propertyRule = (PropertyRule)container;
            Classifier typeOfSubsettingProperty = propertyRule.getType().getType();
            boolean valid_SubsetsRule = typeOfSubsettingProperty.conformsTo(subsettedProperty.getType());
            if (!valid_SubsetsRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPropertyPackage.eINSTANCE.getSubsetsRule_Property());
                return;
            }
            int lowerBoundOfRedefinedProperty = subsettedProperty.getLower();
            int upperBoundOfRedefinedProperty = subsettedProperty.getUpper();
            int lowerBound = 1;
            int upperBound = 1;
            if (propertyRule.getMultiplicity() != null) {
                if (propertyRule.getMultiplicity().getBounds().size() == 1) {
                    upperBound = lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                } else if (propertyRule.getMultiplicity().getBounds().size() == 2) {
                    lowerBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(0)).getValue());
                    upperBound = ((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue().equals("*") ? -1 : Integer.valueOf(((BoundSpecification)propertyRule.getMultiplicity().getBounds().get(1)).getValue());
                }
            }
            valid_SubsetsRule = lowerBound >= lowerBoundOfRedefinedProperty;
            switch (upperBoundOfRedefinedProperty) {
                case -1: {
                    break;
                }
                default: {
                    boolean bl = valid_SubsetsRule = valid_SubsetsRule && upperBound <= upperBoundOfRedefinedProperty;
                }
            }
            if (!valid_SubsetsRule) {
                this.error(multiplicityErrorMessage, (EStructuralFeature)UmlPropertyPackage.eINSTANCE.getSubsetsRule_Property());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

