/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.canonical.strategy;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ISemanticChildrenStrategy;

public class BasicSemanticChildrenStrategy
implements ISemanticChildrenStrategy {
    private EReference[] childReferences;
    private EReference[] connectionReferences;
    private EReference[] dependentReferences;

    public BasicSemanticChildrenStrategy(EReference[] childReferences, EReference[] connectionReferences, EReference[] dependentReferences) {
        this.childReferences = childReferences == null || childReferences.length == 0 ? null : Arrays.copyOf(childReferences, childReferences.length);
        this.connectionReferences = connectionReferences == null || connectionReferences.length == 0 ? null : Arrays.copyOf(connectionReferences, connectionReferences.length);
        this.dependentReferences = dependentReferences == null || dependentReferences.length == 0 ? null : Arrays.copyOf(dependentReferences, dependentReferences.length);
    }

    public BasicSemanticChildrenStrategy(Iterable<? extends EReference> childReferences, Iterable<? extends EReference> connectionReferences, Iterable<? extends EReference> dependentReferences) {
        this.childReferences = childReferences == null || Iterables.isEmpty(childReferences) ? null : (EReference[])Iterables.toArray(childReferences, EReference.class);
        this.connectionReferences = connectionReferences == null || Iterables.isEmpty(connectionReferences) ? null : (EReference[])Iterables.toArray(connectionReferences, EReference.class);
        this.dependentReferences = dependentReferences == null || Iterables.isEmpty(dependentReferences) ? null : (EReference[])Iterables.toArray(dependentReferences, EReference.class);
    }

    @Override
    public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
        return this.childReferences == null ? ECollections.emptyEList() : new EContentsEList(semanticFromEditPart, (EStructuralFeature[])this.childReferences);
    }

    @Override
    public List<? extends EObject> getCanonicalSemanticConnections(EObject semanticFromEditPart, View viewFromEditPart) {
        return this.connectionReferences == null ? ECollections.emptyEList() : new EContentsEList(semanticFromEditPart, (EStructuralFeature[])this.connectionReferences);
    }

    @Override
    public Collection<? extends EObject> getCanonicalDependents(EObject semanticFromEditPart, View viewFromEditPart) {
        return this.dependentReferences == null ? ECollections.emptyEList() : new EContentsEList(semanticFromEditPart, (EStructuralFeature[])this.dependentReferences);
    }
}

