/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class ProfileUtil {
    public static List<Stereotype> findAllSubStereotypes(Stereotype parentStereotype, Package umlPackage, boolean concreteOnly) {
        LinkedHashSet<Stereotype> result = new LinkedHashSet<Stereotype>();
        for (Profile profile : umlPackage.getAllAppliedProfiles()) {
            LinkedList<Stereotype> allStereotypes = new LinkedList<Stereotype>();
            ProfileUtil.findAllStereotypes((Package)profile, allStereotypes);
            for (Stereotype stereotype : allStereotypes) {
                if (concreteOnly && stereotype.isAbstract() || !ProfileUtil.isSubStereotype(parentStereotype, stereotype)) continue;
                result.add(stereotype);
            }
        }
        return new LinkedList<Stereotype>(result);
    }

    private static boolean isSubStereotype(Stereotype parentStereotype, Stereotype childStereotype) {
        if (parentStereotype == childStereotype) {
            return true;
        }
        if (childStereotype.getGenerals().contains((Object)parentStereotype)) {
            return true;
        }
        for (Classifier general : childStereotype.getGenerals()) {
            if (!(general instanceof Stereotype)) continue;
            return ProfileUtil.isSubStereotype(parentStereotype, (Stereotype)general);
        }
        return false;
    }

    public static void findAllStereotypes(Package profile, List<Stereotype> result) {
        for (Stereotype stereotype : profile.getOwnedStereotypes()) {
            result.add(stereotype);
        }
        Iterator iterator = profile.getNestedPackages().iterator();
        while (iterator.hasNext()) {
            Package subPackage;
            Package subProfile = subPackage = (Package)iterator.next();
            ProfileUtil.findAllStereotypes(subProfile, result);
        }
    }

    public static Profile getNearestProfile(Element element) {
        Package package_ = element.getNearestPackage();
        if (package_ instanceof Profile) {
            return (Profile)package_;
        }
        return ProfileUtil.getNearestProfile((Element)package_);
    }
}

