/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.selection.SelectSeveralLinksEditPartTracker;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class SelectMessagesEditPartTracker
extends SelectSeveralLinksEditPartTracker {
    protected Listener KeyDownListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.keyCode == 131072) {
                SelectMessagesEditPartTracker.this.allowReoder = true;
            }
        }
    };
    protected Listener KeyUPListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.keyCode == 131072) {
                SelectMessagesEditPartTracker.this.allowReoder = false;
            }
        }
    };
    protected int MinDistancetop = Integer.MAX_VALUE;
    protected int MinDistancebottom = Integer.MAX_VALUE;
    protected Dimension delta = null;
    private boolean allowReoder = false;

    public void activate() {
        super.activate();
    }

    protected boolean handleButtonDown(int button) {
        Object delta = null;
        this.MinDistancetop = Integer.MAX_VALUE;
        this.MinDistancebottom = Integer.MAX_VALUE;
        ArrayList<GraphicalEditPart> nodeEditPart = new ArrayList<GraphicalEditPart>();
        List selectedEditparts = this.getOperationSet();
        int i = 0;
        while (i < selectedEditparts.size()) {
            Object currentEditPart = selectedEditparts.get(i);
            if (currentEditPart instanceof ConnectionEditPart) {
                ConnectionEditPart currentConnectionEdiPart = (ConnectionEditPart)currentEditPart;
                nodeEditPart.add((GraphicalEditPart)currentConnectionEdiPart.getSource());
            }
            ++i;
        }
        ArrayList<AbstractMessageEditPart> messageEditPartList = new ArrayList<AbstractMessageEditPart>();
        for (GraphicalEditPart anodeEditPart : nodeEditPart) {
            for (Object connection : anodeEditPart.getSourceConnections()) {
                if (!(connection instanceof AbstractMessageEditPart) || selectedEditparts.contains(connection)) continue;
                messageEditPartList.add((AbstractMessageEditPart)((Object)connection));
            }
            for (Object connection : anodeEditPart.getTargetConnections()) {
                if (selectedEditparts.contains(connection) || !(connection instanceof AbstractMessageEditPart)) continue;
                messageEditPartList.add((AbstractMessageEditPart)((Object)connection));
            }
        }
        for (AbstractMessageEditPart abstractMessageEditPart : messageEditPartList) {
            Point currentConnectionPosition = abstractMessageEditPart.getConnectionFigure().getPoints().getFirstPoint().getCopy();
            for (Object selectedEditPart : selectedEditparts) {
                if (!(selectedEditPart instanceof AbstractMessageEditPart)) continue;
                AbstractMessageEditPart currentSelectedMessage = (AbstractMessageEditPart)((Object)selectedEditPart);
                Point currentSelectedConnectionPosition = currentSelectedMessage.getConnectionFigure().getPoints().getFirstPoint().getCopy();
                if (currentConnectionPosition.y < currentSelectedConnectionPosition.y) {
                    if (this.MinDistancetop <= currentSelectedConnectionPosition.y - currentConnectionPosition.y) continue;
                    this.MinDistancetop = currentSelectedConnectionPosition.y - currentConnectionPosition.y;
                    continue;
                }
                if (this.MinDistancebottom <= currentConnectionPosition.y - currentSelectedConnectionPosition.y) continue;
                this.MinDistancebottom = currentConnectionPosition.y - currentSelectedConnectionPosition.y;
            }
        }
        return super.handleButtonDown(button);
    }

    public SelectMessagesEditPartTracker(org.eclipse.gef.ConnectionEditPart owner) {
        super(owner);
        PlatformUI.getWorkbench().getDisplay().addFilter(1, this.KeyDownListener);
        PlatformUI.getWorkbench().getDisplay().addFilter(2, this.KeyUPListener);
    }

    public void deactivate() {
        PlatformUI.getWorkbench().getDisplay().removeFilter(2, this.KeyDownListener);
        PlatformUI.getWorkbench().getDisplay().removeFilter(2, this.KeyUPListener);
        super.deactivate();
    }

    protected void updateSourceRequest() {
        if (!this.allowReoder) {
            Dimension computedDelta = this.getLocation().getDifference(this.getStartLocation());
            this.delta = null;
            if (computedDelta.height < 0) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_UTIL, "Move " + computedDelta.height + " MinDistancetop" + this.MinDistancetop);
                if (this.MinDistancetop + computedDelta.height < 0) {
                    computedDelta.height = -this.MinDistancetop;
                    this.delta = computedDelta.getCopy();
                }
            } else {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_UTIL, "Move " + computedDelta.height + " MinDistancebottom" + this.MinDistancebottom);
                if (this.MinDistancebottom - computedDelta.height - 10 < 0) {
                    computedDelta.height = this.MinDistancebottom - 10;
                    this.delta = computedDelta.getCopy();
                }
            }
        }
        super.updateSourceRequest();
    }

    protected Dimension getDragMoveDelta() {
        if (this.delta == null) {
            return this.getLocation().getDifference(this.getStartLocation());
        }
        return this.delta;
    }

    public DiagramEditPart getDiagramEditPart(EditPart editPart) {
        while (editPart instanceof IGraphicalEditPart) {
            if (editPart instanceof DiagramEditPart) {
                return (DiagramEditPart)editPart;
            }
            editPart = editPart.getParent();
        }
        if (editPart instanceof DiagramRootEditPart) {
            return (DiagramEditPart)((DiagramRootEditPart)editPart).getChildren().get(0);
        }
        return null;
    }
}

