/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.keyboardlistener.IKeyPressState;
import org.eclipse.papyrus.uml.diagram.sequence.keyboardlistener.KeyboardListener;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public abstract class UpdateWeakReferenceEditPolicy
extends GraphicalEditPolicy
implements IKeyPressState {
    protected KeyboardListener SHIFTDown = new KeyboardListener(this, 131072, true);
    protected KeyboardListener SHIFTUp = new KeyboardListener(this, 131072, false);
    protected boolean mustMove = true;

    public void activate() {
        super.activate();
        PlatformUI.getWorkbench().getDisplay().addFilter(1, (Listener)this.SHIFTDown);
        PlatformUI.getWorkbench().getDisplay().addFilter(2, (Listener)this.SHIFTUp);
    }

    public void deactivate() {
        PlatformUI.getWorkbench().getDisplay().removeFilter(1, (Listener)this.SHIFTDown);
        PlatformUI.getWorkbench().getDisplay().removeFilter(2, (Listener)this.SHIFTUp);
        super.deactivate();
    }

    protected static ReconnectRequest createReconnectRequest(EditPart hostEditpart, ConnectionEditPart connectionEditPart, Rectangle location, ArrayList<EditPart> senderList, String reconnectType) {
        ReconnectRequest reconnectRequest = new ReconnectRequest();
        reconnectRequest.setConnectionEditPart(connectionEditPart);
        SenderRequestUtils.addRequestSenders((Request)reconnectRequest, senderList);
        SenderRequestUtils.addRequestSender((Request)reconnectRequest, hostEditpart);
        reconnectRequest.setLocation(new Point(100, location.y));
        reconnectRequest.setType((Object)reconnectType);
        if ("Reconnection target".equals(reconnectType)) {
            reconnectRequest.setTargetEditPart(connectionEditPart.getTarget());
        } else {
            reconnectRequest.setTargetEditPart(connectionEditPart.getSource());
        }
        return reconnectRequest;
    }

    @Override
    public void setKeyPressState(Boolean isPressed) {
        this.mustMove = isPressed == false;
    }

    protected static void moveRoundedEditPart(EditPart hostEditPart, Point moveDelta, CompoundCommand compoundCommand, EditPart editPartToMove, ArrayList<EditPart> senderList) {
        ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"move");
        SenderRequestUtils.addRequestSenders((Request)changeBoundsRequest, senderList);
        SenderRequestUtils.addRequestSender((Request)changeBoundsRequest, hostEditPart);
        GraphicalEditPart gEditPart = (GraphicalEditPart)editPartToMove;
        changeBoundsRequest.setLocation(new Point(gEditPart.getFigure().getBounds().getTopLeft().x, gEditPart.getFigure().getBounds().getTopLeft().x + moveDelta.y()));
        changeBoundsRequest.setEditParts(editPartToMove);
        changeBoundsRequest.setMoveDelta(moveDelta);
        changeBoundsRequest.setSizeDelta(new Dimension(0, 0));
        compoundCommand.add(editPartToMove.getCommand((Request)changeBoundsRequest));
    }

    protected static void moveTargetConnectionEditPart(EditPart hostEditPart, Point moveDelta, CompoundCommand compoundCommand, ConnectionEditPart connectionEditPart, ArrayList<EditPart> senderList) {
        PolylineConnectionEx polyline = (PolylineConnectionEx)connectionEditPart.getFigure();
        Point positiononScreen = polyline.getTargetAnchor().getReferencePoint();
        Rectangle newAnchorPositionOnScreen = new Rectangle(positiononScreen.x, positiononScreen.y + moveDelta.y, 0, 0);
        ReconnectRequest reconnectTargetRequest = UpdateWeakReferenceEditPolicy.createReconnectRequest(hostEditPart, connectionEditPart, newAnchorPositionOnScreen, senderList, "Reconnection target");
        compoundCommand.add(connectionEditPart.getTarget().getCommand((Request)reconnectTargetRequest));
    }

    protected static void moveSourceConnectionEditPart(EditPart hostEditPart, Point moveDelta, CompoundCommand compoundCommand, ConnectionEditPart connectionEditPart, ArrayList<EditPart> senderList) {
        PolylineConnectionEx polyline = (PolylineConnectionEx)connectionEditPart.getFigure();
        Point anchorPositionOnScreen = polyline.getSourceAnchor().getReferencePoint();
        Rectangle newAnchorPositionOnScreen = new Rectangle(anchorPositionOnScreen.x, anchorPositionOnScreen.y + moveDelta.y, 0, 0);
        ReconnectRequest reconnectSourceRequest = UpdateWeakReferenceEditPolicy.createReconnectRequest(hostEditPart, connectionEditPart, newAnchorPositionOnScreen, senderList, "Reconnection source");
        compoundCommand.add(connectionEditPart.getSource().getCommand((Request)reconnectSourceRequest));
    }
}

