/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.matrix.cell.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.BooleanExpressionsFactory;
import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.IBooleanEObjectExpression;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.IGenericMatrixRelationshipCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.IMatrixTableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.GenericRelationshipMatrixCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.MatrixRelationShipDirection;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.tools.helper.UMLRelationshipHelper;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractUMLGenericMatrixRelationshipCellManager
extends AbstractCellManager
implements IGenericMatrixRelationshipCellManager {
    private EClass managedElement;
    protected UMLRelationshipHelper helper;
    private IBooleanEObjectExpression defaultFilter = BooleanExpressionsFactory.eINSTANCE.createLiteralTrueExpression();

    public AbstractUMLGenericMatrixRelationshipCellManager(EClass managedElement) {
        this.managedElement = managedElement;
        this.helper = this.getOrCreateUMLRelationshipHelper();
    }

    protected UMLRelationshipHelper getOrCreateUMLRelationshipHelper() {
        if (this.helper == null) {
            this.helper = new UMLRelationshipHelper();
        }
        return this.helper;
    }

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager manager) {
        boolean handle;
        boolean bl = handle = manager instanceof IMatrixTableWidgetManager && this.isMatchingEditedElement(manager.getTable()) && manager.getTable().getContext() instanceof Element;
        if (handle) {
            boolean bl2 = handle = this.getElementTypeToCreate(this.getCellEditorConfiguration((IMatrixTableWidgetManager)manager)) != null;
        }
        if (handle) {
            Object realColumn = AxisUtils.getRepresentedElement((Object)columnElement);
            Object realRow = AxisUtils.getRepresentedElement((Object)rowElement);
            handle = realColumn instanceof Element && realRow instanceof Element;
        }
        return handle;
    }

    public final boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager manager) {
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        boolean isEditable = this.isCellEditableIgnoringCurrentValue(columnElement, rowElement, manager);
        if (isEditable) {
            List<Element> currentValues = this.getMatchingRelationships(realColumn, realRow, manager);
            boolean bl = isEditable = currentValues.size() < 2;
            if (currentValues.size() == 1 && this.canHaveMoreThan2Ends()) {
                boolean bl2 = isEditable = this.getNumberOfEnds(currentValues.get(0)) == 2;
            }
        }
        if (isEditable) {
            Command cmd = this.getSetValueCommand(TableEditingDomainUtils.getTableContextEditingDomain((Table)manager.getTable()), columnElement, rowElement, Boolean.TRUE, manager);
            isEditable = cmd == null ? false : cmd.canExecute();
        }
        return isEditable;
    }

    protected final boolean isCellEditableIgnoringCurrentValue(Object columnElement, Object rowElement, INattableModelManager manager) {
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        IMatrixTableWidgetManager matrixManager = (IMatrixTableWidgetManager)manager;
        GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration(matrixManager);
        boolean isEditable = false;
        switch (conf.getDirection()) {
            case NONE: {
                if (this.isDirectedRelationship()) {
                    isEditable = false;
                    break;
                }
                isEditable = this.matchingSourceFeatureType(realRow) && this.matchingTargetFeatureType(realColumn) && this.matchingSourceFeatureType(realColumn) && this.matchingTargetFeatureType(realRow);
                break;
            }
            case FROM_ROW_TO_COLUMN: {
                isEditable = this.matchingSourceFeatureType(realRow) && this.matchingTargetFeatureType(realColumn);
                break;
            }
            case FROM_COLUMN_TO_ROW: {
                isEditable = this.matchingSourceFeatureType(realColumn) && this.matchingTargetFeatureType(realRow);
                break;
            }
        }
        return isEditable;
    }

    protected boolean matchingSourceFeatureType(Object element) {
        return this.getRelationshipSourceFeature().getEType().isInstance(element);
    }

    protected boolean matchingTargetFeatureType(Element element) {
        return this.getRelationshipTargetFeature().getEType().isInstance((Object)element);
    }

    protected Element getBestOwner(ElementTypeConfiguration elementTypeConfiguration, Element source, Element target, EObject context) {
        return this.helper.getBestOwner(elementTypeConfiguration, source, target, (Element)context);
    }

    protected IElementType getElementTypeToCreate(GenericRelationshipMatrixCellEditorConfiguration configuration) {
        ElementTypeConfiguration editedElement = configuration.getEditedElement();
        if (editedElement != null) {
            return ElementTypeRegistry.getInstance().getType(editedElement.getIdentifier());
        }
        return null;
    }

    protected IElementMatcher getElementTypeMatcher(GenericRelationshipMatrixCellEditorConfiguration configuration) {
        IElementType elementType = this.getElementTypeToCreate(configuration);
        return elementType instanceof ISpecializationType ? ((ISpecializationType)elementType).getMatcher() : null;
    }

    protected boolean canHaveMoreThan2Ends() {
        return this.helper.canHaveMoreThan2Ends(this.managedElement);
    }

    protected boolean isDirectedRelationship() {
        return this.helper.isDirectedRelationship(this.managedElement);
    }

    protected final boolean isMatchingEditedElement(Table table) {
        ElementTypeConfiguration elTypeConf = this.getEditedElementKind(table);
        return this.handles(elTypeConf);
    }

    protected final boolean handles(ElementTypeConfiguration elTypeConf) {
        if (elTypeConf instanceof MetamodelTypeConfiguration) {
            return ((MetamodelTypeConfiguration)elTypeConf).getEClass() == this.managedElement;
        }
        if (elTypeConf instanceof SpecializationTypeConfiguration && ((SpecializationTypeConfiguration)elTypeConf).getSpecializedTypes().size() == 1) {
            return this.handles((ElementTypeConfiguration)((SpecializationTypeConfiguration)elTypeConf).getSpecializedTypes().get(0));
        }
        return false;
    }

    protected final boolean hasGenericRelationshipMatrixCellEditorConfiguration(IMatrixTableWidgetManager manager) {
        return this.getCellEditorConfiguration(manager) != null;
    }

    protected final GenericRelationshipMatrixCellEditorConfiguration getCellEditorConfiguration(IMatrixTableWidgetManager manager) {
        ICellEditorConfiguration conf = manager.getTable().getOwnedCellEditorConfigurations();
        if (conf instanceof GenericRelationshipMatrixCellEditorConfiguration) {
            return (GenericRelationshipMatrixCellEditorConfiguration)conf;
        }
        return null;
    }

    protected ElementTypeConfiguration getEditedElementKind(Table table) {
        ICellEditorConfiguration conf = table.getOwnedCellEditorConfigurations();
        if (conf instanceof GenericRelationshipMatrixCellEditorConfiguration) {
            return ((GenericRelationshipMatrixCellEditorConfiguration)conf).getEditedElement();
        }
        return null;
    }

    protected EStructuralFeature getRelationshipSourceFeature() {
        return this.helper.getRelationshipSourceFeature(this.managedElement);
    }

    protected EStructuralFeature getRelationshipTargetFeature() {
        return this.helper.getRelationshipTargetFeature(this.managedElement);
    }

    protected Collection<? extends Element> getSources(Element relationship) {
        return this.helper.getSources(relationship);
    }

    protected Collection<? extends Element> getTargets(Element relationship) {
        return this.helper.getTargets(relationship);
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.isCellEditableIgnoringCurrentValue(columnElement, rowElement, tableManager)) {
            return this.getMatchingRelationships((Element)AxisUtils.getRepresentedElement((Object)columnElement), (Element)AxisUtils.getRepresentedElement((Object)rowElement), tableManager);
        }
        return CellHelper.getUnsupportedCellContentsText();
    }

    protected List<Element> getMatchingRelationships(Element columnElement, Element rowElement, INattableModelManager tableManager) {
        Object realColumn = AxisUtils.getRepresentedElement((Object)columnElement);
        Object realRow = AxisUtils.getRepresentedElement((Object)rowElement);
        IMatrixTableWidgetManager matrixManager = (IMatrixTableWidgetManager)tableManager;
        ArrayList<Object> combined = new ArrayList<Object>();
        combined.add(realColumn);
        combined.add(realRow);
        Map refs = EcoreUtil.CrossReferencer.find(combined);
        ArrayList<Element> matchingRelationships = new ArrayList<Element>();
        GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration(matrixManager);
        MatrixRelationShipDirection dir = conf.getDirection();
        IBooleanEObjectExpression cellContentFilter = conf.getCellContentsFilter();
        if (cellContentFilter == null) {
            cellContentFilter = this.defaultFilter;
        }
        for (Element current : refs.keySet().stream().filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList())) {
            boolean isValid;
            IElementMatcher matcher = this.getElementTypeMatcher(conf);
            boolean bl = isValid = matcher != null ? matcher.matches((EObject)current) : true;
            if (isValid) {
                boolean bl2 = isValid = current.eClass() == this.getManagedRelationship() && (Boolean)cellContentFilter.evaluate((Object)current) != false;
            }
            if (isValid) {
                switch (dir) {
                    case NONE: {
                        break;
                    }
                    case FROM_ROW_TO_COLUMN: {
                        isValid = this.getSources(current).contains(realRow) && this.getTargets(current).contains(realColumn);
                        break;
                    }
                    case FROM_COLUMN_TO_ROW: {
                        isValid = this.getSources(current).contains(realColumn) && this.getTargets(current).contains(realRow);
                        break;
                    }
                }
            }
            if (!isValid) continue;
            matchingRelationships.add(current);
        }
        return matchingRelationships;
    }

    protected int getNumberOfEnds(Element relationship) {
        return this.helper.getNumberOfEnds(relationship);
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        List<Element> r;
        Element realColumn = (Element)AxisUtils.getRepresentedElement((Object)columnElement);
        Element realRow = (Element)AxisUtils.getRepresentedElement((Object)rowElement);
        if (Boolean.FALSE.equals(newValue) && (r = this.getMatchingRelationships(realColumn, realRow, tableManager)).size() == 1) {
            DestroyElementRequest request = new DestroyElementRequest((EObject)r.get(0), false);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)((EObject)r.get(0)));
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            if (cmd != null && cmd.canExecute()) {
                return new GMFtoEMFCommandWrapper(cmd);
            }
        }
        if (Boolean.TRUE.equals(newValue)) {
            CreateRelationshipRequest request;
            Element owner;
            GenericRelationshipMatrixCellEditorConfiguration conf = this.getCellEditorConfiguration((IMatrixTableWidgetManager)tableManager);
            MatrixRelationShipDirection dir = conf.getDirection();
            IElementType elementType = this.getElementTypeToCreate(conf);
            switch (dir) {
                case FROM_ROW_TO_COLUMN: {
                    owner = this.getBestOwner(conf.getEditedElement(), realRow, realColumn, tableManager.getTable().getContext());
                    request = new CreateRelationshipRequest((EObject)owner, (EObject)realRow, (EObject)realColumn, elementType);
                    break;
                }
                case FROM_COLUMN_TO_ROW: {
                    owner = this.getBestOwner(conf.getEditedElement(), realColumn, realRow, tableManager.getTable().getContext());
                    request = new CreateRelationshipRequest((EObject)owner, (EObject)realColumn, (EObject)realRow, elementType);
                    break;
                }
                default: {
                    request = null;
                    owner = null;
                }
            }
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider(owner);
            ICommand cmd = provider.getEditCommand(request);
            if (cmd != null && cmd.canExecute()) {
                return new GMFtoEMFCommandWrapper(cmd);
            }
        }
        return null;
    }

    public EClass getManagedRelationship() {
        return this.managedElement;
    }
}

