/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectionDialog;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.util.PapyrusSelectionService;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class AbstractMultipleValueEditor<T extends IElementSelector>
extends AbstractListEditor
implements SelectionListener,
IChangeListener,
DisposeListener {
    public static final int MANY = -1;
    protected ISelectionProvider selectionProvider;
    private ISelectionChangedListener selectionChangedListener;
    protected Composite controlsSection;
    protected Control contentControl;
    protected Button add;
    protected Button remove;
    protected Button up;
    protected Button down;
    protected Button edit;
    protected T selector;
    protected boolean ordered;
    protected boolean unique;
    protected ReferenceValueFactory referenceFactory;
    protected boolean readOnly;
    private boolean directCreation;
    private boolean directCreationWithTreeViewer;
    protected int upperBound;

    protected AbstractMultipleValueEditor(Composite parent, T selector, boolean ordered, boolean unique, String label) {
        this(parent, selector, ordered, unique, label, -1);
    }

    protected AbstractMultipleValueEditor(Composite parent, T selector, boolean ordered, boolean unique, String label, int upperBound) {
        super(parent, label);
        this.selector = selector;
        this.ordered = ordered;
        this.unique = unique;
        this.directCreationWithTreeViewer = false;
        this.setUpperBound(upperBound);
    }

    protected void createContents() {
        this.setLayout((Layout)new GridLayout(this.label == null ? 1 : 2, false));
        this.controlsSection = new Composite((Composite)this, 0);
        this.controlsSection.setLayout((Layout)new FillLayout());
        this.controlsSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.contentControl = this.createContents(this);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.minimumHeight = 80;
        this.contentControl.setLayoutData((Object)gridData);
        this.selectionProvider = this.getSelectionProvider(this.contentControl);
        PapyrusSelectionService.getInstance().setSelectionProvider(this.selectionProvider);
        this.selectionChangedListener = __ -> this.updateControls();
        this.selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        this.createListControls();
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.updateControls();
    }

    protected abstract Control createContents(Composite var1);

    protected abstract ISelectionProvider getSelectionProvider(Control var1);

    @Deprecated
    protected MultipleValueSelectorDialog createMultipleValueSelectorDialog(Composite parent, IElementSelector selector, boolean ordered, boolean unique, String label) {
        return null;
    }

    protected MultipleValueSelectionDialog createMultipleValueSelectionDialog(Composite parent, IElementSelector selector, boolean ordered, boolean unique, String label) {
        return new MultipleValueSelectionDialog(parent.getShell(), selector, label, unique, ordered);
    }

    @Override
    protected GridData getLabelLayoutData() {
        GridData data = new GridData(4, 0x1000000, true, false);
        return data;
    }

    public void setSelector(T selector) {
        this.selector = selector;
    }

    protected void updateControls() {
        boolean enableAddAction = true;
        if (this.directCreation && (this.referenceFactory == null || !this.referenceFactory.canCreateObject())) {
            enableAddAction = false;
        }
        this.add.setEnabled(!this.readOnly && enableAddAction);
        this.remove.setEnabled(!this.readOnly);
        if (this.ordered) {
            this.up.setVisible(true);
            this.down.setVisible(true);
            this.up.setEnabled(!this.readOnly);
            this.down.setEnabled(!this.readOnly);
        } else {
            this.up.setVisible(false);
            this.down.setVisible(false);
        }
        if (this.edit != null) {
            this.edit.setEnabled(this.referenceFactory != null && this.referenceFactory.canEdit() && !this.readOnly);
        }
        if (this.modelProperty != null && this.upperBound != -1 && this.modelProperty.size() >= this.upperBound) {
            this.add.setEnabled(false);
        }
        this.updateButtons();
    }

    public abstract void setLabelProvider(IBaseLabelProvider var1);

    public abstract IBaseLabelProvider getLabelProvider();

    @Override
    protected void doBinding() {
        this.setInput(this.modelProperty);
        this.modelProperty.addChangeListener((IChangeListener)this);
    }

    protected abstract void setInput(IObservableList var1);

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
        if (this.controlsSection != null) {
            this.updateControls();
        }
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
        if (this.controlsSection != null) {
            this.updateControls();
        }
    }

    protected void createListControls() {
        this.up = this.createButton(Activator.getDefault().getImage("/icons/Up_12x12.gif"), Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = this.createButton(Activator.getDefault().getImage("/icons/Down_12x12.gif"), Messages.MultipleValueEditor_MoveSelectedElementsDown);
        this.add = this.createButton(Activator.getDefault().getImage("/icons/Add_12x12.gif"), Messages.MultipleValueEditor_AddElements);
        this.remove = this.createButton(Activator.getDefault().getImage("/icons/Delete_12x12.gif"), Messages.MultipleValueEditor_RemoveSelectedElements);
        this.edit = this.createButton(Activator.getDefault().getImage("/icons/Edit_12x12.gif"), Messages.MultipleValueEditor_EditSelectedValue);
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.controlsSection, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        return button;
    }

    @Override
    public Object getEditableType() {
        return Collection.class;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == null || e.widget.isDisposed()) {
            return;
        }
        try {
            if (e.widget == this.add) {
                if (this.upperBound == -1 || this.modelProperty.size() < this.upperBound) {
                    this.addAction();
                }
            } else if (e.widget == this.remove) {
                this.removeAction();
            } else if (e.widget == this.up) {
                this.upAction();
            } else if (e.widget == this.down) {
                this.downAction();
            } else if (e.widget == this.edit) {
                this.editAction();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        if (!this.isDisposed() && this.controlsSection != null) {
            this.updateControls();
        }
    }

    protected void addAction() {
        final Object context = this.getContextElement();
        if (this.directCreation) {
            this.directCreateObject(context);
            return;
        }
        this.getOperationExecutor(context).execute(new Callable<Object[]>(){

            @Override
            public Object[] call() {
                String dialogLabel = AbstractMultipleValueEditor.this.label == null ? null : AbstractMultipleValueEditor.this.label.getText();
                SelectionDialog dialog = AbstractMultipleValueEditor.this.createSelectionDialog(AbstractMultipleValueEditor.this.getParent(), AbstractMultipleValueEditor.this.selector, AbstractMultipleValueEditor.this.ordered, AbstractMultipleValueEditor.this.unique, dialogLabel, context);
                if (AbstractMultipleValueEditor.this.modelProperty != null) {
                    dialog.setInitialSelections(AbstractMultipleValueEditor.this.modelProperty.toArray());
                } else {
                    dialog.setInitialSelections(new Object[0]);
                }
                int returnCode = dialog.open();
                if (returnCode == 1) {
                    AbstractMultipleValueEditor.this.selector.clearTemporaryElements();
                    throw new OperationCanceledException();
                }
                AbstractMultipleValueEditor.this.modelProperty.clear();
                Object[] result = dialog.getResult();
                if (result != null) {
                    AbstractMultipleValueEditor.this.modelProperty.addAll(Arrays.asList(result));
                    AbstractMultipleValueEditor.this.commit();
                }
                return result;
            }
        }, NLS.bind((String)Messages.MultipleValueEditor_addOperation, (Object)this.labelText));
    }

    private SelectionDialog createSelectionDialog(Composite parent, IElementSelector selector, boolean ordered, boolean unique, String label, Object context) {
        SelectionDialog result;
        ILabelProvider labelProvider = Optional.of(this.getLabelProvider()).filter(ILabelProvider.class::isInstance).map(ILabelProvider.class::cast).orElseGet(LabelProvider::new);
        MultipleValueSelectorDialog oldStyle = this.createMultipleValueSelectorDialog(parent, selector, ordered, unique, label);
        if (oldStyle != null) {
            oldStyle.setLabelProvider(labelProvider);
            oldStyle.setFactory(this.referenceFactory);
            oldStyle.setUpperBound(this.upperBound);
            oldStyle.setContextElement(context);
            result = oldStyle;
        } else {
            MultipleValueSelectionDialog newStyle = this.createMultipleValueSelectionDialog(parent, selector, ordered, unique, label);
            newStyle.setLabelProvider(labelProvider);
            newStyle.setFactory(this.referenceFactory);
            newStyle.setUpperBound(this.upperBound);
            newStyle.setContextElement(context);
            result = newStyle;
        }
        return result;
    }

    @Override
    protected void commit() {
        super.commit();
        if (!this.isDisposed()) {
            this.refreshValue();
        }
    }

    protected void removeAction() {
        IStructuredSelection selection = this.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            this.modelProperty.remove(value);
            ++n2;
        }
        this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        this.commit();
    }

    protected void upAction() {
        IStructuredSelection selection = this.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int oldIndex = this.modelProperty.indexOf(o);
            if (oldIndex > 0) {
                this.modelProperty.move(oldIndex, oldIndex - 1);
            }
            ++n2;
        }
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectionProvider.setSelection((ISelection)selectionCopy);
        this.commit();
    }

    protected void downAction() {
        IStructuredSelection selection = this.getSelection();
        int maxIndex = this.modelProperty.size() - 1;
        Object[] selectionArray = selection.toArray();
        int i = selectionArray.length - 1;
        while (i >= 0) {
            Object o = selectionArray[i];
            int oldIndex = this.modelProperty.indexOf(o);
            if (-1 != oldIndex && oldIndex < maxIndex) {
                this.modelProperty.move(oldIndex, oldIndex + 1);
            }
            --i;
        }
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectionProvider.setSelection((ISelection)selectionCopy);
        this.commit();
    }

    protected void editAction() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final Object currentValue = selection.getFirstElement();
        final int index = this.modelProperty.indexOf(currentValue);
        this.getOperationExecutor(currentValue).execute(new Runnable(){

            @Override
            public void run() {
                Object newValue = AbstractMultipleValueEditor.this.referenceFactory.edit((Control)AbstractMultipleValueEditor.this.edit, currentValue);
                if (newValue != currentValue && newValue != null) {
                    AbstractMultipleValueEditor.this.modelProperty.set(index, newValue);
                }
                AbstractMultipleValueEditor.this.commit();
            }
        }, NLS.bind((String)Messages.MultipleValueEditor_editOperation, (Object)this.labelText));
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.referenceFactory = factory;
        if (this.controlsSection != null) {
            this.updateControls();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.contentControl && this.edit != null && this.edit.isEnabled()) {
            this.editAction();
        }
    }

    public Control getContentControl() {
        return this.contentControl;
    }

    public void handleChange(ChangeEvent event) {
        if (!this.isDisposed()) {
            this.refreshValue();
        }
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            this.selectionChangedListener = null;
            PapyrusSelectionService.getInstance().unsetSelectionProvider(this.selectionProvider);
            this.selectionProvider = null;
        }
        if (this.add != null) {
            this.add.removeSelectionListener((SelectionListener)this);
            this.add = null;
        }
        if (this.edit != null) {
            this.edit.removeSelectionListener((SelectionListener)this);
            this.edit = null;
        }
        if (this.up != null) {
            this.up.removeSelectionListener((SelectionListener)this);
            this.up = null;
        }
        if (this.down != null) {
            this.down.removeSelectionListener((SelectionListener)this);
            this.down = null;
        }
        if (this.remove != null) {
            this.remove.removeSelectionListener((SelectionListener)this);
            this.remove = null;
        }
        super.dispose();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (this.controlsSection != null) {
            this.updateControls();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setLabel(String label) {
        if (this.label == null) {
            this.setLayout((Layout)new GridLayout(2, false));
        }
        super.setLabel(label);
    }

    public void setToolTipText(String text) {
        this.contentControl.setToolTipText(text);
        super.setLabelToolTipText(text);
    }

    @Override
    public void setModelObservable(IObservableList modelProperty) {
        super.setModelObservable(modelProperty);
        if (this.controlsSection != null) {
            this.updateControls();
        }
    }

    @Override
    public abstract void refreshValue();

    public void setDirectCreation(boolean directCreation) {
        this.directCreation = directCreation;
        if (this.controlsSection != null) {
            this.updateControls();
        }
    }

    public void setDirectCreationWithTreeViewer(boolean directCreationWithTreeViewer) {
        this.directCreationWithTreeViewer = directCreationWithTreeViewer;
        if (this.controlsSection != null) {
            this.updateControls();
        }
    }

    public boolean isDirectCreation() {
        return this.directCreation;
    }

    public boolean isDirectCreationWithTreeViewer() {
        return this.directCreationWithTreeViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(listener);
        }
    }

    protected IStructuredSelection getSelection() {
        return Optional.ofNullable(this.selectionProvider).map(ISelectionProvider::getSelection).filter(IStructuredSelection.class::isInstance).map(IStructuredSelection.class::cast).orElse((IStructuredSelection)StructuredSelection.EMPTY);
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public void updateButtons() {
        Object selection;
        if (this.modelProperty != null && this.upperBound != -1) {
            if (this.modelProperty.size() >= this.upperBound) {
                this.add.setEnabled(false);
            } else {
                this.add.setEnabled(true);
            }
        }
        if ((selection = this.getFirstSelection()) == null) {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
            this.remove.setEnabled(false);
            if (this.edit != null) {
                this.edit.setEnabled(false);
            }
        } else if (this.modelProperty != null) {
            int index = this.modelProperty.indexOf(selection);
            if (index == 0 || -1 == index) {
                this.up.setEnabled(false);
            }
            if (this.modelProperty.size() == index + 1 || -1 == index) {
                this.down.setEnabled(false);
            }
        }
    }

    private Object getFirstSelection() {
        return this.getSelection().getFirstElement();
    }

    protected void directCreateObject(final Object context) {
        if (this.referenceFactory != null && this.referenceFactory.canCreateObject()) {
            this.getOperationExecutor(context).execute(new Callable<Object>(){

                @Override
                public Object call() {
                    Object result = AbstractMultipleValueEditor.this.referenceFactory.createObject((Control)AbstractMultipleValueEditor.this, context);
                    if (result != null) {
                        AbstractMultipleValueEditor.this.modelProperty.add(result);
                        AbstractMultipleValueEditor.this.commit();
                    }
                    return result;
                }
            }, NLS.bind((String)Messages.MultipleValueEditor_addOperation, (Object)this.labelText));
        }
    }

    @Override
    public void changeColorField() {
    }
}

