/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.providers;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionSingleton;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionsRegistry;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.InducedRepresentationCreationEditPolicy;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class InducedRepresentationPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider {
    private DiagramExpansionsRegistry diagramExpansionRegistry = DiagramExpansionSingleton.getInstance().getDiagramExpansionRegistry();

    protected String getDiagramType(View currentView) {
        Diagram diagram = currentView.getDiagram();
        String currentDiagramType = null;
        ViewPrototype viewPrototype = DiagramUtils.getPrototype((Diagram)diagram);
        currentDiagramType = viewPrototype != null ? viewPrototype.getLabel() : diagram.getType();
        return currentDiagramType;
    }

    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation = (CreateEditPoliciesOperation)operation;
        if (!(epOperation.getEditPart() instanceof IGraphicalEditPart)) {
            return false;
        }
        IGraphicalEditPart gep = (IGraphicalEditPart)epOperation.getEditPart();
        String diagramType = this.getDiagramType(gep.getNotationView());
        return this.diagramExpansionRegistry.mapChildreen.get(diagramType) != null;
    }

    public void createEditPolicies(EditPart editPart) {
        if (editPart instanceof IGraphicalEditPart) {
            editPart.installEditPolicy((Object)"InducedRepresentationCreationEditPolicy", (EditPolicy)new InducedRepresentationCreationEditPolicy());
        }
    }
}

