/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CInteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;

public class ResizeOperandEditPolicy
extends GraphicalEditPolicy {
    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.activate();
    }

    public Command getCommand(Request request) {
        CreateViewAndElementRequest req;
        CreateViewAndElementRequest.ViewAndElementDescriptor descriptor;
        IElementType elementType;
        if (request instanceof CreateViewAndElementRequest && ElementUtil.isTypeOf((IElementType)(elementType = (IElementType)(descriptor = (req = (CreateViewAndElementRequest)request).getViewAndElementDescriptor()).getElementAdapter().getAdapter(IElementType.class)), (IElementType)UMLDIElementTypes.INTERACTION_OPERAND_SHAPE)) {
            Node combinedFragmentNode = (Node)((GraphicalEditPart)this.getHost().getParent()).getNotationView();
            int height = ((Bounds)combinedFragmentNode.getLayoutConstraint()).getHeight();
            if (this.getHost().getChildren().size() > 0) {
                int newHeight = height + CInteractionOperandEditPart.DEFAULT_HEIGHT;
                return new ICommandProxy((ICommand)new SetResizeCommand(this.getEditingDomain(), "set dimension", (IAdaptable)new EObjectAdapter((EObject)combinedFragmentNode), new Dimension(BoundForEditPart.getWidthFromView(combinedFragmentNode), newHeight)));
            }
        }
        if ("resize children".equals(request.getType())) {
            CompositeCommand compositeCommand = new CompositeCommand("Resize Operands");
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            List editParts = changeBoundsRequest.getEditParts();
            if (editParts.size() > 1) {
                return null;
            }
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            Object currentEditPart = editParts.get(0);
            this.updateCurrentChildSize(compositeCommand, changeBoundsRequest, editingDomain, currentEditPart);
            return new ICommandProxy((ICommand)compositeCommand);
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return editingDomain;
    }

    private void updateCurrentChildSize(CompositeCommand compositeCommand, ChangeBoundsRequest changeBoundsRequest, TransactionalEditingDomain editingDomain, Object currentEditPart) {
        GraphicalEditPart operandPart = (GraphicalEditPart)currentEditPart;
        View shapeView = NotationHelper.findView((Object)operandPart);
        Dimension size = operandPart.getFigure().getSize();
        size.expand(changeBoundsRequest.getSizeDelta().width, changeBoundsRequest.getSizeDelta().height);
        SetResizeCommand setBoundsCommand = new SetResizeCommand(editingDomain, "Resize Operands", (IAdaptable)new EObjectAdapter((EObject)shapeView), size);
        compositeCommand.add((IUndoableOperation)setBoundsCommand);
    }
}

