/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.profile.drafter.commands.CreateProfileAndProfileResourceCommand;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.DraftProfileException;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.papyrus.uml.profile.drafter.ui.dialog.IStereotypeUpdateArgs;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MetaclassesModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.PropertyModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StereoptypeModel;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.tools.profile.definition.ProfileRedefinition;
import org.eclipse.papyrus.uml.tools.profile.definition.Version;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class ProfileApplicator {
    protected NamedElement umlElement;

    public ProfileApplicator(NamedElement umlElement) {
        this.umlElement = umlElement;
    }

    public NamedElement getUmlElement() {
        return this.umlElement;
    }

    public List<Profile> getAppliedProfiles() {
        return this.umlElement.getNearestPackage().getAppliedProfiles();
    }

    public void updateStereotype(IStereotypeUpdateArgs updateArgs) throws DraftProfileException {
        String profileName = updateArgs.getProfileName();
        String stereotypeName = updateArgs.getStereotypeName();
        boolean isProfileModified = false;
        Package applicantPackage = null;
        PapyrusDefinitionAnnotation annotations = null;
        Stereotype stereotype = null;
        Profile profile = this.umlElement.getNearestPackage().getAppliedProfile(profileName, true);
        if (profile == null) {
            profile = this.createProfile(profileName);
            stereotype = this.createStereotype(profile, stereotypeName);
            applicantPackage = this.umlElement.getNearestPackage();
            annotations = this.createPapyrusDefinitionAnnotation(0, 0, 1);
            isProfileModified = true;
        } else {
            stereotype = profile.getOwnedStereotype(stereotypeName, true);
            applicantPackage = this.getApplicantPackage(profile);
            if (stereotype == null) {
                stereotype = this.createStereotype(profile, stereotypeName);
                annotations = this.createUpdatedPapyrusDefinitionAnnotation(profile, 0, 0, 1);
                isProfileModified = true;
            }
        }
        if (!updateArgs.getExtendedMetaclasses().isEmpty()) {
            boolean bl = isProfileModified = this.updateStereotypeMetaclasses(stereotype, updateArgs.getExtendedMetaclasses()) || isProfileModified;
        }
        if (isProfileModified) {
            this.definesAllProfiles((Package)profile);
            this.redefineAllProfiles(profile, annotations);
            this.cleanAllProfiles(profile);
            this.applyProfile(applicantPackage, profile);
        }
        this.applyStereotype(stereotype);
    }

    private boolean updateStereotypeMetaclasses(Stereotype stereotype, List<Class> extendedMetaclasses) {
        boolean updated = false;
        for (Class metaclass : extendedMetaclasses) {
            boolean bl = updated = this.updateMetaclassToStereotype(stereotype, metaclass) || updated;
        }
        return updated;
    }

    private boolean updateMetaclassToStereotype(Stereotype stereotype, Class metaclass) {
        if (stereotype.getExtendedMetaclasses().contains((Object)metaclass)) {
            return false;
        }
        ElementImport target = stereotype.getProfile().getMetaclassReference((PackageableElement)metaclass, true);
        Extension extension = stereotype.createExtension(metaclass, false);
        stereotype.getNearestPackage().getPackagedElements().add((Object)extension);
        return true;
    }

    public void applyStereotype(String profileName, String stereotypeName) throws DraftProfileException {
        Stereotype stereotype;
        Profile profile = this.umlElement.getNearestPackage().getAppliedProfile(profileName, true);
        if (profile == null) {
            profile = this.createProfile(profileName);
            this.applyProfileToUmlElement(profile);
        }
        if ((stereotype = profile.getApplicableStereotype(stereotypeName)) == null) {
            stereotype = this.createStereotypeAndRedefineProfile(profile, stereotypeName);
        }
        this.applyStereotype(stereotype);
    }

    public void applyStereotype2(String profileName, String stereotypeName) throws DraftProfileException {
        boolean isProfileModified = false;
        Package applicantPackage = null;
        PapyrusDefinitionAnnotation annotations = null;
        Stereotype stereotype = null;
        Profile profile = this.umlElement.getNearestPackage().getAppliedProfile(profileName, true);
        if (profile == null) {
            profile = this.createProfile(profileName);
            stereotype = this.createStereotype(profile, stereotypeName, "Class");
            applicantPackage = this.umlElement.getNearestPackage();
            annotations = this.createPapyrusDefinitionAnnotation(0, 0, 1);
            isProfileModified = true;
        } else {
            stereotype = profile.getOwnedStereotype(stereotypeName, true);
            if (stereotype == null) {
                stereotype = this.createStereotype(profile, stereotypeName, "Class");
                applicantPackage = this.getApplicantPackage(profile);
                annotations = this.createUpdatedPapyrusDefinitionAnnotation(profile, 0, 0, 1);
                isProfileModified = true;
            }
        }
        if (isProfileModified) {
            this.definesAllProfiles((Package)profile);
            this.redefineAllProfiles(profile, annotations);
            this.cleanAllProfiles(profile);
            this.applyProfile(applicantPackage, profile);
        }
        this.applyStereotype(stereotype);
    }

    private void applyProfile(Package applicantPackage, Profile profile) {
        applicantPackage.applyProfile(profile);
    }

    private IStatus validateAllProfiles(EObject rootObject, List<EPackage> objectsToValidate) {
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)rootObject);
        AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
        Diagnostician diagnostician = this.createDiagnostician(adapterFactory, (IProgressMonitor)new NullProgressMonitor());
        BasicDiagnostic diagnostic = diagnostician.createDefaultDiagnostic(rootObject);
        Map context = diagnostician.createDefaultContext();
        for (EPackage ePackage : objectsToValidate) {
            diagnostician.validate((EObject)ePackage, (DiagnosticChain)diagnostic, context);
        }
        if (diagnostic.getSeverity() == 4) {
            return new Status(4, "org.eclipse.papyrus.uml.profile", "The defined profile is invalid");
        }
        if (diagnostic.getSeverity() == 2) {
            return new Status(2, "org.eclipse.papyrus.uml.profile", "The profile has been successfully defined");
        }
        return Status.OK_STATUS;
    }

    private void definesAllProfiles(Package container) {
        this.defineAllProfiles(container, true);
    }

    private void redefineAllProfiles(Profile profile, PapyrusDefinitionAnnotation annotations) {
        ProfileRedefinition.redefineProfile((Package)profile, (PapyrusDefinitionAnnotation)annotations);
    }

    private void cleanAllProfiles(Profile profile) {
        ProfileRedefinition.cleanProfile((Package)profile);
    }

    private void applyProfileToUmlElement(Profile profile) throws DraftProfileException {
        Package nearestPackage = this.umlElement.getNearestPackage();
        if (nearestPackage == null) {
            throw new DraftProfileException("Can't get nearest Package for element '" + this.umlElement.getName() + "'");
        }
        nearestPackage.applyProfile(profile);
    }

    private Profile createProfile(String profileName) {
        CreateProfileAndProfileResourceCommand createCmd = new CreateProfileAndProfileResourceCommand(profileName, this.getModelSet());
        createCmd.execute();
        return createCmd.getResultProfile();
    }

    private ModelSet getModelSet() {
        ResourceSet rs = this.umlElement.eResource().getResourceSet();
        return (ModelSet)rs;
    }

    public void applyStereotype(Stereotype stereotype) {
        if (this.umlElement.getStereotypeApplication(stereotype) != null) {
            return;
        }
        this.umlElement.applyStereotype(stereotype);
    }

    protected Stereotype createStereotype(Profile profile, String stereotypeName) {
        Stereotype stereotype = UMLFactory.eINSTANCE.createStereotype();
        stereotype.setName(stereotypeName);
        profile.getPackagedElements().add((Object)stereotype);
        return stereotype;
    }

    protected Stereotype createStereotype(Profile profile, String stereotypeName, String metaclassName) throws NotFoundException {
        Stereotype stereotype = this.createStereotype(profile, stereotypeName);
        if (metaclassName != null) {
            ElementImport target = this.getElementImportByName((Element)this.umlElement, metaclassName);
            Extension extension = this.createExtension(stereotype, (Type)target.getImportedElement());
            extension.setName("E_" + stereotype.getName());
            profile.getPackagedElements().add((Object)extension);
        }
        return stereotype;
    }

    protected Stereotype createStereotypeAndRedefineProfile(Profile profile, String stereotypeName) {
        Package applicantPackage = this.getApplicantPackage(profile);
        Stereotype stereotype = UMLFactory.eINSTANCE.createStereotype();
        stereotype.setName(stereotypeName);
        profile.getPackagedElements().add((Object)stereotype);
        ElementImport target = this.lookupElementImportByName((Element)profile, "Class");
        Extension extension = this.createExtension(stereotype, (Type)target.getImportedElement());
        extension.setName("E_" + stereotype.getName());
        profile.getPackagedElements().add((Object)extension);
        profile.define();
        Version curVersion = Util.getProfileDefinitionVersion((Profile)profile);
        Version version = new Version(curVersion.getMajor(), curVersion.getMinor(), curVersion.getMicro() + 4);
        PapyrusDefinitionAnnotation papyrusAnnotation = new PapyrusDefinitionAnnotation(version, "", "", "", "");
        ProfileRedefinition.redefineProfile((Package)profile, (PapyrusDefinitionAnnotation)papyrusAnnotation);
        ProfileRedefinition.cleanProfile((Package)profile);
        applicantPackage.applyProfile(profile);
        return stereotype;
    }

    protected PapyrusDefinitionAnnotation createUpdatedPapyrusDefinitionAnnotation(Profile profile, int majorInc, int minorInc, int microInc) {
        Version curVersion = Util.getProfileDefinitionVersion((Profile)profile);
        Version version = new Version(curVersion.getMajor() + majorInc, curVersion.getMinor() + minorInc, curVersion.getMicro() + microInc);
        PapyrusDefinitionAnnotation papyrusAnnotation = new PapyrusDefinitionAnnotation(version, "", "", "", "");
        return papyrusAnnotation;
    }

    protected PapyrusDefinitionAnnotation createPapyrusDefinitionAnnotation(int majorInc, int minorInc, int microInc) {
        Version version = new Version(majorInc, minorInc, microInc);
        Date date = new Date();
        PapyrusDefinitionAnnotation papyrusAnnotation = new PapyrusDefinitionAnnotation(version, "", "", DateFormat.getInstance().format(date), "");
        return papyrusAnnotation;
    }

    private Package getApplicantPackage(Profile profile) {
        ProfileApplication profileApplication = null;
        Package container = this.umlElement.getNearestPackage();
        while (profileApplication == null && container != null) {
            profileApplication = container.getProfileApplication(profile);
            if (profileApplication != null) {
                return container;
            }
            container = container.getNestingPackage();
        }
        return null;
    }

    public ProfileApplication getNearestProfileApplication(Profile profile) {
        ProfileApplication profileApplication = null;
        Package container = this.umlElement.getNearestPackage();
        while (profileApplication == null && container != null) {
            profileApplication = container.getProfileApplication(profile);
            container = container.getNestingPackage();
        }
        return profileApplication;
    }

    private ElementImport getElementImportByName(Element fromElement, String aliasName) throws NotFoundException {
        ElementImport elementImport = this.lookupElementImportByName(fromElement, aliasName);
        if (elementImport == null) {
            elementImport = this.createMetaclassElementImport(fromElement, aliasName);
        }
        return elementImport;
    }

    private ElementImport getMetaclassElementImport(Element fromElement, Class metaclass) {
        ElementImport elementImport = this.lookupElementImportByName(fromElement, metaclass.getName());
        if (elementImport == null) {
            elementImport = this.createMetaclassElementImport(fromElement, metaclass);
        }
        return elementImport;
    }

    private ElementImport createMetaclassElementImport(Element fromElement, String aliasName) throws NotFoundException {
        Class metaclass = this.getUmlMetaClass(aliasName, fromElement);
        return this.createMetaclassElementImport(fromElement, metaclass);
    }

    private ElementImport createMetaclassElementImport(Element fromElement, Class metaclass) {
        ElementImport elementImport = this.getRootPackageContainer(fromElement).createElementImport((PackageableElement)metaclass);
        elementImport.setAlias(metaclass.getName());
        return elementImport;
    }

    private Package getRootPackageContainer(Element element) {
        return (Package)EcoreUtil.getRootContainer((EObject)element);
    }

    protected Class getUmlMetaClass(String metaclassName, Element ressourceLocator) throws NotFoundException {
        List metaclasses = ElementUtil.getPossibleMetaclasses((Element)ressourceLocator);
        for (Class curClass : metaclasses) {
            if (!curClass.getName().equals(metaclassName)) continue;
            return curClass;
        }
        throw new NotFoundException("No uml metaclass found with name '" + metaclassName + "'");
    }

    private ElementImport lookupElementImportByName(Element fromElement, String aliasName) {
        if (fromElement == null) {
            return null;
        }
        if (fromElement instanceof Package) {
            Package container = (Package)fromElement;
            for (ElementImport ele : container.getElementImports()) {
                if (!aliasName.equals(ele.getAlias())) continue;
                return ele;
            }
            return this.lookupElementImportByName((Element)container.getNestingPackage(), aliasName);
        }
        return this.lookupElementImportByName((Element)fromElement.getNearestPackage(), aliasName);
    }

    protected Extension createExtension(Stereotype source, Type target) {
        Extension newExtension = UMLFactory.eINSTANCE.createExtension();
        ExtensionEnd endSource = UMLFactory.eINSTANCE.createExtensionEnd();
        endSource.setName("extension_" + source.getName());
        endSource.setType((Type)source);
        endSource.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        newExtension.getOwnedEnds().add((Object)endSource);
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName("base_" + target.getName());
        property.setType(target);
        property.setAssociation((Association)newExtension);
        property.setAggregation(AggregationKind.NONE_LITERAL);
        newExtension.getMemberEnds().add((Object)property);
        source.getOwnedAttributes().add((Object)property);
        return newExtension;
    }

    protected List<EPackage> defineAllProfiles(Package container, boolean saveConstraintInDef) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        if (container instanceof Profile) {
            Map<String, String> options = this.createProfileDefinitionOptions(saveConstraintInDef);
            EPackage profileDefinition = ((Profile)container).define(options, null, null);
            result.add(profileDefinition);
        }
        for (Package nestedPackage : container.getNestedPackages()) {
            List<EPackage> profileDefinitions = this.defineAllProfiles(nestedPackage, saveConstraintInDef);
            result.addAll(profileDefinitions);
        }
        return result;
    }

    private Map<String, String> createProfileDefinitionOptions(boolean saveConstraintInDef) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ECORE_TAGGED_VALUES", "PROCESS");
        options.put("DERIVED_FEATURES", "REPORT");
        options.put("DUPLICATE_FEATURE_INHERITANCE", "PROCESS");
        options.put("DUPLICATE_FEATURES", "PROCESS");
        options.put("DUPLICATE_OPERATIONS", "REPORT");
        options.put("DUPLICATE_OPERATION_INHERITANCE", "REPORT");
        options.put("REDEFINING_OPERATIONS", "REPORT");
        options.put("REDEFINING_PROPERTIES", "REPORT");
        options.put("SUBSETTING_PROPERTIES", "REPORT");
        options.put("UNION_PROPERTIES", "PROCESS");
        options.put("SUPER_CLASS_ORDER", "REPORT");
        options.put("ANNOTATION_DETAILS", "REPORT");
        String handleConstraints = saveConstraintInDef ? "PROCESS" : "IGNORE";
        options.put("INVARIANT_CONSTRAINTS", handleConstraints);
        options.put("VALIDATION_DELEGATES", handleConstraints);
        options.put("INVOCATION_DELEGATES", handleConstraints);
        options.put("OPERATION_BODIES", handleConstraints);
        options.put("COMMENTS", "IGNORE");
        options.put("FOREIGN_DEFINITIONS", "IGNORE");
        options.put("UNTYPED_PROPERTIES", "PROCESS");
        return options;
    }

    protected Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    public void updateStereotype(StereoptypeModel stereoptypeModel) throws DraftProfileException {
        String profileName = stereoptypeModel.getProfileName();
        String stereotypeName = stereoptypeModel.getStereotypeName();
        boolean isProfileModified = false;
        Package applicantPackage = null;
        PapyrusDefinitionAnnotation annotations = null;
        Stereotype stereotype = null;
        Profile profile = this.umlElement.getNearestPackage().getAppliedProfile(profileName, true);
        if (profile == null) {
            profile = this.createProfile(profileName);
            stereotype = this.createStereotype(profile, stereotypeName);
            applicantPackage = this.umlElement.getNearestPackage();
            annotations = this.createPapyrusDefinitionAnnotation(0, 0, 1);
            isProfileModified = true;
        } else {
            stereotype = profile.getOwnedStereotype(stereotypeName, true);
            applicantPackage = this.getApplicantPackage(profile);
            if (stereotype == null) {
                stereotype = this.createStereotype(profile, stereotypeName);
                annotations = this.createUpdatedPapyrusDefinitionAnnotation(profile, 0, 0, 1);
                isProfileModified = true;
            }
        }
        MetaclassesModel metaclassesModel = stereoptypeModel.getMetaclassesCollection();
        if (!metaclassesModel.getSelectedMetaclasses().isEmpty()) {
            boolean bl = isProfileModified = this.updateStereotypeMetaclasses(stereotype, metaclassesModel.getSelectedMetaclasses()) || isProfileModified;
        }
        if (!stereoptypeModel.getProperties().isEmpty()) {
            boolean bl = isProfileModified = this.createOrUpdateProperties(stereotype, stereoptypeModel.getProperties()) || isProfileModified;
        }
        if (isProfileModified) {
            this.definesAllProfiles((Package)profile);
            this.redefineAllProfiles(profile, annotations);
            this.cleanAllProfiles(profile);
            this.applyProfile(applicantPackage, profile);
        }
        this.applyStereotype(stereotype);
        if (!stereoptypeModel.getProperties().isEmpty()) {
            this.updatePropertyValues(stereotype, stereoptypeModel.getProperties());
        }
    }

    private void updatePropertyValues(Stereotype stereotype, List<PropertyModel> properties) {
        for (PropertyModel propertyModel : properties) {
            this.updatePropertyValue(stereotype, propertyModel);
        }
    }

    private void updatePropertyValue(Stereotype stereotype, PropertyModel propertyModel) {
        Object actualValue = this.getUmlElement().getValue(stereotype, propertyModel.getProposedName());
        if (propertyModel.isValueModified()) {
            String valueAsStr = propertyModel.getValue();
            if (valueAsStr == null || valueAsStr.length() == 0) {
                this.getUmlElement().setValue(stereotype, propertyModel.getProposedName(), null);
                return;
            }
            Object newValue = Util.getValueObjectFromString((String)valueAsStr, (Type)propertyModel.getType());
            this.getUmlElement().setValue(stereotype, propertyModel.getProposedName(), newValue);
        }
    }

    private boolean createOrUpdateProperties(Stereotype stereotype, List<PropertyModel> properties) {
        boolean isUpdated = false;
        for (PropertyModel propertyModel : properties) {
            boolean bl = isUpdated = this.createOrUpdateProperty(stereotype, propertyModel) || isUpdated;
        }
        return isUpdated;
    }

    private boolean createOrUpdateProperty(Stereotype stereotype, PropertyModel propertyModel) {
        boolean isUpdated = false;
        boolean isPropertyExistIn = propertyModel.isPropertyExistIn(stereotype);
        switch (propertyModel.getStateKind()) {
            case modified: {
                if (!isPropertyExistIn) break;
                isUpdated = this.updateProperty(stereotype, propertyModel);
                break;
            }
            case created: {
                if (isPropertyExistIn) break;
                isUpdated = this.createProperty(stereotype, propertyModel);
                break;
            }
        }
        return isUpdated;
    }

    private boolean updateProperty(Stereotype stereotype, PropertyModel propertyModel) {
        boolean isUpdated = false;
        String newName = propertyModel.getProposedName();
        System.err.println("updateProperty(" + stereotype.getName() + "." + propertyModel.getProposedName());
        if (newName != null && !newName.equals(stereotype.getName())) {
            stereotype.setName(newName);
            isUpdated = true;
        }
        return isUpdated;
    }

    private boolean createProperty(Stereotype stereotype, PropertyModel propertyModel) {
        boolean isUpdated = true;
        stereotype.createOwnedAttribute(propertyModel.getProposedName(), propertyModel.getType());
        return isUpdated;
    }
}

