/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureFramework;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureEditPlugin;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureItemProviderAdapterFactory;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.viewpoints.policy.providers.MergedArchitectureDescriptionLanguageItemProvider;
import org.eclipse.papyrus.infra.viewpoints.policy.providers.MergedArchitectureFrameworkItemProvider;
import org.eclipse.papyrus.infra.viewpoints.policy.providers.MergedArchitectureViewpointItemProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ViewpointExplorer
extends ViewPart {
    private TreeViewer tree;
    private IPartListener listener;
    private ArchitectureItemProviderAdapterFactory architectureAdapterFactory = new ArchitectureItemProviderAdapterFactory();
    private ComposedAdapterFactory adapterFactory = new ViewpointAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
    private AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    private AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, null, new HashMap()){

        public boolean isReadOnly(Resource resource) {
            return true;
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite inner = new Composite(parent, 0);
        inner.setLayoutData((Object)new GridData(1808));
        inner.setLayout((Layout)new FillLayout());
        this.tree = new TreeViewer(inner, 2816);
        this.tree.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(this.adapterFactory));
        this.tree.setContentProvider((IContentProvider)this.createContentProvider(this.adapterFactory));
        this.listener = this.createSelectionListener(this.tree);
        this.getSite().getPage().addPartListener(this.listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tree);
    }

    public void dispose() {
        if (this.listener != null) {
            this.getSite().getPage().removePartListener(this.listener);
        }
    }

    public void setFocus() {
    }

    private ILabelProvider createLabelProvider(ComposedAdapterFactory adapterFactory) {
        return new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof PropertySource) {
                    element = ((PropertySource)element).getObject();
                }
                if (element instanceof MergedArchitectureDescriptionLanguage) {
                    Object object = ArchitectureEditPlugin.INSTANCE.getImage("full/obj16/ArchitectureDescriptionLanguage");
                    return ExtendedImageRegistry.INSTANCE.getImage(object);
                }
                if (element instanceof MergedArchitectureFramework) {
                    Object object = ArchitectureEditPlugin.INSTANCE.getImage("full/obj16/ArchitectureFramework");
                    return ExtendedImageRegistry.INSTANCE.getImage(object);
                }
                if (element instanceof MergedArchitectureViewpoint) {
                    Object object = ArchitectureEditPlugin.INSTANCE.getImage("full/obj16/ArchitectureViewpoint");
                    return ExtendedImageRegistry.INSTANCE.getImage(object);
                }
                return ViewpointExplorer.this.labelProvider.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof PropertySource) {
                    element = ((PropertySource)element).getObject();
                }
                if (element instanceof MergedArchitectureDescriptionLanguage) {
                    String text = ArchitectureEditPlugin.INSTANCE.getString("_UI_ArchitectureDescriptionLanguage_type");
                    return String.valueOf(text) + " " + ((MergedArchitectureDescriptionLanguage)element).getName();
                }
                if (element instanceof MergedArchitectureFramework) {
                    String text = ArchitectureEditPlugin.INSTANCE.getString("_UI_ArchitectureFramework_type");
                    return String.valueOf(text) + " " + ((MergedArchitectureFramework)element).getName();
                }
                if (element instanceof MergedArchitectureViewpoint) {
                    String text = ArchitectureEditPlugin.INSTANCE.getString("_UI_ArchitectureViewpoint_type");
                    return String.valueOf(text) + " " + ((MergedArchitectureViewpoint)element).getName();
                }
                return ViewpointExplorer.this.labelProvider.getText(element);
            }
        };
    }

    private ITreeContentProvider createContentProvider(ComposedAdapterFactory adapterFactory) {
        return new ITreeContentProvider(){
            private ArchitectureDescriptionUtils utils;

            public boolean hasChildren(Object element) {
                return this.getChildren(element) != null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ModelSet) {
                    this.utils = new ArchitectureDescriptionUtils((ModelSet)inputElement);
                    return ViewpointExplorer.this.getPropertySources(new Object[]{this.utils.getArchitectureContext()});
                }
                this.utils = null;
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof PropertySource) {
                    if ((parentElement = ((PropertySource)parentElement).getObject()) instanceof MergedArchitectureContext) {
                        return ViewpointExplorer.this.getPropertySources(this.utils.getArchitectureViewpoints().toArray());
                    }
                    if (parentElement instanceof MergedArchitectureViewpoint) {
                        return ViewpointExplorer.this.getPropertySources(((MergedArchitectureViewpoint)parentElement).getRepresentationKinds().toArray());
                    }
                    return ViewpointExplorer.this.getPropertySources(ViewpointExplorer.this.contentProvider.getChildren(parentElement));
                }
                return null;
            }
        };
    }

    private IPartListener createSelectionListener(final TreeViewer viewer) {
        return new IPartListener(){
            private IWorkbenchPart editor;

            public void partActivated(IWorkbenchPart part) {
                ResourceSet resourceSet;
                EditingDomain domain;
                if (part == this.editor) {
                    viewer.refresh();
                } else if (part instanceof IMultiDiagramEditor && (domain = (EditingDomain)part.getAdapter(EditingDomain.class)) != null && (resourceSet = domain.getResourceSet()) instanceof ModelSet) {
                    this.editor = part;
                    viewer.setInput((Object)((ModelSet)resourceSet));
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                boolean cfr_ignored_0 = part instanceof IMultiDiagramEditor;
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == this.editor) {
                    viewer.setInput(null);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                boolean cfr_ignored_0 = part instanceof IMultiDiagramEditor;
            }

            public void partOpened(IWorkbenchPart part) {
                boolean cfr_ignored_0 = part instanceof IMultiDiagramEditor;
            }
        };
    }

    public Object[] getPropertySources(Object[] objects) {
        ArrayList<Object> propertySources = new ArrayList<Object>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            propertySources.add(this.getPropertySource(object));
            ++n2;
        }
        return propertySources.toArray();
    }

    public Object getPropertySource(Object object) {
        if (object instanceof EObject) {
            return this.contentProvider.getPropertySource(object);
        }
        if (object instanceof MergedArchitectureViewpoint) {
            MergedArchitectureViewpointItemProvider source = new MergedArchitectureViewpointItemProvider((AdapterFactory)this.architectureAdapterFactory);
            return new PropertySource(object, (IItemPropertySource)source);
        }
        if (object instanceof MergedArchitectureFramework) {
            MergedArchitectureFrameworkItemProvider source = new MergedArchitectureFrameworkItemProvider((AdapterFactory)this.architectureAdapterFactory);
            return new PropertySource(object, (IItemPropertySource)source);
        }
        if (object instanceof MergedArchitectureDescriptionLanguage) {
            MergedArchitectureDescriptionLanguageItemProvider source = new MergedArchitectureDescriptionLanguageItemProvider((AdapterFactory)this.architectureAdapterFactory);
            return new PropertySource(object, (IItemPropertySource)source);
        }
        return object;
    }

    private class ViewpointAdapterFactory
    extends ComposedAdapterFactory
    implements IEditingDomainProvider {
        public ViewpointAdapterFactory(ComposedAdapterFactory.Descriptor.Registry adapterFactoryDescriptorRegistry) {
            super(adapterFactoryDescriptorRegistry);
        }

        public EditingDomain getEditingDomain() {
            return ViewpointExplorer.this.editingDomain;
        }
    }
}

