/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TooltipHook {
    private EditPartViewer viewer;
    private ToolTipHelper toolTipHelper;
    private Shell toolTipShell;
    private boolean toolTipDisplayed;
    private Listener hideListener;
    private Listener showListener;
    private IFigure toolTipSource;

    public TooltipHook(EditPartViewer viewer) {
        this.viewer = viewer;
        this.hookViewer();
    }

    public boolean isHooked(EditPartViewer viewer) {
        if (viewer == null) {
            return false;
        }
        return viewer == this.viewer;
    }

    private void hookViewer() {
        if (this.viewer == null) {
            return;
        }
        try {
            Method m = GraphicalViewerImpl.class.getDeclaredMethod("getLightweightSystem", new Class[0]);
            m.setAccessible(true);
            LightweightSystem lws = (LightweightSystem)m.invoke((Object)this.viewer, new Object[0]);
            Field f = LightweightSystem.class.getDeclaredField("dispatcher");
            f.setAccessible(true);
            EventDispatcher dispatcher = (EventDispatcher)f.get(lws);
            if (dispatcher instanceof SWTEventDispatcher) {
                Field df = SWTEventDispatcher.class.getDeclaredField("toolTipHelper");
                df.setAccessible(true);
                this.toolTipHelper = (ToolTipHelper)df.get(dispatcher);
            }
            if (this.toolTipHelper == null) {
                return;
            }
            Method m2 = PopUpHelper.class.getDeclaredMethod("getShell", new Class[0]);
            m2.setAccessible(true);
            this.toolTipShell = (Shell)m2.invoke((Object)this.toolTipHelper, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.toolTipShell != null) {
            this.hideListener = new Listener(){

                public void handleEvent(Event event) {
                    event.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TooltipHook.this.manageToolTip();
                        }
                    });
                }
            };
            this.toolTipShell.addListener(23, this.hideListener);
            this.showListener = new Listener(){

                public void handleEvent(Event event) {
                    event.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TooltipHook.this.toolTipSource = TooltipHook.this.getToolTipSource();
                        }
                    });
                }
            };
            this.toolTipShell.addListener(22, this.showListener);
        }
    }

    private IFigure getToolTipSource() {
        if (this.toolTipHelper == null) {
            return null;
        }
        try {
            Field f = ToolTipHelper.class.getDeclaredField("currentTipSource");
            f.setAccessible(true);
            return (IFigure)f.get(this.toolTipHelper);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void manageToolTip() {
        if (this.toolTipSource == null) {
            this.hideToolTip();
            return;
        }
        IFigure currentToolTipSource = this.getToolTipSource();
        if (this.toolTipSource != currentToolTipSource) {
            this.hideToolTip();
        } else if (this.toolTipShell != null && !this.toolTipShell.isDisposed() && !this.toolTipShell.isVisible()) {
            this.displayToolTip();
        }
    }

    private void displayToolTip() {
        this.toolTipShell.removeListener(22, this.showListener);
        this.toolTipShell.setVisible(true);
        this.toolTipShell.addListener(22, this.showListener);
        this.toolTipDisplayed = true;
    }

    private void hideToolTip() {
        if (this.toolTipDisplayed) {
            this.toolTipShell.removeListener(23, this.hideListener);
            this.toolTipShell.setVisible(false);
            this.toolTipShell.addListener(23, this.hideListener);
            this.toolTipDisplayed = false;
        }
        this.toolTipSource = null;
    }

    public void dispose() {
        this.toolTipSource = null;
        this.toolTipHelper = null;
        if (this.toolTipShell != null && !this.toolTipShell.isDisposed()) {
            this.hideToolTip();
            this.toolTipShell.removeListener(23, this.hideListener);
            this.toolTipShell.removeListener(22, this.showListener);
        }
    }
}

