/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VisibilityKind implements Enumerator
{
    PUBLIC_LITERAL(0, "public", "public"),
    PRIVATE_LITERAL(1, "private", "private"),
    PROTECTED_LITERAL(2, "protected", "protected"),
    PACKAGE_LITERAL(3, "package", "package");

    public static final int PUBLIC = 0;
    public static final int PRIVATE = 1;
    public static final int PROTECTED = 2;
    public static final int PACKAGE = 3;
    private static final VisibilityKind[] VALUES_ARRAY;
    public static final List<VisibilityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VisibilityKind[]{PUBLIC_LITERAL, PRIVATE_LITERAL, PROTECTED_LITERAL, PACKAGE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VisibilityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityKind get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC_LITERAL;
            }
            case 1: {
                return PRIVATE_LITERAL;
            }
            case 2: {
                return PROTECTED_LITERAL;
            }
            case 3: {
                return PACKAGE_LITERAL;
            }
        }
        return null;
    }

    private VisibilityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

