/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SchedulingRuleFactory {
    public static SchedulingRuleFactory INSTANCE = new SchedulingRuleFactory();

    private SchedulingRuleFactory() {
    }

    public ISchedulingRule newSequence() {
        return new Sequence();
    }

    public ISchedulingRule newSerialPerObjectRule(Object lock) {
        return new SerialPerObjectRule(lock);
    }

    public static class Sequence
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof Sequence;
        }
    }

    class SerialPerObjectRule
    implements ISchedulingRule {
        private Object lockObject = null;

        public SerialPerObjectRule(Object lock) {
            this.lockObject = lock;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof SerialPerObjectRule) {
                SerialPerObjectRule serialPerObjectRule = (SerialPerObjectRule)rule;
                return this.lockObject == serialPerObjectRule.lockObject;
            }
            return false;
        }
    }
}

