/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNode;
import org.eclipse.xtext.util.Strings;

public interface IContentOutlineNodeComparer
extends IElementComparer {

    public static class Default
    implements IContentOutlineNodeComparer {
        private static final int PRIME = 47;

        public boolean equals(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a instanceof IContentOutlineNode && b instanceof IContentOutlineNode) {
                IContentOutlineNode aNode = (IContentOutlineNode)a;
                IContentOutlineNode bNode = (IContentOutlineNode)b;
                if (aNode.getClazz() != bNode.getClazz()) {
                    return false;
                }
                if (!Strings.equal((String)aNode.getLabel(), (String)bNode.getLabel())) {
                    return false;
                }
                if (aNode.getImage() != bNode.getImage()) {
                    return false;
                }
                IContentOutlineNode aParent = aNode.getParent();
                IContentOutlineNode bParent = bNode.getParent();
                if (aParent != null) {
                    int bIndex;
                    if (!this.equals(aParent, bParent)) {
                        return false;
                    }
                    Object[] aSiblings = aParent.getChildrenAsArray();
                    Object[] bSiblings = bParent.getChildrenAsArray();
                    int aIndex = ArrayUtils.indexOf((Object[])aSiblings, (Object)aNode);
                    if (aIndex != (bIndex = ArrayUtils.indexOf((Object[])bSiblings, (Object)bNode)) && aSiblings.length - aIndex != bSiblings.length - bIndex) {
                        return false;
                    }
                } else if (bParent != null) {
                    return false;
                }
                return true;
            }
            if (a != null) {
                return a.equals(b);
            }
            return b == null;
        }

        public int hashCode(Object element) {
            if (element instanceof IContentOutlineNode) {
                IContentOutlineNode node = (IContentOutlineNode)element;
                int hashCode = this.addHashCode(0, node.getClazz());
                hashCode = this.addHashCode(hashCode, node.getLabel());
                hashCode = this.addHashCode(hashCode, node.getImage());
                hashCode = hashCode * 47 + (node.getParent() == null ? 0 : this.hashCode(node.getParent()));
                return hashCode;
            }
            return element.hashCode();
        }

        private int addHashCode(int hashCode, Object element) {
            return hashCode * 47 + (element == null ? 0 : element.hashCode());
        }
    }
}

