/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring.antlr;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.TokenSource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AbstractTokenScanner;
import org.eclipse.xtext.ui.editor.syntaxcoloring.antlr.AbstractAntlrTokenToAttributeIdMapper;

public class AntlrTokenScanner
extends AbstractTokenScanner {
    @Inject
    @Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.HIGHLIGHTING")
    private Lexer lexer;
    @Inject
    private AbstractAntlrTokenToAttributeIdMapper tokenIdMapper;
    private int dirtyRegionOffset;
    private CommonToken currentAntlrToken;

    public int getTokenLength() {
        return this.currentAntlrToken.getStopIndex() - this.currentAntlrToken.getStartIndex() + 1;
    }

    public int getTokenOffset() {
        return this.dirtyRegionOffset + this.currentAntlrToken.getStartIndex();
    }

    public IToken nextToken() {
        this.currentAntlrToken = this.nextAntlrToken();
        if (this.currentAntlrToken.getType() == -1) {
            return Token.EOF;
        }
        String id = this.tokenIdMapper.getId(this.currentAntlrToken.getType());
        return new Token((Object)this.getAttribute(id));
    }

    public void setRange(IDocument document, int offset, int length) {
        try {
            String dirtyRegion = document.get(offset, length);
            this.dirtyRegionOffset = offset;
            this.configureTokenSource(dirtyRegion);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void configureTokenSource(String dirtyRegion) {
        this.lexer.setCharStream((CharStream)new ANTLRStringStream(dirtyRegion));
    }

    public CommonToken nextAntlrToken() {
        return (CommonToken)this.getLexer().nextToken();
    }

    public void setTokenIdMapper(AbstractAntlrTokenToAttributeIdMapper tokenIdMapper) {
        this.tokenIdMapper = tokenIdMapper;
    }

    public AbstractAntlrTokenToAttributeIdMapper getTokenIdMapper() {
        return this.tokenIdMapper;
    }

    public void setLexer(Lexer lexer) {
        this.lexer = lexer;
    }

    public TokenSource getLexer() {
        return this.lexer;
    }
}

