/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.highlighting;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class XbaseHighlightingConfiguration
extends DefaultHighlightingConfiguration {
    public static final String STATIC_METHOD_INVOCATION = "xbase.static.method.invocation";
    public static final String STATIC_FIELD = "xbase.static.field";
    public static final String FIELD = "xbase.field";
    public static final String ANNOTATION = "xbase.annotation";
    public static final String EXTENSION_METHOD_INVOCATION = "xbase.extension.method.invacation";
    public static final String EXTENSION_METHOD_INVOCATION_WITH_IMPLICIT_ARGUMENT = "xbase.extension.method.invacation.with.implicit.argument";
    public static final String DEPRECATED_MEMBERS = "xbase.deprecated.members";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting(STATIC_METHOD_INVOCATION, "Static method invocation", this.staticMethodInvocation());
        acceptor.acceptDefaultHighlighting(STATIC_FIELD, "Static Field", this.staticField());
        acceptor.acceptDefaultHighlighting(FIELD, "Field", this.field());
        acceptor.acceptDefaultHighlighting(ANNOTATION, "Annotation", this.annotation());
        acceptor.acceptDefaultHighlighting(EXTENSION_METHOD_INVOCATION, "Extension method invocation", this.extensionMethodInvocation());
        acceptor.acceptDefaultHighlighting(EXTENSION_METHOD_INVOCATION_WITH_IMPLICIT_ARGUMENT, "Method invocation with implicit argument", this.extensionMethodInvocation());
        acceptor.acceptDefaultHighlighting(DEPRECATED_MEMBERS, "Deprecated members", this.deprecatedMembers());
        super.configure(acceptor);
    }

    public TextStyle staticMethodInvocation() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setStyle(2);
        textStyle.setColor(new RGB(0, 0, 0));
        return textStyle;
    }

    public TextStyle staticField() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setStyle(2);
        textStyle.setColor(new RGB(0, 0, 192));
        return textStyle;
    }

    public TextStyle field() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(0, 26, 171));
        return textStyle;
    }

    public TextStyle annotation() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(100, 100, 100));
        return textStyle;
    }

    public TextStyle extensionMethodInvocation() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(171, 48, 0));
        return textStyle;
    }

    public TextStyle deprecatedMembers() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setStyle(0x20000000);
        textStyle.setColor(new RGB(0, 0, 0));
        return textStyle;
    }
}

