/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.jvmmodel;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.lib.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchMethodCompileStrategy
implements Functions.Function1<ImportManager, CharSequence> {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    @Inject
    private Primitives primitives;
    @Inject
    private TypeReferenceSerializer typeReferenceSerializer;
    private List<JvmOperation> sortedDispatchOperations;
    private JvmOperation dispatchOperation;

    protected void initialize(JvmOperation dispatchOperation, List<JvmOperation> sortedDispatchOperations) {
        this.dispatchOperation = dispatchOperation;
        this.sortedDispatchOperations = sortedDispatchOperations;
    }

    public CharSequence apply(ImportManager importManager) {
        final StringBuilderBasedAppendable a = new StringBuilderBasedAppendable(importManager);
        boolean needsElse = true;
        int parameterCount = this.dispatchOperation.getParameters().size();
        boolean[] allCasesSameType = new boolean[parameterCount];
        int i = 0;
        while (i < parameterCount) {
            allCasesSameType[i] = true;
            JvmTypeReference dispatchParameterType = ((JvmFormalParameter)this.dispatchOperation.getParameters().get(i)).getParameterType();
            for (JvmOperation operation : this.sortedDispatchOperations) {
                JvmFormalParameter parameter = (JvmFormalParameter)operation.getParameters().get(i);
                JvmTypeReference caseParameterType = parameter.getParameterType();
                if (EcoreUtil.equals((EObject)dispatchParameterType, (EObject)caseParameterType)) continue;
                allCasesSameType[i] = false;
                break;
            }
            ++i;
        }
        for (JvmOperation operation : this.sortedDispatchOperations) {
            ArrayList laters = Lists.newArrayList();
            int i2 = 0;
            while (i2 < parameterCount) {
                JvmFormalParameter dispatchParam = (JvmFormalParameter)this.dispatchOperation.getParameters().get(i2);
                final JvmTypeReference dispatchParamType = dispatchParam.getParameterType();
                JvmFormalParameter caseParam = (JvmFormalParameter)operation.getParameters().get(i2);
                final JvmTypeReference caseParamType = caseParam.getParameterType();
                final String name = this.getVarName((JvmIdentifiableElement)dispatchParam, (IAppendable)a);
                if (this.typeReferences.is(caseParamType, Void.class)) {
                    laters.add(new Later(){

                        public void exec() {
                            a.append(name).append(" == null");
                        }
                    });
                } else if (!allCasesSameType[i2]) {
                    laters.add(new Later(){

                        public void exec() {
                            if (DispatchMethodCompileStrategy.this.typeConformanceComputer.isConformant(caseParamType, dispatchParamType, true) && !DispatchMethodCompileStrategy.this.primitives.isPrimitive(dispatchParamType)) {
                                a.append(name).append(" != null");
                            } else {
                                a.append(name).append(" instanceof ");
                                a.append(DispatchMethodCompileStrategy.this.primitives.asWrapperTypeIfPrimitive(caseParamType).getType());
                            }
                        }
                    });
                }
                ++i2;
            }
            if (this.sortedDispatchOperations.get(0) != operation) {
                a.append(" else ");
            }
            if (laters.isEmpty()) {
                needsElse = false;
                a.append("{").increaseIndentation();
            } else {
                a.append("if (");
                a.increaseIndentation().increaseIndentation();
                Iterator iterator = laters.iterator();
                while (iterator.hasNext()) {
                    ((Later)iterator.next()).exec();
                    if (!iterator.hasNext()) continue;
                    a.append("\n && ");
                }
                a.decreaseIndentation().decreaseIndentation();
                a.append(") {").increaseIndentation();
            }
            a.append("\n");
            boolean isCurrentVoid = this.typeReferences.is(operation.getReturnType(), Void.TYPE);
            boolean isDispatchVoid = this.typeReferences.is(this.dispatchOperation.getReturnType(), Void.TYPE);
            if (isDispatchVoid) {
                this.generateActualDispatchCall(this.dispatchOperation, operation, (IAppendable)a);
                a.append(";");
            } else {
                if (isCurrentVoid) {
                    this.generateActualDispatchCall(this.dispatchOperation, operation, (IAppendable)a);
                    a.append(";\nreturn null");
                } else {
                    a.append("return ");
                    this.generateActualDispatchCall(this.dispatchOperation, operation, (IAppendable)a);
                }
                a.append(";");
            }
            a.decreaseIndentation().append("\n}");
        }
        if (needsElse) {
            a.append(" else {").increaseIndentation();
            a.append("\n");
            a.increaseIndentation();
            a.append("throw new IllegalArgumentException(\"Unhandled parameter types: \" +\n");
            JvmType jvmType = this.typeReferences.findDeclaredType("java.util.Arrays", (Notifier)this.dispatchOperation);
            a.append(jvmType).append(".<Object>asList(");
            Iterator iterator = this.dispatchOperation.getParameters().iterator();
            while (iterator.hasNext()) {
                JvmFormalParameter parameter = (JvmFormalParameter)iterator.next();
                String name = this.getVarName((JvmIdentifiableElement)parameter, (IAppendable)a);
                a.append(name);
                if (!iterator.hasNext()) continue;
                a.append(", ");
            }
            a.append(").toString());");
            a.decreaseIndentation();
            a.decreaseIndentation().append("\n}");
        }
        return a.toString();
    }

    protected void generateActualDispatchCall(JvmOperation dispatchOperation, JvmOperation actualOperationToCall, IAppendable a) {
        a.append(actualOperationToCall.getSimpleName()).append("(");
        Iterator iter1 = dispatchOperation.getParameters().iterator();
        Iterator iter2 = actualOperationToCall.getParameters().iterator();
        while (iter2.hasNext()) {
            JvmFormalParameter p1 = (JvmFormalParameter)iter1.next();
            JvmFormalParameter p2 = (JvmFormalParameter)iter2.next();
            if (!this.typeConformanceComputer.isConformant(p2.getParameterType(), p1.getParameterType(), true)) {
                a.append("(");
                this.typeReferenceSerializer.serialize(this.primitives.asWrapperTypeIfPrimitive(p2.getParameterType()), (EObject)dispatchOperation, a);
                a.append(")");
            }
            if (this.typeReferences.is(p2.getParameterType(), Void.class)) {
                a.append("null");
            } else {
                a.append(this.getVarName((JvmIdentifiableElement)p1, a));
            }
            if (!iter2.hasNext()) continue;
            a.append(", ");
        }
        a.append(")");
    }

    protected String getVarName(JvmIdentifiableElement ex, IAppendable appendable) {
        return ex.getSimpleName();
    }
}

