/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.resource;

import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xtend2.jvmmodel.DispatchUtil;
import org.eclipse.xtext.xtend2.resource.DescriptionFlags;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xtend2ResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    private static final Logger LOG = Logger.getLogger(Xtend2ResourceDescriptionStrategy.class);
    @Inject
    private DispatchUtil dispatchUtil;
    @Inject
    private DescriptionFlags descriptionFlags;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, this.createUserData(eObject)));
            }
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getMessage());
        }
        return true;
    }

    protected Map<String, String> createUserData(EObject eObject) {
        if (eObject instanceof JvmOperation) {
            return this.createUserData(this.getFlags((JvmOperation)eObject));
        }
        if (eObject instanceof JvmField) {
            return this.createUserData(this.getFlags((JvmField)eObject));
        }
        if (eObject instanceof XtendFunction) {
            return this.createUserData(this.getFlags((XtendFunction)eObject));
        }
        if (eObject instanceof XtendField) {
            return this.createUserData(this.getFlags((XtendField)eObject));
        }
        return null;
    }

    protected Map<String, String> createUserData(int flags) {
        return flags != 0 ? ImmutableSortedMap.of((Comparable)((Object)"Flags"), (Object)Integer.toString(flags)) : null;
    }

    protected int getFlags(JvmOperation operation) {
        int flags = 0;
        if (this.dispatchUtil.isDispatcherFunction(operation)) {
            flags = this.descriptionFlags.setDispatcherOperation(flags);
        }
        if (operation.isStatic()) {
            flags = this.descriptionFlags.setStatic(flags);
        }
        return flags;
    }

    protected int getFlags(JvmField field) {
        return field.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }

    protected int getFlags(XtendField field) {
        return field.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }

    protected int getFlags(XtendFunction function) {
        return function.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }
}

