/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.ui.hover.HoverLinkHelper;

public class JvmAnnotationReferencePrinter {
    private static final Logger LOG = Logger.getLogger(JvmAnnotationReferencePrinter.class);

    public String toHtmlString(JvmAnnotationReference reference) {
        Preconditions.checkNotNull((Object)reference);
        try {
            return this.internalToString(reference);
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return reference.getAnnotation() != null ? reference.getAnnotation().getSimpleName() : null;
        }
    }

    protected String internalToString(Object obj) {
        if (obj instanceof XBinaryOperation) {
            return this._internalToString((XBinaryOperation)obj);
        }
        if (obj instanceof XFeatureCall) {
            return this._internalToString((XFeatureCall)obj);
        }
        if (obj instanceof XListLiteral) {
            return this._internalToString((XListLiteral)obj);
        }
        if (obj instanceof XMemberFeatureCall) {
            return this._internalToString((XMemberFeatureCall)obj);
        }
        if (obj instanceof XBooleanLiteral) {
            return this._internalToString((XBooleanLiteral)obj);
        }
        if (obj instanceof XNumberLiteral) {
            return this._internalToString((XNumberLiteral)obj);
        }
        if (obj instanceof XStringLiteral) {
            return this._internalToString((XStringLiteral)obj);
        }
        if (obj instanceof XTypeLiteral) {
            return this._internalToString((XTypeLiteral)obj);
        }
        if (obj instanceof XAnnotation) {
            return this._internalToString((XAnnotation)obj);
        }
        if (obj instanceof JvmAnnotationReference) {
            return this._internalToString((JvmAnnotationReference)obj);
        }
        if (obj instanceof JvmAnnotationValue) {
            return this._internalToString((JvmAnnotationValue)obj);
        }
        return this._internalToString(obj);
    }

    protected String _internalToString(JvmAnnotationReference reference) {
        boolean needsExplicitProperties;
        StringBuilder buffer = new StringBuilder();
        buffer.append("@");
        buffer.append(this.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)reference.getAnnotation()), reference.getAnnotation().getSimpleName()));
        EList explicitValues = reference.getExplicitValues();
        boolean bl = needsExplicitProperties = explicitValues.size() > 1 || !explicitValues.isEmpty() && ((JvmAnnotationValue)explicitValues.get(0)).getOperation() != null && !"value".equals(((JvmAnnotationValue)explicitValues.get(0)).getOperation().getSimpleName());
        if (!explicitValues.isEmpty()) {
            buffer.append("(");
            buffer.append(explicitValues.stream().map(explicitValue -> {
                StringBuilder builder = new StringBuilder();
                if (needsExplicitProperties) {
                    Iterable declaredOperations = reference.getAnnotation().getDeclaredOperations();
                    builder.append(this.createLinkToOperation(explicitValue.getOperation(), declaredOperations));
                    builder.append("=");
                }
                builder.append(this.internalToString(explicitValue));
                return builder.toString();
            }).collect(Collectors.joining(", ")));
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String _internalToString(XAnnotation reference) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@");
        buffer.append(this.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)reference.getAnnotationType()), reference.getAnnotationType().getSimpleName()));
        if (reference.getValue() != null) {
            buffer.append("(");
            buffer.append(reference.getValue());
            buffer.append(")");
        } else if (!reference.getElementValuePairs().isEmpty()) {
            buffer.append("(");
            buffer.append(reference.getElementValuePairs().stream().map(evPair -> {
                StringBuilder builder = new StringBuilder();
                Iterable declaredOperations = ((JvmAnnotationType)reference.getAnnotationType()).getDeclaredOperations();
                builder.append(this.createLinkToOperation(evPair.getElement(), declaredOperations));
                builder.append("=");
                builder.append(this.internalToString(evPair.getValue()));
                return builder.toString();
            }).collect(Collectors.joining(", ")));
            buffer.append(")");
        }
        return buffer.toString();
    }

    protected String _internalToString(JvmAnnotationValue jvmAnnotationValue) {
        EStructuralFeature ref = jvmAnnotationValue.eClass().getEStructuralFeature("values");
        if (ref == null) {
            throw new IllegalStateException("Cannot find feature with name 'values' in " + jvmAnnotationValue);
        }
        EList values = (EList)jvmAnnotationValue.eGet(ref);
        if (values.size() > 1) {
            return values.stream().map(value -> this.internalToString(value)).collect(Collectors.joining(", ", "#[", "]"));
        }
        return this.internalToString(values.get(0));
    }

    protected String _internalToString(Object obj) {
        return obj.toString();
    }

    protected String _internalToString(XTypeLiteral typeLiteral) {
        String text = this.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)typeLiteral.getType()), typeLiteral.getType().getSimpleName());
        return String.valueOf(text) + String.join((CharSequence)"", (Iterable<? extends CharSequence>)typeLiteral.getArrayDimensions());
    }

    protected String _internalToString(XListLiteral listLiteral) {
        return listLiteral.getElements().stream().map(element -> this.internalToString(element)).collect(Collectors.joining(", ", "#[", "]"));
    }

    protected String _internalToString(XBinaryOperation binaryOperation) {
        return String.valueOf(this.internalToString(binaryOperation.getLeftOperand())) + " " + binaryOperation.getConcreteSyntaxFeatureName() + " " + this.internalToString(binaryOperation.getRightOperand());
    }

    protected String _internalToString(XStringLiteral stringLiteral) {
        return "\"" + stringLiteral.getValue() + "\"";
    }

    protected String _internalToString(XNumberLiteral numberLiteral) {
        return numberLiteral.getValue();
    }

    protected String _internalToString(XBooleanLiteral booleanLiteral) {
        return Boolean.toString(booleanLiteral.isIsTrue());
    }

    protected String _internalToString(XMemberFeatureCall memberFeatureCall) {
        if (memberFeatureCall.isPackageFragment()) {
            return null;
        }
        String prefix = this.internalToString(memberFeatureCall.getMemberCallTarget());
        return this.internalHandleAbstractFeatureCall(prefix, (XAbstractFeatureCall)memberFeatureCall);
    }

    protected String _internalToString(XFeatureCall featureCall) {
        return featureCall.isPackageFragment() ? null : this.internalHandleAbstractFeatureCall(null, (XAbstractFeatureCall)featureCall);
    }

    protected String internalHandleAbstractFeatureCall(String prefix, XAbstractFeatureCall abstractFeatureCall) {
        String postfix = abstractFeatureCall.getFeature() != null && !abstractFeatureCall.getFeature().eIsProxy() ? this.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)abstractFeatureCall.getFeature()), abstractFeatureCall.getConcreteSyntaxFeatureName()) : abstractFeatureCall.getConcreteSyntaxFeatureName();
        if (prefix == null) {
            return postfix;
        }
        return String.valueOf(prefix) + "." + postfix;
    }

    private String createLinkToOperation(JvmOperation toOperation, Iterable<JvmOperation> declaredOperations) {
        JvmOperation operation = toOperation != null ? toOperation : (JvmOperation)Iterables.tryFind(declaredOperations, o -> "value".equals(o.getSimpleName())).orNull();
        return this.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)operation), operation.getSimpleName());
    }

    protected String createLinkWithLabel(String scheme, URI uri, String label) {
        return HoverLinkHelper.createLinkWithLabel(scheme, uri, label);
    }
}

