/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.xtext.util.JavaVersion;

public class JREContainerProvider {
    public static final String PREFERRED_BREE = "JavaSE-11";
    private static IVMInstall defaultVMInstall = null;
    private static boolean defaultVMinitialized = false;

    public static IClasspathEntry getDefaultJREContainerEntry() {
        IPath jreContainerPath = JREContainerProvider.getDefaultJREContainerPath();
        return JavaCore.newContainerEntry((IPath)jreContainerPath);
    }

    public static IPath getDefaultJREContainerPath() {
        if (JREContainerProvider.defaultVMInstall() != null) {
            IExecutionEnvironment[] executionEnvironments;
            IExecutionEnvironmentsManager executionEnvironmentsManager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment[] iExecutionEnvironmentArray = executionEnvironments = executionEnvironmentsManager.getExecutionEnvironments();
            int n = executionEnvironments.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionEnvironment executionEnvironment = iExecutionEnvironmentArray[n2];
                if (executionEnvironment.isStrictlyCompatible(JREContainerProvider.defaultVMInstall())) {
                    return JavaRuntime.newJREContainerPath((IExecutionEnvironment)executionEnvironment);
                }
                ++n2;
            }
        }
        return JREContainerProvider.newPreferredContainerPath();
    }

    private static IVMInstall defaultVMInstall() {
        if (!defaultVMinitialized) {
            defaultVMInstall = JavaRuntime.getDefaultVMInstall();
            defaultVMinitialized = true;
        }
        return defaultVMInstall;
    }

    @Deprecated(since="2.30", forRemoval=true)
    protected static IPath newJRE15ContainerPath() {
        return JavaRuntime.newJREContainerPath((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType", (String)JavaVersion.JAVA5.getBree());
    }

    @Deprecated
    protected static IPath newPrefferedContainerPath() {
        return JREContainerProvider.newPreferredContainerPath();
    }

    protected static IPath newPreferredContainerPath() {
        return JavaRuntime.newJREContainerPath((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType", (String)PREFERRED_BREE);
    }

    public static IClasspathEntry getJREContainerEntry(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] rawClasspath;
        IPath defaultJREContainerPathPrefix = JavaRuntime.newDefaultJREContainerPath().append("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            int entryKind = classpathEntry.getEntryKind();
            if (entryKind == 5 && defaultJREContainerPathPrefix.isPrefixOf(classpathEntry.getPath())) {
                return classpathEntry;
            }
            ++n2;
        }
        return null;
    }

    public static IClasspathEntry getJREContainerEntry(String bree) {
        IClasspathEntry jreContainerEntry = JREContainerProvider.getDefaultJREContainerEntry();
        IExecutionEnvironment ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(bree);
        if (ee != null) {
            return JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee));
        }
        return jreContainerEntry;
    }

    public static String getDefaultBREE() {
        return JREContainerProvider.getDefaultJREContainerPath().lastSegment();
    }

    public static Iterable<String> getConfiguredBREEs() {
        final HashSet vms = Sets.newHashSet();
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmType = iVMInstallTypeArray[n2];
            vms.addAll(Arrays.asList(vmType.getVMInstalls()));
            ++n2;
        }
        Iterable supportedEEs = Iterables.filter(Arrays.asList(JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()), (Predicate)new Predicate<IExecutionEnvironment>(){

            public boolean apply(final IExecutionEnvironment ee) {
                return ee.getDefaultVM() != null || Iterables.any((Iterable)vms, (Predicate)new Predicate<IVMInstall>(){

                    public boolean apply(IVMInstall vm) {
                        return ee.isStrictlyCompatible(vm);
                    }
                });
            }
        });
        return Iterables.transform((Iterable)supportedEEs, (Function)new Function<IExecutionEnvironment, String>(){

            public String apply(IExecutionEnvironment input) {
                return input.getId();
            }
        });
    }
}

