/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.ImplementedBy;
import org.eclipse.jdt.core.compiler.CharOperation;

@ImplementedBy(value=IgnoreCase.class)
public abstract class PrefixMatcher {
    public abstract boolean isCandidateMatchingPrefix(String var1, String var2);

    public static class CamelCase
    extends IgnoreCase {
        private boolean canDoCamelCaseMatch = this.isJdtAvailable();

        protected boolean isJdtAvailable() {
            try {
                CharOperation.camelCaseMatch(null, null);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        @Override
        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            boolean result = super.isCandidateMatchingPrefix(name, prefix) || this.canDoCamelCaseMatch && prefix.length() < name.length() && this.camelCaseMatch(name, prefix);
            return result;
        }

        protected boolean camelCaseMatch(String name, String prefix) {
            return CharOperation.camelCaseMatch((char[])prefix.toCharArray(), (char[])name.toCharArray());
        }
    }

    @ImplementedBy(value=CamelCase.class)
    public static class IgnoreCase
    extends PrefixMatcher {
        @Override
        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            return name.regionMatches(true, 0, prefix, 0, prefix.length());
        }
    }
}

