/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.wizard.AbstractFile;
import org.eclipse.xtext.xtext.wizard.ExternalDependency;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.SourceFolderDescriptor;
import org.eclipse.xtext.xtext.wizard.TestProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;

public abstract class TestedProjectDescriptor
extends ProjectDescriptor {
    public abstract TestProjectDescriptor getTestProject();

    public TestedProjectDescriptor(WizardConfiguration config) {
        super(config);
    }

    @Override
    public Set<ExternalDependency> getExternalDependencies() {
        LinkedHashSet<ExternalDependency> deps = new LinkedHashSet<ExternalDependency>();
        Iterables.addAll(deps, super.getExternalDependencies());
        if (this.getTestProject().isInlined()) {
            Iterables.addAll(deps, this.getTestProject().getExternalDependencies());
        }
        return deps;
    }

    @Override
    public Set<SourceFolderDescriptor> getSourceFolders() {
        LinkedHashSet<SourceFolderDescriptor> sourceFolders = new LinkedHashSet<SourceFolderDescriptor>();
        Iterables.addAll(sourceFolders, super.getSourceFolders());
        if (this.getTestProject().isInlined()) {
            Iterables.addAll(sourceFolders, this.getTestProject().getSourceFolders());
        }
        return sourceFolders;
    }

    @Override
    public Iterable<? extends AbstractFile> getFiles() {
        ArrayList files = new ArrayList();
        Iterables.addAll(files, super.getFiles());
        if (this.getTestProject().isInlined()) {
            Iterable filtered = IterableExtensions.filter(this.getTestProject().getFiles(), fileFromTestProject -> files.stream().noneMatch(f -> Objects.equals(f.getRelativePath(), fileFromTestProject.getRelativePath())));
            Iterables.addAll(files, (Iterable)filtered);
        }
        return files;
    }
}

