/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.ui.refactoring.impl.RenameElementProcessor;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;
import org.eclipse.xtext.util.Strings;

public class XtendRenameElementProcessor
extends RenameElementProcessor {
    @Inject
    private XtextEditorInfo editorInfo;
    @Inject(optional=true)
    private IWorkbench workbench;

    public boolean hasUnsavedEditors() {
        return (Boolean)new DisplayRunnableWithResult<Boolean>(){

            protected Boolean run() throws Exception {
                IWorkbenchPage workbenchPage = XtendRenameElementProcessor.this.workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart[] iEditorPartArray = workbenchPage.getDirtyEditors();
                int n = iEditorPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editorPart = iEditorPartArray[n2];
                    if (Strings.equal((String)editorPart.getSite().getId(), (String)XtendRenameElementProcessor.this.editorInfo.getEditorId())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }.syncExec();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = super.checkInitialConditions(pm);
        if (this.hasUnsavedEditors()) {
            status.addWarning("Unsaved changes in Xtend editors could collide with this refactoring.");
        }
        return status;
    }
}

