/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.Messages;
import org.eclipse.xtext.builder.builderState.PersistedStateProvider;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescriptionChangeEventSource;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionChangeEvent;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperExtension;
import org.eclipse.xtext.ui.workspace.WorkspaceLockAccess;

public abstract class AbstractBuilderState
extends AbstractResourceDescriptionChangeEventSource
implements IBuilderState {
    private volatile ResourceDescriptionsData resourceDescriptionData = new ResourceDescriptionsData(Collections.emptyList());
    private static final Logger log = Logger.getLogger(AbstractBuilderState.class);
    @Inject
    private IMarkerUpdater markerUpdater;
    @Inject
    private PersistedStateProvider persister;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IWorkspace workspace;
    @Inject
    private WorkspaceLockAccess workspaceLockAccess;
    private volatile boolean isLoaded = false;
    private final ILock loadLock = Job.getJobManager().newLock();
    private static int MONITOR_CHUNK_SIZE_CLEAN = 50;

    public void load() {
        if (!this.isLoaded) {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (!AbstractBuilderState.this.isLoaded) {
                        try {
                            AbstractBuilderState.this.loadLock.acquire();
                            if (!AbstractBuilderState.this.isLoaded) {
                                AbstractBuilderState.this.resourceDescriptionData = new ResourceDescriptionsData(AbstractBuilderState.this.doLoad());
                                if (AbstractBuilderState.this.storage2UriMapper instanceof IStorage2UriMapperExtension) {
                                    ((IStorage2UriMapperExtension)AbstractBuilderState.this.storage2UriMapper).initializeCache();
                                }
                                AbstractBuilderState.this.isLoaded = true;
                            }
                        }
                        finally {
                            AbstractBuilderState.this.loadLock.release();
                        }
                    }
                }
            };
            try {
                switch (this.workspaceLockAccess.isWorkspaceLockedByCurrentThread(this.workspace)) {
                    case YES: {
                        runnable.run(null);
                        break;
                    }
                    case NO: {
                        this.workspace.run(runnable, null, 1, null);
                        break;
                    }
                    case SHUTDOWN: {
                        return;
                    }
                }
            }
            catch (CoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void ensureLoaded() {
        this.load();
    }

    protected Iterable<IResourceDescription> doLoad() {
        return this.persister.load();
    }

    protected Set<URI> ensureNotNull(Set<URI> uris) {
        return uris != null ? uris : Collections.emptySet();
    }

    protected void setResourceDescriptionsData(ResourceDescriptionsData newData) {
        this.resourceDescriptionData = newData;
    }

    protected void updateMarkers(IResourceDescription.Delta delta, ResourceSet resourceSet, IProgressMonitor monitor) throws OperationCanceledException {
        this.markerUpdater.updateMarkers(delta, resourceSet, monitor);
    }

    protected ResourceDescriptionsData getCopiedResourceDescriptionsData() {
        return this.resourceDescriptionData.copy();
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        this.ensureLoaded();
        return this.resourceDescriptionData.getAllResourceDescriptions();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getResourceDescription(uri);
    }

    public void setPersister(PersistedStateProvider persister) {
        this.persister = persister;
    }

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> update(BuildData buildData, IProgressMonitor monitor) {
        this.ensureLoaded();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_0, (int)1);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (buildData.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceDescriptionsData newData = this.getCopiedResourceDescriptionsData();
        Collection<IResourceDescription.Delta> result = this.doUpdate(buildData, newData, (IProgressMonitor)subMonitor.split(1));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(result);
        this.setResourceDescriptionsData(newData);
        this.notifyListeners((IResourceDescription.Event)event);
        return event.getDeltas();
    }

    protected abstract Collection<IResourceDescription.Delta> doUpdate(BuildData var1, ResourceDescriptionsData var2, IProgressMonitor var3);

    @Override
    public synchronized ImmutableList<IResourceDescription.Delta> clean(Set<URI> toBeRemoved, IProgressMonitor monitor) throws OperationCanceledException {
        this.ensureLoaded();
        toBeRemoved = this.ensureNotNull(toBeRemoved);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_0, (int)2);
        subMonitor.subTask(Messages.AbstractBuilderState_0);
        if (toBeRemoved.isEmpty()) {
            return ImmutableList.of();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Collection<IResourceDescription.Delta> deltas = this.doClean(toBeRemoved, (IProgressMonitor)subMonitor.split(1));
        ResourceDescriptionsData newData = this.getCopiedResourceDescriptionsData();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IResourceDescription.Delta delta : deltas) {
            newData.removeDescription(delta.getOld().getURI());
        }
        ResourceDescriptionChangeEvent event = new ResourceDescriptionChangeEvent(deltas);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        int i = 0;
        subMonitor.setWorkRemaining(toBeRemoved.size() / MONITOR_CHUNK_SIZE_CLEAN + 1);
        for (IResourceDescription.Delta delta : event.getDeltas()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.updateMarkers(delta, null, (IProgressMonitor)subMonitor);
            if (++i % MONITOR_CHUNK_SIZE_CLEAN != 0) continue;
            subMonitor.worked(1);
        }
        this.setResourceDescriptionsData(newData);
        this.notifyListeners((IResourceDescription.Event)event);
        return event.getDeltas();
    }

    protected Collection<IResourceDescription.Delta> doClean(Set<URI> toBeRemoved, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractBuilderState_2, (int)(toBeRemoved.size() / MONITOR_CHUNK_SIZE_CLEAN + 1));
        subMonitor.subTask(Messages.AbstractBuilderState_2);
        LinkedHashSet result = Sets.newLinkedHashSet();
        int i = 0;
        for (URI toDelete : toBeRemoved) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IResourceDescription resourceDescription = this.getResourceDescription(toDelete);
            if (resourceDescription != null) {
                result.add(new DefaultResourceDescriptionDelta(resourceDescription, null));
            }
            if (++i % MONITOR_CHUNK_SIZE_CLEAN != 0) continue;
            subMonitor.worked(1);
        }
        return result;
    }

    public Iterable<IEObjectDescription> getExportedObjects() {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjects();
    }

    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjects(type, name, ignoreCase);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjectsByType(type);
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        this.ensureLoaded();
        return this.resourceDescriptionData.getExportedObjectsByObject(object);
    }

    public boolean isEmpty() {
        this.ensureLoaded();
        return this.resourceDescriptionData.isEmpty();
    }
}

