/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.SuperConstructorDescription;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorDelegateScope
extends AbstractSessionBasedScope
implements IFeatureNames {
    private Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> receiverTypeParameterMapping;
    private LightweightTypeReference contextType;

    public ConstructorDelegateScope(IScope parent, LightweightTypeReference contextType, IFeatureScopeSession session, XAbstractFeatureCall featureCall) {
        super(parent, session, featureCall);
        this.contextType = contextType;
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        EObject objectOrProxy;
        IEObjectDescription description;
        if ((THIS.equals((Object)name) || SUPER.equals((Object)name)) && (description = this.getSession().getLocalElement(name)) != null && (objectOrProxy = description.getEObjectOrProxy()) instanceof JvmGenericType && !objectOrProxy.eIsProxy()) {
            return this.createConstructorDescriptions(name, (JvmGenericType)objectOrProxy, SUPER.equals((Object)name));
        }
        return Collections.emptyList();
    }

    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getReceiverTypeParameterMapping() {
        if (this.receiverTypeParameterMapping == null) {
            this.receiverTypeParameterMapping = Collections.emptyMap();
            if (this.contextType != null) {
                this.receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.contextType);
            }
        }
        return this.receiverTypeParameterMapping;
    }

    protected Collection<IEObjectDescription> createConstructorDescriptions(QualifiedName name, JvmGenericType type, boolean superType) {
        Iterable constructors = type.getDeclaredConstructors();
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        for (JvmConstructor constructor : constructors) {
            result.add(this.createDescription(name, constructor, superType));
        }
        return result;
    }

    protected IEObjectDescription createDescription(QualifiedName name, JvmConstructor constructor, boolean superType) {
        if (superType) {
            return new SuperConstructorDescription(name, constructor, this.getReceiverTypeParameterMapping(), 0, this.getSession().isVisible((JvmMember)constructor));
        }
        return new ConstructorDescription(name, constructor, 0, this.getSession().isVisible((JvmMember)constructor));
    }
}

