/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterByConstraintSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public abstract class AbstractPendingLinkingCandidate<Expression extends XExpression>
extends AbstractLinkingCandidate<Expression> {
    protected final IIdentifiableElementDescription description;
    private final Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping;

    protected AbstractPendingLinkingCandidate(Expression expression, IIdentifiableElementDescription description, ExpressionTypeComputationState state) {
        super(expression, state);
        this.description = description;
        this.typeParameterMapping = this.initializeTypeParameterMapping();
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getTypeParameterMapping() {
        return this.typeParameterMapping;
    }

    protected abstract String getFeatureTypeName();

    protected String getArgumentTypesAsString() {
        if (!this.getArguments().isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("(");
            int i = 0;
            while (i < this.getArguments().size()) {
                LightweightTypeReference actualType = this.getActualType(this.getArguments().get(i));
                if (actualType != null) {
                    b.append(actualType.getSimpleName());
                } else {
                    b.append("null");
                }
                if (i < this.getArguments().size() - 1) {
                    b.append(",");
                }
                ++i;
            }
            b.append(")");
            return b.toString();
        }
        return "";
    }

    protected String getFeatureParameterTypesAsString() {
        if (this.getFeature() instanceof JvmExecutable) {
            OwnedConverter ownedConverter = new OwnedConverter(this.getState().getReferenceOwner());
            EList parameters = ((JvmExecutable)this.getFeature()).getParameters();
            StringBuilder b = new StringBuilder();
            b.append("(");
            int i = 0;
            while (i < parameters.size()) {
                JvmTypeReference parameterType = ((JvmFormalParameter)parameters.get(i)).getParameterType();
                LightweightTypeReference typeReference = ownedConverter.toLightweightReference(parameterType);
                b.append(typeReference.getSimpleName());
                if (i < parameters.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(")");
            return b.toString();
        }
        return "";
    }

    protected String getFeatureTypeParametersAsString(boolean showBounds) {
        List<JvmTypeParameter> typeParameters = this.getDeclaredTypeParameters();
        if (!typeParameters.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("<");
            int i = 0;
            while (i < typeParameters.size()) {
                JvmTypeParameter typeParameter = typeParameters.get(i);
                if (showBounds) {
                    b.append(this.getTypeParameterAsString(typeParameter));
                } else {
                    b.append(typeParameter.getSimpleName());
                }
                if (i < typeParameters.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(">");
            return b.toString();
        }
        return "";
    }

    protected String getTypeParameterAsString(JvmTypeParameter typeParameter) {
        StringBuilder b;
        block1: {
            b = new StringBuilder();
            b.append(typeParameter.getName());
            OwnedConverter ownedConverter = new OwnedConverter(this.getState().getReferenceOwner());
            if (typeParameter.getConstraints().isEmpty()) break block1;
            int j = 0;
            while (j < typeParameter.getConstraints().size()) {
                block3: {
                    LightweightTypeReference typeRef;
                    block4: {
                        block2: {
                            JvmTypeConstraint constraint = (JvmTypeConstraint)typeParameter.getConstraints().get(j);
                            typeRef = ownedConverter.apply(constraint.getTypeReference());
                            if (!(constraint instanceof JvmUpperBound)) break block2;
                            if (typeRef.isType(Object.class)) break block3;
                            b.append(" extends ");
                            break block4;
                        }
                        b.append(" super ");
                    }
                    b.append(typeRef.getSimpleName());
                }
                ++j;
            }
        }
        return b.toString();
    }

    protected String getTypeArgumentsAsString(List<? extends LightweightTypeReference> typeArguments) {
        if (!typeArguments.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("<");
            int i = 0;
            while (i < typeArguments.size()) {
                b.append(typeArguments.get(i).getSimpleName());
                if (i < typeArguments.size() - 1) {
                    b.append(",");
                }
                ++i;
            }
            b.append(">");
            return b.toString();
        }
        return "";
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        if (!this.validateVisibility(result)) {
            return false;
        }
        if (!this.validateArity(result)) {
            return false;
        }
        if (!this.validateTypeArity(result)) {
            return false;
        }
        if (!this.validateTypeArgumentConformance(result)) {
            return false;
        }
        return this.validateUnhandledExceptions(result);
    }

    protected boolean validateVisibility(IAcceptor<? super AbstractDiagnostic> result) {
        if (!this.isVisible()) {
            String message = String.format("The %1$s %2$s%3$s is not visible", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected EReference getDefaultValidationFeature() {
        return XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    @Nullable
    protected EReference getInvalidArgumentsValidationFeature() {
        return XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    protected boolean validateArity(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.getArityMismatch() != 0) {
            String message = String.format("Invalid number of arguments. The %1$s %2$s%3$s is not applicable for the arguments %4$s", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString(), this.getArgumentTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments", message, this.getExpression(), (EStructuralFeature)this.getInvalidArgumentsValidationFeature(), -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected boolean validateTypeArity(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.getTypeArityMismatch() != 0) {
            String message = String.format("Invalid number of type arguments. The %1$s %2$s%3$s is not applicable for the type arguments %4$s", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureTypeParametersAsString(true), this.getTypeArgumentsAsString(this.getSyntacticTypeArguments()));
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected boolean validateTypeArgumentConformance(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.getTypeArgumentConformanceFailures(result) == 0) {
            List<XExpression> arguments = this.getSyntacticArguments();
            int i = 0;
            while (i < arguments.size()) {
                XExpression argument = arguments.get(i);
                if (this.isDefiniteEarlyExit(argument)) {
                    Object errorOn = this.getExpression();
                    if (i < arguments.size() - 1) {
                        errorOn = arguments.get(i + 1);
                    }
                    String message = "Unreachable code.";
                    EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code", message, errorOn, null, -1, null);
                    result.accept((Object)diagnostic);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean validateUnhandledExceptions(IAcceptor<? super AbstractDiagnostic> result) {
        JvmExecutable executable;
        if (!this.getState().isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception") && this.getFeature() instanceof JvmExecutable && !(executable = (JvmExecutable)this.getFeature()).getExceptions().isEmpty()) {
            return this.validateUnhandledExceptions(executable, result);
        }
        return true;
    }

    protected boolean validateUnhandledExceptions(JvmExecutable executable, IAcceptor<? super AbstractDiagnostic> result) {
        TypeParameterSubstitutor<?> substitutor = this.createArgumentTypeSubstitutor();
        List unhandledExceptions = null;
        List<LightweightTypeReference> expectedExceptions = this.getState().getExpectedExceptions();
        block0: for (JvmTypeReference typeReference : executable.getExceptions()) {
            LightweightTypeReference exception = this.getState().getConverter().toLightweightReference(typeReference);
            LightweightTypeReference resolvedException = substitutor.substitute(exception);
            if (!resolvedException.isSubtypeOf(Throwable.class) || resolvedException.isSubtypeOf(RuntimeException.class)) continue;
            for (LightweightTypeReference expectedException : expectedExceptions) {
                if (expectedException.isAssignableFrom(resolvedException)) continue block0;
            }
            if (unhandledExceptions == null) {
                unhandledExceptions = Lists.newArrayList((Object[])new LightweightTypeReference[]{resolvedException});
                continue;
            }
            unhandledExceptions.add(resolvedException);
        }
        if (unhandledExceptions != null) {
            String message = null;
            int count = unhandledExceptions.size();
            message = count > 1 ? String.format("Unhandled exception types %s and %s", IterableExtensions.join(unhandledExceptions.subList(0, count - 1), (CharSequence)", "), unhandledExceptions.get(count - 1)) : String.format("Unhandled exception type %s", ((LightweightTypeReference)unhandledExceptions.get(0)).getSimpleName());
            String[] data = new String[unhandledExceptions.size() + 1];
            int i = 0;
            while (i < data.length - 1) {
                LightweightTypeReference unhandled = (LightweightTypeReference)unhandledExceptions.get(i);
                data[i] = EcoreUtil.getURI((EObject)unhandled.getType()).toString();
                ++i;
            }
            data[data.length - 1] = EcoreUtil.getURI(this.getExpression()).toString();
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(this.getState().getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception"), "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, data);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected boolean isDefiniteEarlyExit(XExpression expression) {
        return expression instanceof XReturnExpression || expression instanceof XThrowExpression;
    }

    protected List<XExpression> getSyntacticArguments() {
        return this.getArguments();
    }

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        if (other instanceof AbstractPendingLinkingCandidate) {
            AbstractPendingLinkingCandidate right = (AbstractPendingLinkingCandidate)other;
            int arityCompareResult = this.compareByArityWith(right);
            if (arityCompareResult != 0) {
                if (arityCompareResult <= 0) {
                    return this;
                }
                return other;
            }
            boolean visible = this.isVisible();
            if (visible != right.isVisible()) {
                if (visible) {
                    return this;
                }
                return other;
            }
            int typeArityCompareResult = this.compareByArity(this.getTypeArityMismatch(), right.getTypeArityMismatch());
            if (typeArityCompareResult != 0) {
                if (typeArityCompareResult <= 0) {
                    return this;
                }
                return other;
            }
            int argumentTypeCompareResult = this.compareByArgumentTypes(right);
            if (argumentTypeCompareResult != 0) {
                if (argumentTypeCompareResult <= 0) {
                    return this;
                }
                return other;
            }
            int typeArgumentCompareResult = this.compareByTypeArguments(right);
            if (typeArgumentCompareResult != 0) {
                if (typeArgumentCompareResult <= 0) {
                    return this;
                }
                return other;
            }
            if (this.isVarArgs() != right.isVarArgs()) {
                if (this.isVarArgs()) {
                    return right;
                }
                return this;
            }
            if (this.isTypeLiteral() && !right.isTypeLiteral()) {
                return right;
            }
            return this;
        }
        throw new IllegalArgumentException("other was " + other);
    }

    protected boolean isVisible() {
        return this.description.isVisible();
    }

    protected boolean isVarArgs() {
        return this.getFeature() instanceof JvmExecutable && ((JvmExecutable)this.getFeature()).isVarArgs();
    }

    protected boolean isExtension() {
        return false;
    }

    protected int compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right) {
        this.initializeArgumentTypeComputation();
        right.initializeArgumentTypeComputation();
        int result = this.compareByArgumentTypes(right, false);
        if (result != 0) {
            return result;
        }
        result = this.compareExpectedArgumentTypes(right);
        if (result != 0) {
            return result;
        }
        result = this.compareByArgumentTypes(right, true);
        if (result != 0) {
            return result;
        }
        return result;
    }

    protected int compareByTypeArguments(AbstractPendingLinkingCandidate<?> right) {
        this.initializeArgumentTypeComputation();
        right.initializeArgumentTypeComputation();
        int leftFailures = this.getTypeArgumentConformanceFailures(null);
        int rightFailures = right.getTypeArgumentConformanceFailures(null);
        if (leftFailures != rightFailures) {
            if (leftFailures < rightFailures) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    protected int getTypeArgumentConformanceFailures(@Nullable IAcceptor<? super AbstractDiagnostic> acceptor) {
        JvmTypeParameter declaration;
        LightweightTypeReference argument;
        List<LightweightTypeReference> typeArguments = this.getTypeArguments();
        List<JvmTypeParameter> typeParameters = this.getDeclaredTypeParameters();
        int max = Math.min(typeArguments.size(), typeParameters.size());
        if (max == 0) {
            return 0;
        }
        int failures = 0;
        TypeParameterByConstraintSubstitutor substitutor = new TypeParameterByConstraintSubstitutor(this.getDeclaratorParameterMapping(), this.getState().getReferenceOwner());
        int i = 0;
        while (i < max) {
            argument = typeArguments.get(i);
            declaration = typeParameters.get(i);
            substitutor.enhanceMapping(Collections.singletonMap(declaration, new LightweightMergedBoundTypeArgument(argument, VarianceInfo.INVARIANT)));
            ++i;
        }
        i = 0;
        while (i < max) {
            argument = typeArguments.get(i);
            declaration = typeParameters.get(i);
            if (argument.getType() != declaration) {
                ParameterizedTypeReference reference = new ParameterizedTypeReference(argument.getOwner(), (JvmType)declaration);
                for (LightweightTypeReference superType : reference.getSuperTypes()) {
                    LightweightTypeReference substitutedSuperType = substitutor.substitute(superType);
                    if (substitutedSuperType.isAssignableFrom(argument)) continue;
                    ++failures;
                }
            }
            ++i;
        }
        if (failures != 0 && acceptor != null) {
            String format = max > 1 ? "Bounds mismatch: The type arguments %1$s are not a valid substitute for the bounded type parameters %2$s of the %3$s %4$s%5$s" : "Bounds mismatch: The type argument %1$s is not a valid substitute for the bounded type parameter %2$s of the %3$s %4$s%5$s";
            String message = String.format(format, this.getTypeArgumentsAsString(typeArguments), this.getFeatureTypeParametersAsString(true), this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch", message, this.getExpression(), (EStructuralFeature)this.getDefaultValidationFeature(), -1, null);
            acceptor.accept((Object)diagnostic);
        }
        return failures;
    }

    protected int compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, boolean recompute) {
        int upTo = Math.max(this.arguments.getArgumentCount(), right.arguments.getArgumentCount());
        int leftBoxing = 0;
        int rightBoxing = 0;
        int leftDemand = 0;
        int rightDemand = 0;
        int i = 0;
        while (i < upTo) {
            EnumSet<ConformanceHint> rightConformance;
            EnumSet<ConformanceHint> leftConformance = this.getConformanceHints(i, recompute);
            int hintCompareResult = this.compareByArgumentTypes(right, i, leftConformance, rightConformance = right.getConformanceHints(i, recompute));
            if (hintCompareResult != 0) {
                return hintCompareResult;
            }
            if (leftConformance.contains((Object)ConformanceHint.DEMAND_CONVERSION)) {
                ++leftDemand;
            }
            if (rightConformance.contains((Object)ConformanceHint.DEMAND_CONVERSION)) {
                ++rightDemand;
            }
            if (leftConformance.contains((Object)ConformanceHint.BOXING) || leftConformance.contains((Object)ConformanceHint.UNBOXING)) {
                ++leftBoxing;
            }
            if (rightConformance.contains((Object)ConformanceHint.BOXING) || rightConformance.contains((Object)ConformanceHint.UNBOXING)) {
                ++rightBoxing;
            }
            ++i;
        }
        return this.compareByArgumentTypes(right, leftBoxing, rightBoxing, leftDemand, rightDemand);
    }

    protected int compareByArgumentTypes(AbstractPendingLinkingCandidate<?> other, int argumentIndex, EnumSet<ConformanceHint> leftConformance, EnumSet<ConformanceHint> rightConformance) {
        int hintCompareResult = ConformanceHint.compareHints(leftConformance, rightConformance);
        return hintCompareResult;
    }

    protected int compareByArgumentTypes(AbstractPendingLinkingCandidate<?> other, int leftBoxing, int rightBoxing, int leftDemand, int rightDemand) {
        if (leftDemand != rightDemand) {
            if (leftDemand < rightDemand) {
                return -1;
            }
            return 1;
        }
        if (leftBoxing != rightBoxing) {
            if (leftBoxing < rightBoxing) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    protected EnumSet<ConformanceHint> getConformanceHints(int idx, boolean recompute) {
        while (!this.arguments.isProcessed(idx)) {
            this.computeArgumentType(this.arguments.getNextUnprocessedArgumentSlot());
        }
        if (idx >= this.arguments.getArgumentCount()) {
            return EnumSet.of(ConformanceHint.SUCCESS, ConformanceHint.CHECKED);
        }
        XExpression argument = this.arguments.getArgument(idx);
        if (argument == null) {
            return EnumSet.of(ConformanceHint.INCOMPATIBLE);
        }
        return this.getState().getStackedResolvedTypes().getConformanceHints(argument, recompute);
    }

    protected int compareExpectedArgumentTypes(AbstractPendingLinkingCandidate<?> right) {
        int result = 0;
        int upTo = Math.min(this.arguments.getArgumentCount(), right.arguments.getArgumentCount());
        int i = 0;
        while (i < upTo) {
            LightweightTypeReference expectedArgumentType = this.getSubstitutedExpectedType(i);
            LightweightTypeReference rightExpectedArgumentType = right.getSubstitutedExpectedType(i);
            if (expectedArgumentType == null) {
                if (rightExpectedArgumentType != null) {
                    return 1;
                }
            } else {
                if (rightExpectedArgumentType == null) {
                    return -1;
                }
                if (expectedArgumentType.isAssignableFrom(rightExpectedArgumentType)) {
                    if (!rightExpectedArgumentType.isAssignableFrom(expectedArgumentType)) {
                        ++result;
                    }
                } else if (rightExpectedArgumentType.isAssignableFrom(expectedArgumentType)) {
                    --result;
                }
            }
            ++i;
        }
        return result;
    }

    protected int compareByArityWith(AbstractPendingLinkingCandidate<?> right) {
        int arityCompareResult = this.compareByArity(this.getArityMismatch(), right.getArityMismatch());
        return arityCompareResult;
    }

    protected int compareByArity(int leftArityMismatch, int rightArityMismatch) {
        if (leftArityMismatch != rightArityMismatch) {
            if (leftArityMismatch == 0) {
                return -1;
            }
            if (rightArityMismatch == 0) {
                return 1;
            }
            if (Math.abs(leftArityMismatch) < Math.abs(rightArityMismatch)) {
                return -1;
            }
            if (Math.abs(leftArityMismatch) > Math.abs(rightArityMismatch)) {
                return 1;
            }
            if (leftArityMismatch > 0) {
                return -1;
            }
            if (rightArityMismatch > 0) {
                return 1;
            }
        }
        return 0;
    }

    public int getArityMismatch() {
        JvmIdentifiableElement identifiable = this.getFeature();
        if (identifiable instanceof JvmExecutable) {
            return this.getArityMismatch((JvmExecutable)identifiable, this.getArguments());
        }
        if (this.getExpression() instanceof XAssignment) {
            return this.getArguments().size() - 1;
        }
        return this.getArguments().size();
    }

    public int getTypeArityMismatch() {
        List<LightweightTypeReference> syntacticTypeArguments = this.getSyntacticTypeArguments();
        if (syntacticTypeArguments.size() == 0) {
            return 0;
        }
        return this.getDeclaredTypeParameters().size() - syntacticTypeArguments.size();
    }

    protected void resolveLinkingProxy(EReference structuralFeature, int featureId) {
        InternalEObject internalView = (InternalEObject)this.getExpression();
        JvmIdentifiableElement newFeature = this.getFeature();
        if (newFeature.eIsProxy()) {
            newFeature = (JvmIdentifiableElement)internalView.eResolveProxy((InternalEObject)newFeature);
        }
        this.resolveLinkingProxy(internalView, newFeature, structuralFeature, featureId);
    }

    protected void resolveLinkingProxy(InternalEObject owner, JvmIdentifiableElement newValue, EReference structuralFeature, int featureId) {
        EObject oldFeature = (EObject)owner.eGet((EStructuralFeature)structuralFeature, false);
        if (oldFeature == null || !oldFeature.eIsProxy()) {
            throw new IllegalStateException("Feature was already resolved to " + oldFeature);
        }
        if (owner.eNotificationRequired()) {
            boolean wasDeliver = owner.eDeliver();
            owner.eSetDeliver(false);
            this.internalSetValue(owner, structuralFeature, newValue);
            owner.eSetDeliver(wasDeliver);
            if (newValue != oldFeature) {
                owner.eNotify((Notification)new ENotificationImpl(owner, 9, featureId, (Object)oldFeature, (Object)newValue));
            }
        } else {
            this.internalSetValue(owner, structuralFeature, newValue);
        }
    }

    protected void internalSetValue(InternalEObject featureCall, EReference structuralFeature, JvmIdentifiableElement newValue) {
        featureCall.eSet((EStructuralFeature)structuralFeature, (Object)newValue);
    }

    protected int getArityMismatch(JvmExecutable executable, List<XExpression> arguments) {
        int fixedArityParamCount = executable.getParameters().size();
        if (executable.isVarArgs() && arguments.size() >= --fixedArityParamCount) {
            return 0;
        }
        return fixedArityParamCount - arguments.size();
    }

    @Override
    public JvmIdentifiableElement getFeature() {
        return this.description.getElementOrProxy();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + this.description.toString() + "]";
    }
}

