/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.Storage2UriMapperJavaImpl;
import org.eclipse.xtext.ui.resource.UriValidator;
import org.eclipse.xtext.ui.util.IJdtHelper;

public class JdtToBeBuiltComputer
extends ToBeBuiltComputer {
    private static final Logger log = Logger.getLogger(JdtToBeBuiltComputer.class);
    @Inject
    private TypeURIHelper typeURIHelper;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private ModificationStampCache modificationStampCache;
    @Inject
    private IJdtHelper jdtHelper;
    @Inject
    private UriValidator uriValidator;
    @Inject
    private Storage2UriMapperJavaImpl storage2UriMapperJavaImpl;

    public ToBeBuilt removeProject(IProject project, IProgressMonitor monitor) {
        ToBeBuilt toBeBuilt = super.removeProject(project, monitor);
        if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
            return toBeBuilt;
        }
        this.modificationStampCache.projectToModificationStamp.clear();
        return toBeBuilt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToBeBuilt updateProject(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ToBeBuilt toBeBuilt = super.updateProject(project, (IProgressMonitor)progress.newChild(1));
        if (!project.isAccessible() || progress.isCanceled()) {
            return toBeBuilt;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            progress.setWorkRemaining(roots.length);
            HashMap updated = Maps.newHashMap();
            IWorkspace.ProjectOrder orderedProjects = ResourcesPlugin.getWorkspace().computeProjectOrder(ResourcesPlugin.getWorkspace().getRoot().getProjects());
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (progress.isCanceled()) {
                    return toBeBuilt;
                }
                if (this.shouldHandle(root) && !this.isBuiltByUpstream(root, project, orderedProjects.projects)) {
                    Map rootData = this.storage2UriMapperJavaImpl.getAllEntries(root);
                    for (Map.Entry e : rootData.entrySet()) {
                        if (!this.uriValidator.canBuild((URI)e.getKey(), (IStorage)e.getValue())) continue;
                        toBeBuilt.getToBeDeleted().add((URI)e.getKey());
                        toBeBuilt.getToBeUpdated().add((URI)e.getKey());
                    }
                }
                progress.worked(1);
                ++n2;
            }
            ModificationStampCache modificationStampCache = this.modificationStampCache;
            synchronized (modificationStampCache) {
                this.modificationStampCache.projectToModificationStamp.putAll(updated);
            }
        }
        return toBeBuilt;
    }

    protected boolean isBuiltByUpstream(IPackageFragmentRoot root, IProject project, IProject[] projectsInCorrectBuildOrder) {
        IProject[] iProjectArray = projectsInCorrectBuildOrder;
        int n = projectsInCorrectBuildOrder.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject;
            IProject p = iProjectArray[n2];
            if (p.equals((Object)project)) {
                return false;
            }
            if (XtextProjectHelper.hasNature((IProject)p) && XtextProjectHelper.hasBuilder((IProject)p) && (javaProject = JavaCore.create((IProject)p)).exists() && javaProject.isOnClasspath((IJavaElement)root)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Build of project '" + project.getName() + "' skips indexing classpath entry '" + root.getPath() + "' because it already indexed by " + javaProject.getElementName()));
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean shouldHandle(IPackageFragmentRoot root) {
        try {
            boolean result = !JavaRuntime.newDefaultJREContainerPath().isPrefixOf(root.getRawClasspathEntry().getPath());
            return result &= root.isArchive() || root.isExternal();
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            return false;
        }
    }

    public boolean removeStorage(IProgressMonitor monitor, ToBeBuilt toBeBuilt, IStorage storage) {
        if (storage instanceof IFile && JavaCore.isJavaLikeFileName((String)storage.getFullPath().lastSegment())) {
            IJavaElement element = JavaCore.create((IResource)((IFile)storage).getParent());
            String fileName = storage.getFullPath().lastSegment();
            String typeName = fileName.substring(0, fileName.lastIndexOf(46));
            if (element instanceof IPackageFragmentRoot) {
                this.queueJavaChange(typeName);
            } else if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                this.queueJavaChange(String.valueOf(packageFragment.getElementName()) + "." + typeName);
            }
        } else {
            if (!this.isHandled(storage)) {
                return true;
            }
            URI uri = this.getUri(storage);
            if (uri != null) {
                toBeBuilt.getToBeDeleted().add(uri);
            }
        }
        return true;
    }

    protected void queueJavaChange(String typeName) {
        URI typeURI = this.typeURIHelper.createResourceURIForFQN(typeName);
        TypeResourceDescription oldDescription = new TypeResourceDescription(typeURI, Collections.emptyList());
        ChangedResourceDescriptionDelta delta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, null);
        this.queuedBuildData.queueChanges(Collections.singleton(delta));
    }

    protected boolean isHandled(IStorage resource) {
        if (!this.uriValidator.isPossiblyManaged(resource)) {
            return false;
        }
        return resource instanceof IJarEntryResource || super.isHandled(resource);
    }

    protected boolean isHandled(IFolder folder) {
        boolean result = super.isHandled(folder) && !this.jdtHelper.isFromOutputPath((IResource)folder);
        return result;
    }

    @Singleton
    public static class ModificationStampCache {
        protected Map<String, Long> projectToModificationStamp = Maps.newHashMap();
    }
}

