/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.JDTAwareEclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.util.RuntimeIOException;

public class SourceRelativeFileSystemAccess
extends JDTAwareEclipseResourceFileSystemAccess2 {
    private IFolder currentSource = null;

    public void setCurrentSource(IFolder currentSource) {
        this.currentSource = currentSource;
    }

    protected boolean ensureOutputConfigurationDirectoryExists(OutputConfiguration outputConfig) {
        IContainer container = this.getContainer(outputConfig);
        if (container.exists()) {
            try {
                this.createContainer(container);
                return true;
            }
            catch (CoreException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
        return super.ensureOutputConfigurationDirectoryExists(outputConfig);
    }

    protected IContainer getContainer(OutputConfiguration outputConfig) {
        if (this.currentSource != null) {
            String directory = outputConfig.getOutputDirectory();
            IPath path = this.currentSource.getFullPath().append("../" + directory);
            IFolder folder = this.currentSource.getWorkspace().getRoot().getFolder(path);
            return folder;
        }
        return super.getContainer(outputConfig);
    }

    public void flushSourceTraces(String generatorName) throws CoreException {
        Multimap sourceTraces = this.getSourceTraces();
        if (sourceTraces != null) {
            Set keys = sourceTraces.keySet();
            for (URI uri : keys) {
                if (uri == null || this.currentSource == null) continue;
                Collection paths = sourceTraces.get((Object)uri);
                IFile sourceFile = this.currentSource.getFile(uri.toFileString());
                if (!sourceFile.exists()) continue;
                IPath[] tracePathArray = paths.toArray(new IPath[paths.size()]);
                this.getTraceMarkers().installMarker(sourceFile, generatorName, tracePathArray);
            }
        }
        this.resetSourceTraces();
    }
}

