/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringScope
implements IScope {
    private IScope delegate;
    private Predicate<IEObjectDescription> filter;

    public FilteringScope(IScope delegate, Predicate<IEObjectDescription> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        return Iterables.filter(this.delegate.getAllElements(), this.filter);
    }

    @Override
    public Iterable<IEObjectDescription> getElements(EObject object) {
        return Iterables.filter(this.delegate.getElements(object), this.filter);
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return Iterables.filter(this.delegate.getElements(name), this.filter);
    }

    @Override
    public IEObjectDescription getSingleElement(EObject object) {
        Iterable<IEObjectDescription> elements = this.getElements(object);
        return this.getFirst(elements);
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        Iterable<IEObjectDescription> elements = this.getElements(name);
        return this.getFirst(elements);
    }

    protected IEObjectDescription getFirst(Iterable<IEObjectDescription> elements) {
        Iterator<IEObjectDescription> iterator = elements.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

