/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.validation.ConfigurableIssueCodesProvider;
import org.eclipse.xtext.validation.SeverityConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueSeverities {
    private static final Logger log = Logger.getLogger(IssueSeverities.class);
    private IPreferenceValues preferenceValues;
    private Map<String, PreferenceKey> configurableIssueCodes;
    private SeverityConverter converter;

    public IssueSeverities(IPreferenceValues preferenceValues, Map<String, PreferenceKey> configurableIssueCodes, SeverityConverter converter) {
        this.preferenceValues = preferenceValues;
        this.configurableIssueCodes = configurableIssueCodes;
        this.converter = converter;
    }

    public Severity getSeverity(String code) {
        if (!this.configurableIssueCodes.containsKey(code)) {
            log.error((Object)("Configurable issue code '" + code + "' is not registered. Check the binding for " + ConfigurableIssueCodesProvider.class.getName()));
            return Severity.IGNORE;
        }
        String value = this.preferenceValues.getPreference(this.configurableIssueCodes.get(code));
        try {
            return this.converter.stringToSeverity(value);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Severity.IGNORE;
        }
    }

    public boolean isIgnored(String code) {
        return this.getSeverity(code) == Severity.IGNORE;
    }
}

