/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.resourceloader;

import com.google.common.annotations.Beta;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public abstract class AbstractResourceLoader
implements IResourceLoader {
    private final IResourceSetProvider resourceSetProvider;
    private final IResourceLoader.Sorter sorter;

    public AbstractResourceLoader(IResourceSetProvider resourceSetProvider, IResourceLoader.Sorter sorter) {
        this.resourceSetProvider = resourceSetProvider;
        this.sorter = sorter;
    }

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    public IResourceLoader.Sorter getSorter() {
        return this.sorter;
    }

    protected Resource loadResource(URI uri, ResourceSet localResourceSet, ResourceSet parentResourceSet) {
        return localResourceSet.getResource(uri, true);
    }

    @Beta
    public class CheckedLoadOperation
    implements IResourceLoader.LoadOperation {
        private final IResourceLoader.LoadOperation parent;
        private boolean isLoading = false;
        private boolean isCancelled = false;

        public CheckedLoadOperation(IResourceLoader.LoadOperation parent) {
            this.parent = parent;
        }

        @Override
        public void load(Collection<URI> uris) {
            if (this.isLoading) {
                throw new IllegalStateException("The load operation has already been started.");
            }
            this.isLoading = true;
            this.parent.load(uris);
        }

        @Override
        public boolean hasNext() {
            this.checkIsLoading();
            this.checkIsNotCancelled();
            return this.parent.hasNext();
        }

        @Override
        public IResourceLoader.LoadResult next() throws IResourceLoader.LoadOperationException {
            this.checkIsLoading();
            this.checkIsNotCancelled();
            return this.parent.next();
        }

        @Override
        public Collection<URI> cancel() {
            this.checkIsLoading();
            this.isCancelled = true;
            return this.parent.cancel();
        }

        private void checkIsLoading() {
            if (!this.isLoading) {
                throw new IllegalStateException("The load operation hasn't started yet.");
            }
        }

        private void checkIsNotCancelled() {
            if (this.isCancelled) {
                throw new IllegalStateException("The load operation was cancelled.");
            }
        }
    }
}

