/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.junit.typesystem;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URL;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.access.ClasspathTypeProviderFactory;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.junit4.smoketest.ScenarioProcessor;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;
import org.junit.Assert;
import org.junit.ComparisonFailure;

@Singleton
public class NoJRESmokeTester
extends ScenarioProcessor {
    @Inject
    private ParseHelper<EObject> parseHelperNoJRE;
    @Inject
    private Provider<ResourceValidatorImpl> resourceValidatorProvider;
    @Inject
    private TypeResourceServices typeResourceServices;

    public void processFile(String data) throws Exception {
        XtextResourceSet resourceSet = new XtextResourceSet();
        NoOpClassLoader classLoader = new NoOpClassLoader();
        resourceSet.setClasspathURIContext((Object)classLoader);
        ClasspathTypeProviderFactory factory = new ClasspathTypeProviderFactory((ClassLoader)classLoader, this.typeResourceServices);
        factory.createTypeProvider((ResourceSet)resourceSet);
        EObject parsed = this.parseHelperNoJRE.parse((CharSequence)data, (ResourceSet)resourceSet);
        EcoreUtil.resolveAll((EObject)parsed);
        this.checkNoErrorsInValidator(data, (XtextResource)parsed.eResource());
    }

    protected void checkNoErrorsInValidator(final String model, XtextResource resource) {
        ResourceValidatorImpl validator = (ResourceValidatorImpl)this.resourceValidatorProvider.get();
        Assert.assertNotSame((Object)validator, (Object)resource.getResourceServiceProvider().getResourceValidator());
        validator.setDiagnosticConverter(new IDiagnosticConverter(){

            public void convertValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
                if (diagnostic instanceof BasicDiagnostic) {
                    List data = diagnostic.getData();
                    if (!data.isEmpty() && data.get(0) instanceof Throwable) {
                        Throwable t = (Throwable)data.get(0);
                        this.throwError(t);
                    }
                    if ("org.eclipse.emf.ecore".equals(diagnostic.getSource()) && diagnostic.getCode() == 3) {
                        this.throwError(new RuntimeException("Dangling reference found."));
                    }
                }
            }

            private void throwError(Throwable e) {
                ComparisonFailure result = new ComparisonFailure(e.getMessage(), model, "");
                result.setStackTrace(e.getStackTrace());
                throw result;
            }

            public void convertResourceDiagnostic(Resource.Diagnostic diagnostic, Severity severity, IAcceptor<Issue> acceptor) {
                if (diagnostic instanceof ExceptionDiagnostic) {
                    Exception e = ((ExceptionDiagnostic)diagnostic).getException();
                    this.throwError(e);
                }
            }
        });
        validator.validate((Resource)resource, CheckMode.ALL, CancelIndicator.NullImpl);
    }

    public static class NoOpClassLoader
    extends ClassLoader {
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            return null;
        }
    }
}

