/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmTypeDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JvmInterfaceDeclarationImpl
extends JvmTypeDeclarationImpl<JvmGenericType>
implements InterfaceDeclaration {
    public Iterable<? extends TypeReference> getExtendedInterfaces() {
        List _xblockexpression = null;
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _superTypes = _delegate.getSuperTypes();
        Functions.Function1<JvmTypeReference, Boolean> _function = new Functions.Function1<JvmTypeReference, Boolean>(){

            public Boolean apply(JvmTypeReference it) {
                JvmType _type = it.getType();
                return ((JvmGenericType)_type).isInterface();
            }
        };
        Iterable filtered = IterableExtensions.filter((Iterable)_superTypes, (Functions.Function1)_function);
        Functions.Function1<JvmTypeReference, TypeReference> _function_1 = new Functions.Function1<JvmTypeReference, TypeReference>(){

            public TypeReference apply(JvmTypeReference it) {
                CompilationUnit _compilationUnit = JvmInterfaceDeclarationImpl.this.getCompilationUnit();
                return _compilationUnit.toTypeReference(it);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)filtered, (Functions.Function1)_function_1);
        _xblockexpression = IterableExtensions.toList((Iterable)_map);
        return _xblockexpression;
    }

    public Iterable<? extends TypeParameterDeclaration> getTypeParameters() {
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _typeParameters = _delegate.getTypeParameters();
        Functions.Function1<JvmTypeParameter, TypeParameterDeclaration> _function = new Functions.Function1<JvmTypeParameter, TypeParameterDeclaration>(){

            public TypeParameterDeclaration apply(JvmTypeParameter it) {
                CompilationUnit _compilationUnit = JvmInterfaceDeclarationImpl.this.getCompilationUnit();
                return _compilationUnit.toTypeParameterDeclaration(it);
            }
        };
        return ListExtensions.map((List)_typeParameters, (Functions.Function1)_function);
    }

    public boolean isStrictFloatingPoint() {
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        return _delegate.isStrictFloatingPoint();
    }

    @Override
    public MutableMethodDeclaration addMethod(String name, Procedures.Procedure1<MutableMethodDeclaration> initializer) {
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal(initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        JvmOperation newMethod = TypesFactory.eINSTANCE.createJvmOperation();
        newMethod.setVisibility(JvmVisibility.PUBLIC);
        newMethod.setSimpleName(name);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        TypeReferenceProvider _typeReferenceProvider = _compilationUnit_1.getTypeReferenceProvider();
        TypeReference _primitiveVoid = _typeReferenceProvider.getPrimitiveVoid();
        JvmTypeReference _jvmTypeReference = _compilationUnit.toJvmTypeReference(_primitiveVoid);
        newMethod.setReturnType(_jvmTypeReference);
        newMethod.setAbstract(true);
        JvmGenericType _delegate = (JvmGenericType)this.getDelegate();
        EList _members = _delegate.getMembers();
        _members.add((Object)newMethod);
        CompilationUnit _compilationUnit_2 = this.getCompilationUnit();
        MemberDeclaration _memberDeclaration = _compilationUnit_2.toMemberDeclaration((JvmMember)newMethod);
        MutableMethodDeclaration mutableMethodDeclaration = (MutableMethodDeclaration)_memberDeclaration;
        initializer.apply((Object)mutableMethodDeclaration);
        return mutableMethodDeclaration;
    }

    @Override
    public MutableConstructorDeclaration addConstructor(Procedures.Procedure1<MutableConstructorDeclaration> initializer) {
        String _simpleName = this.getSimpleName();
        String _plus = "The interface '" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "' cannot declare any constructors.";
        throw new UnsupportedOperationException(_plus_1);
    }
}

