/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.macro.declaration.ExpressionImpl;
import org.eclipse.xtend.core.macro.declaration.JvmConstructorDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.JvmFieldDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.XtendConstructorDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.ConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;

public class MutableJvmFieldDeclarationImpl
extends JvmFieldDeclarationImpl
implements MutableFieldDeclaration {
    public void markAsRead() {
        this.checkMutable();
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        ReadAndWriteTracking _readAndWriteTracking = _compilationUnit.getReadAndWriteTracking();
        JvmField _delegate = (JvmField)this.getDelegate();
        _readAndWriteTracking.markReadAccess((EObject)_delegate);
    }

    public void markAsInitializedBy(ConstructorDeclaration constructorDeclaration) {
        Object _delegate;
        CompilationUnit _compilationUnit;
        this.checkMutable();
        JvmConstructor _switchResult = null;
        boolean _matched = false;
        if (!_matched && constructorDeclaration instanceof JvmConstructorDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmConstructor)((JvmConstructorDeclarationImpl)constructorDeclaration).getDelegate();
        }
        if (!_matched && constructorDeclaration instanceof XtendConstructorDeclarationImpl) {
            _matched = true;
            JvmConstructor _xblockexpression = null;
            _compilationUnit = this.getCompilationUnit();
            IXtendJvmAssociations _jvmModelAssociations = _compilationUnit.getJvmModelAssociations();
            _delegate = (XtendConstructor)((XtendConstructorDeclarationImpl)constructorDeclaration).getDelegate();
            EObject jvmElement = _jvmModelAssociations.getPrimaryJvmElement((EObject)_delegate);
            JvmConstructor _xifexpression = null;
            if (jvmElement instanceof JvmConstructor) {
                _xifexpression = (JvmConstructor)jvmElement;
            }
            _switchResult = _xblockexpression = _xifexpression;
        }
        JvmConstructor constructor = _switchResult;
        _compilationUnit = this.getCompilationUnit();
        ReadAndWriteTracking _readAndWriteTracking = _compilationUnit.getReadAndWriteTracking();
        _delegate = (JvmField)this.getDelegate();
        _readAndWriteTracking.markInitialized((EObject)_delegate, constructor);
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    public void setInitializer(Expression initializer) {
        this.checkMutable();
        boolean _equals = Objects.equal((Object)initializer, null);
        if (_equals) {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            JvmTypesBuilder _jvmTypesBuilder = _compilationUnit.getJvmTypesBuilder();
            JvmField _delegate = (JvmField)this.getDelegate();
            _jvmTypesBuilder.removeExistingBody((JvmMember)_delegate);
        } else {
            CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
            JvmTypesBuilder _jvmTypesBuilder_1 = _compilationUnit_1.getJvmTypesBuilder();
            JvmField _delegate_1 = (JvmField)this.getDelegate();
            XExpression _delegate_2 = (XExpression)((ExpressionImpl)initializer).getDelegate();
            _jvmTypesBuilder_1.setInitializer(_delegate_1, _delegate_2);
        }
    }

    public void setInitializer(CompilationStrategy initializer) {
        this.checkMutable();
        boolean _notEquals = !Objects.equal((Object)initializer, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"initializer cannot be null");
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        _compilationUnit.setCompilationStrategy(_delegate, initializer);
    }

    public void setInitializer(StringConcatenationClient template) {
        this.checkMutable();
        boolean _notEquals = !Objects.equal((Object)template, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"template cannot be null");
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        _compilationUnit.setCompilationTemplate(_delegate, template);
    }

    public void setFinal(boolean isFinal) {
        this.checkMutable();
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setFinal(isFinal);
    }

    public void setStatic(boolean isStatic) {
        this.checkMutable();
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setStatic(isStatic);
    }

    public void setTransient(boolean isTransient) {
        this.checkMutable();
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setTransient(isTransient);
    }

    public void setVolatile(boolean isVolatile) {
        this.checkMutable();
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setVolatile(isVolatile);
    }

    public void setType(TypeReference type) {
        this.checkMutable();
        boolean _notEquals = !Objects.equal((Object)type, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"type cannot be null");
        JvmField _delegate = (JvmField)this.getDelegate();
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmTypeReference _jvmTypeReference = _compilationUnit.toJvmTypeReference(type);
        _delegate.setType(_jvmTypeReference);
    }

    public void setConstantValueAsBoolean(final boolean value) {
        this.internalGenericSetConstantValue(value);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value, "");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    private void internalGenericSetConstantValue(Object value) {
        this.checkMutable();
        boolean _notEquals = !Objects.equal((Object)value, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"value cannot be null");
        JvmField _delegate = (JvmField)this.getDelegate();
        _delegate.setConstant(true);
        JvmField _delegate_1 = (JvmField)this.getDelegate();
        _delegate_1.setFinal(true);
        JvmField _delegate_2 = (JvmField)this.getDelegate();
        _delegate_2.setStatic(true);
        JvmField _delegate_3 = (JvmField)this.getDelegate();
        _delegate_3.setConstantValue(value);
    }

    public void setConstantValueAsByte(final byte value) {
        this.internalGenericSetConstantValue(value);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value, "");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    public void setConstantValueAsInt(final int value) {
        this.internalGenericSetConstantValue(value);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value, "");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    public void setConstantValueAsShort(final short value) {
        this.internalGenericSetConstantValue(value);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value, "");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    public void setConstantValueAsLong(final long value) {
        this.internalGenericSetConstantValue(value);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value, "");
                _builder.append((Object)"L");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    public void setConstantValueAsFloat(final float value) {
        this.internalGenericSetConstantValue(Float.valueOf(value));
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)Float.valueOf(value), "");
                _builder.append((Object)"f");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    public void setConstantValueAsDouble(final double value) {
        this.internalGenericSetConstantValue(value);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)value, "");
                _builder.append((Object)"d");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    public void setConstantValueAsChar(final char value) {
        this.internalGenericSetConstantValue(Character.valueOf(value));
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"'");
                String _string = Character.toString(value);
                String _convertToJavaString = Strings.convertToJavaString((String)_string);
                _builder.append((Object)_convertToJavaString, "");
                _builder.append((Object)"'");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }

    public void setConstantValueAsString(final String value) {
        this.internalGenericSetConstantValue(value);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmField _delegate = (JvmField)this.getDelegate();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"\"");
                String _convertToJavaString = Strings.convertToJavaString((String)value);
                _builder.append((Object)_convertToJavaString, "");
                _builder.append((Object)"\"");
            }
        };
        _compilationUnit.setCompilationTemplate(_delegate, _client);
    }
}

