################################################################################
# Copyright (c) 2025 Bayerische Motoren Werke Aktiengesellschaft (BMW AG)
#
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0.
#
# SPDX-License-Identifier: EPL-2.0
################################################################################
from pathlib import Path
from tempfile import TemporaryDirectory
import pytest
from pytest_optestrunner.utils import find_matching_file

def test_find_matching_file_single_match():
    with TemporaryDirectory() as tmpdir:
        tmpdir_path = Path(tmpdir)

        matching_file = tmpdir_path / "Cyclics_Run_1.csv"
        matching_file.touch()

        result = find_matching_file(tmpdir_path, r'Cyclics_Run_0*1\.csv')
        assert result == "Cyclics_Run_1.csv"

def test_find_matching_file_single_match_with_preceeding_zeeros():
    with TemporaryDirectory() as tmpdir:
        tmpdir_path = Path(tmpdir)

        matching_file = tmpdir_path / "Cyclics_Run_0001.csv"
        matching_file.touch()

        result = find_matching_file(tmpdir_path, r'Cyclics_Run_0*1\.csv')
        assert result == "Cyclics_Run_0001.csv"

def test_find_matching_file_no_match():
    with TemporaryDirectory() as tmpdir:
        tmpdir_path = Path(tmpdir)
        (tmpdir_path / "Cyclics_Run_2.csv").touch()

        with pytest.raises(FileNotFoundError, match=r"Either no file matching.*"):
            find_matching_file(tmpdir_path, r'Cyclics_Run_0*1\.csv')

def test_find_matching_file_multiple_matches():
    with TemporaryDirectory() as tmpdir:
        tmpdir_path = Path(tmpdir)
        (tmpdir_path / "Cyclics_Run_1.csv").touch()
        (tmpdir_path / "Cyclics_Run_01.csv").touch()

        with pytest.raises(FileNotFoundError, match=r"Either no file matching.*"):
            find_matching_file(tmpdir_path, r'Cyclics_Run_0*1\.csv')
