#!/usr/bin/env python3
################################################################################
# Copyright (c) 2024 Bayerische Motoren Werke Aktiengesellschaft (BMW AG)
#
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0.
#
# SPDX-License-Identifier: EPL-2.0
################################################################################

import argparse
import logging
from pathlib import Path
from logging.handlers import RotatingFileHandler

def get_logger():
    return logging.getLogger()

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--results-path', '-r',
                        type=str,
                        required=True,
                        help='Path to the simulation results, i.e. where the simulationOutput.xml is located')
    parser.add_argument('--backup', '-b',
                        action='store_true',
                        help='Create a backup of an already existing simulationOutput.xml')
    parser.add_argument('--keep-source',
                        action='store_true',
                        help='Keep the the source file of the given component')
    parser.add_argument('--debug', "-d",
                        action='store_true',
                        help='Enable debug logging')

    args = parser.parse_args()
    args.results_path = Path(args.results_path)
    return args

def init_logger(log_file, debug):
    logger = logging.getLogger()
    logger.setLevel(logging.INFO)

    file_handler = RotatingFileHandler(log_file, maxBytes=1024*1024, backupCount=5)
    file_handler.setLevel(logging.DEBUG if debug else logging.INFO)

    console_handler = logging.StreamHandler()
    console_handler.setLevel(logging.DEBUG if debug else logging.INFO)

    formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
    file_handler.setFormatter(formatter)
    console_handler.setFormatter(formatter)

    logger.addHandler(file_handler)
    logger.addHandler(console_handler)
