################################################################################
# Copyright (c) 2022 Bayerische Motoren Werke Aktiengesellschaft (BMW AG)
#
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0.
#
# SPDX-License-Identifier: EPL-2.0
################################################################################

from dataclasses import dataclass
from lxml import etree
from pathlib import Path

@dataclass(frozen=True)
class XmlNode:
    xml_file: str
    xpath_expr: str
    datatype: object = None

    def node_exists(self, base_path) -> bool:
        try:
            tree = etree.parse(Path(base_path) / self.xml_file)
            node = tree.xpath(self.xpath_expr)
            return bool(node)
        except Exception as e:
            print(f"Warning: Unable to extract node for file '{self.xml_file}' with xpath '{self.xpath_expr}': {e}")
            return False

@dataclass(frozen=True)
class XmlSetter:
    dest: XmlNode
    value: str = None
