################################################################################
# Copyright (c) 2021-2025 Bayerische Motoren Werke Aktiengesellschaft (BMW AG)
#
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0.
#
# SPDX-License-Identifier: EPL-2.0
################################################################################
import json
from pytest_optestrunner.config_parser import TestItem
from pytest_optestrunner.xml_util import XmlUtil

class ConfigModulator:
    @staticmethod
    def apply(test_item: TestItem, config_path):
        update_values = {'invocations': test_item.invocations,
                         'duration': test_item.duration,
                         'config_path': str(config_path)}
        XmlUtil.update(config_path, update_values)

        if test_item.plugin:
            test_item.plugin.apply(config_path, test_item.param, test_item.index)

    @staticmethod
    def write_optestrunner_info(test_item: TestItem, paths, executable_path):
        optestrunner_info = {
            "executable": str(executable_path),
            "--scenario": "Scenario.xosc",
            "--gtgen-data": str(paths.configs),
            "--number-runs": test_item.invocations,
            "--random-seed": test_item.random_seed,
            "--step-size-ms": 100
        }

        with open(paths.configs / "opTestrunnerInfo.json", "w", encoding="utf-8") as json_file:
            json.dump(optestrunner_info, json_file, indent=4)
