/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.RDF4J;
import org.eclipse.rdf4j.common.app.AppConfiguration;
import org.eclipse.rdf4j.common.app.AppVersion;
import org.eclipse.rdf4j.console.CmdLineParser;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.DefaultConsoleState;
import org.eclipse.rdf4j.console.command.Clear;
import org.eclipse.rdf4j.console.command.Close;
import org.eclipse.rdf4j.console.command.Connect;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.command.Convert;
import org.eclipse.rdf4j.console.command.Create;
import org.eclipse.rdf4j.console.command.Disconnect;
import org.eclipse.rdf4j.console.command.Drop;
import org.eclipse.rdf4j.console.command.Export;
import org.eclipse.rdf4j.console.command.Federate;
import org.eclipse.rdf4j.console.command.Load;
import org.eclipse.rdf4j.console.command.Open;
import org.eclipse.rdf4j.console.command.PrintHelp;
import org.eclipse.rdf4j.console.command.PrintInfo;
import org.eclipse.rdf4j.console.command.QueryEvaluator;
import org.eclipse.rdf4j.console.command.Serql;
import org.eclipse.rdf4j.console.command.SetParameters;
import org.eclipse.rdf4j.console.command.Show;
import org.eclipse.rdf4j.console.command.Sparql;
import org.eclipse.rdf4j.console.command.TupleAndGraphQueryEvaluator;
import org.eclipse.rdf4j.console.command.Verify;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.console.setting.ConsoleWidth;
import org.eclipse.rdf4j.console.setting.LogLevel;
import org.eclipse.rdf4j.console.setting.Prefixes;
import org.eclipse.rdf4j.console.setting.QueryPrefix;
import org.eclipse.rdf4j.console.setting.ShowPrefix;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;

public class Console {
    private static final AppVersion VERSION = AppVersion.parse(RDF4J.getVersion());
    private static final String APP_NAME = "Console";
    private static final AppConfiguration APP_CFG = new AppConfiguration("Console", VERSION);
    private static final ConsoleState STATE = new DefaultConsoleState(APP_CFG);
    private static final String PROP_PREFIX = "org.eclipse.rdf4j.console.setting.";
    private static boolean exitOnError;
    private final ConsoleIO consoleIO;
    private final SortedMap<String, ConsoleCommand> commandMap = new TreeMap<String, ConsoleCommand>();
    private final SortedMap<String, ConsoleSetting> settingMap = new TreeMap<String, ConsoleSetting>();
    private final Connect connect;
    private final Disconnect disconnect;
    private final Open open;
    private final Close close;

    public ConsoleState getState() {
        return STATE;
    }

    public ConsoleIO getConsoleIO() {
        return this.consoleIO;
    }

    protected void setExitOnError(boolean mode) {
        exitOnError = mode;
    }

    public static void main(String[] args) throws IOException {
        Console console = new Console();
        CmdLineParser parser = new CmdLineParser(console);
        if (parser.parse(args) == null) {
            System.exit(-1);
        }
        if (!parser.handleInfoOptions()) {
            System.exit(0);
        }
        parser.handleEchoOptions();
        parser.handleExitOption();
        String location = parser.handleLocationGroup();
        if (!parser.handleCautionGroup()) {
            System.exit(3);
        }
        String otherArg = parser.handleOtherArg();
        Console.connectAndOpen(console, parser.getSelectedLocation(), location, otherArg);
        console.start();
    }

    private static void connectAndOpen(Console console, String selectedLocation, String location, String otherArg) {
        boolean connected = "s".equals(selectedLocation) ? console.connect.connectRemote(location) : ("d".equals(selectedLocation) ? console.connect.connectLocal(location) : console.connect.connectDefault());
        if (!connected) {
            System.exit(2);
        }
        if (!otherArg.isEmpty()) {
            console.open.openRepository(otherArg);
        }
    }

    public final void register(ConsoleCommand cmd) {
        this.commandMap.put(cmd.getName(), cmd);
    }

    public final void register(ConsoleSetting setting) {
        this.settingMap.put(setting.getName(), setting);
    }

    public Console() throws IOException {
        APP_CFG.init();
        this.register(new ConsoleWidth());
        this.register(new LogLevel());
        this.register(new Prefixes());
        this.register(new QueryPrefix());
        this.register(new ShowPrefix());
        this.register(new WorkDir());
        this.consoleIO = new ConsoleIO(STATE);
        this.close = new Close(this.consoleIO, STATE);
        this.disconnect = new Disconnect(this.consoleIO, STATE, this.close);
        this.connect = new Connect(this.consoleIO, STATE, this.disconnect);
        this.open = new Open(this.consoleIO, STATE, this.close);
        this.register(this.open);
        this.register(this.close);
        this.register(this.connect);
        this.register(this.disconnect);
        TupleAndGraphQueryEvaluator eval = new TupleAndGraphQueryEvaluator(this.consoleIO, STATE, this.settingMap);
        this.register(new Federate(this.consoleIO, STATE));
        this.register(new Sparql(eval));
        this.register(new Serql(eval));
        this.register(new PrintHelp(this.consoleIO, this.commandMap));
        this.register(new PrintInfo(this.consoleIO, STATE));
        this.register(new Show(this.consoleIO, STATE));
        this.register(new Create(this.consoleIO, STATE));
        this.register(new Drop(this.consoleIO, STATE, this.close));
        this.register(new Verify(this.consoleIO));
        this.register(new Load(this.consoleIO, STATE));
        this.register(new Clear(this.consoleIO, STATE));
        this.register(new Export(this.consoleIO, STATE));
        this.register(new Convert(this.consoleIO, STATE));
        this.register(new SetParameters(this.consoleIO, STATE, this.settingMap));
    }

    private void loadSettings() {
        Properties props = APP_CFG.getProperties();
        this.settingMap.forEach((k, v) -> {
            String val = props.getProperty(PROP_PREFIX + k, "");
            try {
                if (!val.isEmpty()) {
                    v.setFromString(val);
                }
            }
            catch (IllegalArgumentException iae) {
                this.consoleIO.writeError("Illegal value for property " + k);
            }
        });
    }

    private void saveSettings() {
        Properties props = APP_CFG.getProperties();
        this.settingMap.forEach((k, v) -> {
            String val;
            String prop = PROP_PREFIX + k;
            String oldval = props.getProperty(prop, "");
            String newval = v.getAsString();
            String string = val = newval != null ? newval : oldval;
            if (!val.isEmpty()) {
                props.setProperty(prop, val);
            } else {
                props.remove(prop);
            }
        });
        try {
            APP_CFG.save();
        }
        catch (IOException ex) {
            this.consoleIO.writeError("Could not save properties: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.consoleIO.writeln(APP_CFG.getFullName());
        this.consoleIO.writeln();
        this.consoleIO.writeln(RDF4J.getVersion());
        this.consoleIO.writeln("Type 'help' for help.");
        this.loadSettings();
        int exitCode = 0;
        try {
            boolean exitFlag = false;
            while (!exitFlag) {
                String command = this.consoleIO.readCommand();
                if (command == null) {
                    break;
                }
                exitFlag = this.executeCommand(command);
                if (!exitOnError || !this.consoleIO.wasErrorWritten()) continue;
                exitCode = 2;
                exitFlag = true;
            }
        }
        catch (EndOfFileException | UserInterruptException e) {
            exitCode = 0;
        }
        finally {
            this.disconnect.execute(false);
        }
        this.saveSettings();
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        this.consoleIO.writeln("Bye");
        this.consoleIO.getOutputStream().close();
    }

    private boolean executeCommand(String command) throws IOException {
        boolean exit = false;
        if (0 < command.length()) {
            String[] tokens = this.parse(command);
            String operation = tokens[0].toLowerCase(Locale.ENGLISH);
            boolean bl = exit = "quit".equals(operation) || "exit".equals(operation);
            if (!exit) {
                ConsoleCommand cmd = (ConsoleCommand)this.commandMap.getOrDefault(operation, (ConsoleCommand)this.commandMap.get("sparql"));
                if (cmd instanceof QueryEvaluator) {
                    ((QueryEvaluator)cmd).executeQuery(command, operation);
                } else {
                    cmd.execute(tokens);
                }
            }
        }
        return exit;
    }

    private String[] parse(String command) {
        Pattern pattern = Pattern.compile("\"([^\"]*)\"|(\\S+)");
        Matcher matcher = pattern.matcher(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.group(1) == null) {
                tokens.add(matcher.group());
                continue;
            }
            tokens.add(matcher.group(1));
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

