/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.config;

import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.config.ShaclSailConfig;

public class ShaclSailFactory
implements SailFactory {
    public static final String SAIL_TYPE = "rdf4j:ShaclSail";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new ShaclSailConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        ShaclSail sail = new ShaclSail();
        if (config instanceof ShaclSailConfig) {
            ShaclSailConfig shaclSailConfig = (ShaclSailConfig)config;
            if (shaclSailConfig.isValidationEnabled()) {
                sail.enableValidation();
            } else {
                sail.disableValidation();
            }
            sail.setCacheSelectNodes(shaclSailConfig.isCacheSelectNodes());
            sail.setUndefinedTargetValidatesAllSubjects(shaclSailConfig.isUndefinedTargetValidatesAllSubjects());
            sail.setIgnoreNoShapesLoadedException(shaclSailConfig.isIgnoreNoShapesLoadedException());
            sail.setLogValidationPlans(shaclSailConfig.isLogValidationPlans());
            sail.setLogValidationViolations(shaclSailConfig.isLogValidationViolations());
            sail.setParallelValidation(shaclSailConfig.isParallelValidation());
            sail.setGlobalLogValidationExecution(shaclSailConfig.isGlobalLogValidationExecution());
        }
        return sail;
    }
}

