/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.AFN;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SP;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.model.vocabulary.SPL;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.DescribeOperator;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.queryrender.sparql.SPARQLQueryRenderer;
import org.eclipse.rdf4j.spin.Argument;
import org.eclipse.rdf4j.spin.ConstraintViolation;
import org.eclipse.rdf4j.spin.ConstraintViolationLevel;
import org.eclipse.rdf4j.spin.MalformedSpinException;
import org.eclipse.rdf4j.spin.RuleProperty;
import org.eclipse.rdf4j.spin.SpinWellKnownFunctions;
import org.eclipse.rdf4j.spin.SpinWellKnownVars;
import org.eclipse.rdf4j.spin.Template;
import org.eclipse.rdf4j.spin.function.FunctionParser;
import org.eclipse.rdf4j.spin.function.KnownFunctionParser;
import org.eclipse.rdf4j.spin.function.KnownTupleFunctionParser;
import org.eclipse.rdf4j.spin.function.SpinFunctionParser;
import org.eclipse.rdf4j.spin.function.SpinTupleFunctionAsFunctionParser;
import org.eclipse.rdf4j.spin.function.SpinTupleFunctionParser;
import org.eclipse.rdf4j.spin.function.SpinxFunctionParser;
import org.eclipse.rdf4j.spin.function.TupleFunctionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinParser {
    private static final Logger logger = LoggerFactory.getLogger(SpinParser.class);
    private static final Set<IRI> QUERY_TYPES = Sets.newHashSet((Object[])new IRI[]{SP.SELECT_CLASS, SP.CONSTRUCT_CLASS, SP.ASK_CLASS, SP.DESCRIBE_CLASS});
    private static final Set<IRI> UPDATE_TYPES = Sets.newHashSet((Object[])new IRI[]{SP.MODIFY_CLASS, SP.DELETE_WHERE_CLASS, SP.INSERT_DATA_CLASS, SP.DELETE_DATA_CLASS, SP.LOAD_CLASS, SP.CLEAR_CLASS, SP.CREATE_CLASS, SP.DROP_CLASS});
    private static final Set<IRI> COMMAND_TYPES = Sets.union(QUERY_TYPES, UPDATE_TYPES);
    private static final Set<IRI> NON_TEMPLATES = Sets.newHashSet((Object[])new IRI[]{RDFS.RESOURCE, SP.SYSTEM_CLASS, SP.COMMAND_CLASS, SP.QUERY_CLASS, SP.UPDATE_CLASS, SPIN.MODULES_CLASS, SPIN.TEMPLATES_CLASS, SPIN.ASK_TEMPLATES_CLASS, SPIN.SELECT_TEMPLATES_CLASS, SPIN.CONSTRUCT_TEMPLATES_CLASS, SPIN.UPDATE_TEMPLATES_CLASS, SPIN.RULE_CLASS});
    private static final Set<IRI> TEMPLATE_TYPES = Sets.newHashSet((Object[])new IRI[]{SPIN.ASK_TEMPLATE_CLASS, SPIN.SELECT_TEMPLATE_CLASS, SPIN.CONSTRUCT_TEMPLATE_CLASS, SPIN.UPDATE_TEMPLATE_CLASS});
    private final Input input;
    private final com.google.common.base.Function<IRI, String> wellKnownVars;
    private final com.google.common.base.Function<IRI, String> wellKnownFunctions;
    private List<FunctionParser> functionParsers;
    private List<TupleFunctionParser> tupleFunctionParsers;
    private boolean strictFunctionChecking = true;
    private final Cache<IRI, Template> templateCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final Cache<IRI, Map<IRI, Argument>> argumentCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public SpinParser() {
        this(Input.TEXT_FIRST);
    }

    public SpinParser(Input input) {
        this(input, new com.google.common.base.Function<IRI, String>(){

            public String apply(IRI IRI2) {
                return SpinWellKnownVars.INSTANCE.getName(IRI2);
            }
        }, new com.google.common.base.Function<IRI, String>(){

            public String apply(IRI IRI2) {
                return SpinWellKnownFunctions.INSTANCE.getName(IRI2);
            }
        });
    }

    public SpinParser(Input input, com.google.common.base.Function<IRI, String> wellKnownVarsMapper, com.google.common.base.Function<IRI, String> wellKnownFuncMapper) {
        this.input = input;
        this.wellKnownVars = wellKnownVarsMapper;
        this.wellKnownFunctions = wellKnownFuncMapper;
        this.functionParsers = Arrays.asList(new KnownFunctionParser(FunctionRegistry.getInstance(), this.wellKnownFunctions), new SpinTupleFunctionAsFunctionParser(this), new SpinFunctionParser(this), new SpinxFunctionParser(this));
        this.tupleFunctionParsers = Arrays.asList(new KnownTupleFunctionParser(TupleFunctionRegistry.getInstance()), new SpinTupleFunctionParser(this));
    }

    public List<FunctionParser> getFunctionParsers() {
        return this.functionParsers;
    }

    public void setFunctionParsers(List<FunctionParser> functionParsers) {
        this.functionParsers = functionParsers;
    }

    public List<TupleFunctionParser> getTupleFunctionParsers() {
        return this.tupleFunctionParsers;
    }

    public void setTupleFunctionParsers(List<TupleFunctionParser> tupleFunctionParsers) {
        this.tupleFunctionParsers = tupleFunctionParsers;
    }

    public boolean isStrictFunctionChecking() {
        return this.strictFunctionChecking;
    }

    public void setStrictFunctionChecking(boolean strictFunctionChecking) {
        this.strictFunctionChecking = strictFunctionChecking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IRI, RuleProperty> parseRuleProperties(TripleSource store) throws RDF4JException {
        HashMap<IRI, RuleProperty> rules = new HashMap<IRI, RuleProperty>();
        try (CloseableIteration<? extends IRI, QueryEvaluationException> rulePropIter = TripleSources.getSubjectURIs(RDFS.SUBPROPERTYOF, SPIN.RULE_PROPERTY, store);){
            while (rulePropIter.hasNext()) {
                IRI ruleProp = (IRI)rulePropIter.next();
                RuleProperty ruleProperty = new RuleProperty(ruleProp);
                List<IRI> nextRules = this.getNextRules(ruleProp, store);
                ruleProperty.setNextRules(nextRules);
                int maxIterCount = this.getMaxIterationCount(ruleProp, store);
                ruleProperty.setMaxIterationCount(maxIterCount);
                rules.put(ruleProp, ruleProperty);
            }
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IRI> getNextRules(Resource ruleProp, TripleSource store) throws RDF4JException {
        ArrayList<IRI> nextRules = new ArrayList<IRI>();
        try (CloseableIteration<? extends IRI, QueryEvaluationException> iter = TripleSources.getObjectURIs(ruleProp, SPIN.NEXT_RULE_PROPERTY_PROPERTY, store);){
            while (iter.hasNext()) {
                nextRules.add((IRI)iter.next());
            }
        }
        return nextRules;
    }

    private int getMaxIterationCount(Resource ruleProp, TripleSource store) throws RDF4JException {
        Value v = TripleSources.singleValue(ruleProp, SPIN.RULE_PROPERTY_MAX_ITERATION_COUNT_PROPERTY, store);
        if (v == null) {
            return -1;
        }
        if (v instanceof Literal) {
            try {
                return ((Literal)v).intValue();
            }
            catch (NumberFormatException e) {
                throw new MalformedSpinException("Value for " + SPIN.RULE_PROPERTY_MAX_ITERATION_COUNT_PROPERTY + " must be of datatype " + XMLSchema.INTEGER + ": " + ruleProp);
            }
        }
        throw new MalformedSpinException("Non-literal value for " + SPIN.RULE_PROPERTY_MAX_ITERATION_COUNT_PROPERTY + ": " + ruleProp);
    }

    public boolean isThisUnbound(Resource subj, TripleSource store) throws RDF4JException {
        return TripleSources.booleanValue(subj, SPIN.THIS_UNBOUND_PROPERTY, store);
    }

    public ConstraintViolation parseConstraintViolation(Resource subj, TripleSource store) throws RDF4JException {
        Value labelValue = TripleSources.singleValue(subj, RDFS.LABEL, store);
        Value rootValue = TripleSources.singleValue(subj, SPIN.VIOLATION_ROOT_PROPERTY, store);
        Value pathValue = TripleSources.singleValue(subj, SPIN.VIOLATION_PATH_PROPERTY, store);
        Value valueValue = TripleSources.singleValue(subj, SPIN.VIOLATION_VALUE_PROPERTY, store);
        Value levelValue = TripleSources.singleValue(subj, SPIN.VIOLATION_LEVEL_PROPERTY, store);
        String label = labelValue instanceof Literal ? labelValue.stringValue() : null;
        String root = rootValue instanceof Resource ? rootValue.stringValue() : null;
        String path = pathValue != null ? pathValue.stringValue() : null;
        String value = valueValue != null ? valueValue.stringValue() : null;
        ConstraintViolationLevel level = ConstraintViolationLevel.ERROR;
        if (levelValue != null) {
            if (levelValue instanceof IRI) {
                level = ConstraintViolationLevel.valueOf((IRI)levelValue);
            }
            if (level == null) {
                throw new MalformedSpinException("Invalid value " + levelValue + " for " + SPIN.VIOLATION_LEVEL_PROPERTY + ": " + subj);
            }
        }
        return new ConstraintViolation(label, root, path, value, level);
    }

    public ParsedOperation parse(Resource queryResource, TripleSource store) throws RDF4JException {
        return this.parse(queryResource, SP.COMMAND_CLASS, store);
    }

    public ParsedQuery parseQuery(Resource queryResource, TripleSource store) throws RDF4JException {
        return (ParsedQuery)this.parse(queryResource, SP.QUERY_CLASS, store);
    }

    public ParsedGraphQuery parseConstructQuery(Resource queryResource, TripleSource store) throws RDF4JException {
        return (ParsedGraphQuery)this.parse(queryResource, SP.CONSTRUCT_CLASS, store);
    }

    public ParsedTupleQuery parseSelectQuery(Resource queryResource, TripleSource store) throws RDF4JException {
        return (ParsedTupleQuery)this.parse(queryResource, SP.SELECT_CLASS, store);
    }

    public ParsedBooleanQuery parseAskQuery(Resource queryResource, TripleSource store) throws RDF4JException {
        return (ParsedBooleanQuery)this.parse(queryResource, SP.ASK_CLASS, store);
    }

    public ParsedDescribeQuery parseDescribeQuery(Resource queryResource, TripleSource store) throws RDF4JException {
        return (ParsedDescribeQuery)this.parse(queryResource, SP.DESCRIBE_CLASS, store);
    }

    public ParsedUpdate parseUpdate(Resource queryResource, TripleSource store) throws RDF4JException {
        return (ParsedUpdate)this.parse(queryResource, SP.UPDATE_CLASS, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedOperation parse(Resource queryResource, IRI queryClass, TripleSource store) throws RDF4JException {
        ParsedOperation parsedOp;
        Boolean isQueryElseTemplate = null;
        HashSet<IRI> possibleQueryTypes = new HashSet<IRI>();
        HashSet<IRI> possibleTemplates = new HashSet<IRI>();
        try (CloseableIteration<? extends IRI, QueryEvaluationException> typeIter = TripleSources.getObjectURIs(queryResource, RDF.TYPE, store);){
            while (typeIter.hasNext()) {
                IRI type = (IRI)typeIter.next();
                if (isQueryElseTemplate == null && SPIN.TEMPLATES_CLASS.equals(type)) {
                    isQueryElseTemplate = Boolean.FALSE;
                    continue;
                }
                if ((isQueryElseTemplate == null || isQueryElseTemplate == Boolean.TRUE) && COMMAND_TYPES.contains(type)) {
                    isQueryElseTemplate = Boolean.TRUE;
                    possibleQueryTypes.add(type);
                    continue;
                }
                if (isQueryElseTemplate != null && isQueryElseTemplate != Boolean.FALSE || NON_TEMPLATES.contains(type)) continue;
                possibleTemplates.add(type);
            }
        }
        if (isQueryElseTemplate == null) {
            throw new MalformedSpinException(String.format("Missing RDF type: %s", queryResource));
        }
        if (isQueryElseTemplate == Boolean.TRUE) {
            if (possibleQueryTypes.size() > 1) {
                throw new MalformedSpinException("Incompatible RDF types for command: " + queryResource + " has types " + possibleQueryTypes);
            }
            IRI queryType = (IRI)possibleQueryTypes.iterator().next();
            if (this.input.textFirst) {
                parsedOp = this.parseText(queryResource, queryType, store);
                if (parsedOp == null && this.input.canFallback) {
                    parsedOp = this.parseRDF(queryResource, queryType, store);
                }
            } else {
                parsedOp = this.parseRDF(queryResource, queryType, store);
                if (parsedOp == null && this.input.canFallback) {
                    parsedOp = this.parseText(queryResource, queryType, store);
                }
            }
            if (parsedOp == null) {
                throw new MalformedSpinException(String.format("Command is not parsable: %s", queryResource));
            }
        } else {
            Set<IRI> abstractTemplates;
            if (possibleTemplates.size() > 1) {
                abstractTemplates = new HashSet();
                Iterator iter = possibleTemplates.iterator();
                while (iter.hasNext()) {
                    IRI t = (IRI)iter.next();
                    boolean isAbstract = TripleSources.booleanValue(t, SPIN.ABSTRACT_PROPERTY, store);
                    if (!isAbstract) continue;
                    abstractTemplates.add(t);
                    iter.remove();
                }
            } else {
                abstractTemplates = Collections.emptySet();
            }
            if (possibleTemplates.isEmpty()) {
                throw new MalformedSpinException(String.format("Template missing RDF type: %s", queryResource));
            }
            if (possibleTemplates.size() > 1) {
                throw new MalformedSpinException("Template has unexpected RDF types: " + queryResource + " has non-abstract types " + possibleTemplates);
            }
            IRI templateResource = (IRI)possibleTemplates.iterator().next();
            Template tmpl = this.getTemplate(templateResource, queryClass, abstractTemplates, store);
            HashMap<IRI, Value> argValues = new HashMap<IRI, Value>(2 * tmpl.getArguments().size());
            for (Argument arg : tmpl.getArguments()) {
                IRI argPred = arg.getPredicate();
                Value argValue = TripleSources.singleValue(queryResource, argPred, store);
                argValues.put(argPred, argValue);
            }
            parsedOp = tmpl.call(argValues);
        }
        return parsedOp;
    }

    private Template getTemplate(final IRI tmplUri, final IRI queryType, final Set<IRI> abstractTmpls, final TripleSource store) throws RDF4JException {
        try {
            return (Template)this.templateCache.get((Object)tmplUri, (Callable)new Callable<Template>(){

                @Override
                public Template call() throws RDF4JException {
                    return SpinParser.this.parseTemplateInternal(tmplUri, queryType, abstractTmpls, store);
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RDF4JException) {
                throw (RDF4JException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template parseTemplateInternal(IRI tmplUri, IRI queryType, Set<IRI> abstractTmpls, TripleSource store) throws RDF4JException {
        HashSet<IRI> possibleTmplTypes = new HashSet<IRI>();
        try (CloseableIteration<? extends IRI, QueryEvaluationException> typeIter = TripleSources.getObjectURIs(tmplUri, RDF.TYPE, store);){
            while (typeIter.hasNext()) {
                IRI type = (IRI)typeIter.next();
                if (!TEMPLATE_TYPES.contains(type)) continue;
                possibleTmplTypes.add(type);
            }
        }
        if (possibleTmplTypes.isEmpty()) {
            throw new MalformedSpinException(String.format("Template missing RDF type: %s", tmplUri));
        }
        if (possibleTmplTypes.size() > 1) {
            throw new MalformedSpinException("Incompatible RDF types for template: " + tmplUri + " has types " + possibleTmplTypes);
        }
        IRI tmplType = (IRI)possibleTmplTypes.iterator().next();
        Set<Object> compatibleTmplTypes = SP.QUERY_CLASS.equals(queryType) ? Sets.newHashSet((Object[])new IRI[]{SPIN.ASK_TEMPLATE_CLASS, SPIN.SELECT_TEMPLATE_CLASS, SPIN.CONSTRUCT_TEMPLATE_CLASS}) : (SP.UPDATE_CLASS.equals(queryType) || UPDATE_TYPES.contains(queryType) ? Collections.singleton(SPIN.UPDATE_TEMPLATE_CLASS) : (SP.ASK_CLASS.equals(queryType) ? Collections.singleton(SPIN.ASK_TEMPLATE_CLASS) : (SP.SELECT_CLASS.equals(queryType) ? Collections.singleton(SPIN.SELECT_TEMPLATE_CLASS) : (SP.CONSTRUCT_CLASS.equals(queryType) ? Collections.singleton(SPIN.CONSTRUCT_TEMPLATE_CLASS) : TEMPLATE_TYPES))));
        if (!compatibleTmplTypes.contains(tmplType)) {
            throw new MalformedSpinException("Template type " + tmplType + " is incompatible with command type " + queryType);
        }
        Template tmpl = new Template(tmplUri);
        Value body = TripleSources.singleValue(tmplUri, SPIN.BODY_PROPERTY, store);
        if (!(body instanceof Resource)) {
            throw new MalformedSpinException(String.format("Template body is not a resource: %s", body));
        }
        ParsedOperation op = this.parse((Resource)body, queryType, store);
        tmpl.setParsedOperation(op);
        Map<IRI, Argument> templateArgs = this.parseTemplateArguments(tmplUri, abstractTmpls, store);
        List<IRI> orderedArgs = SpinParser.orderArguments(templateArgs.keySet());
        for (IRI IRI2 : orderedArgs) {
            Argument arg = templateArgs.get(IRI2);
            tmpl.addArgument(arg);
        }
        return tmpl;
    }

    private Map<IRI, Argument> parseTemplateArguments(IRI tmplUri, Set<IRI> abstractTmpls, TripleSource store) throws RDF4JException {
        HashMap<IRI, Argument> args = new HashMap<IRI, Argument>();
        for (IRI abstractTmpl : abstractTmpls) {
            this.parseArguments(abstractTmpl, store, args);
        }
        this.parseArguments(tmplUri, store, args);
        return args;
    }

    public Function parseFunction(IRI funcUri, TripleSource store) throws RDF4JException {
        for (FunctionParser functionParser : this.functionParsers) {
            Function function = functionParser.parse(funcUri, store);
            if (function == null) continue;
            return function;
        }
        logger.warn("No FunctionParser for function: {}", (Object)funcUri);
        throw new MalformedSpinException(String.format("No FunctionParser for function: %s", funcUri));
    }

    public TupleFunction parseMagicProperty(IRI propUri, TripleSource store) throws RDF4JException {
        for (TupleFunctionParser tupleFunctionParser : this.tupleFunctionParsers) {
            TupleFunction tupleFunction = tupleFunctionParser.parse(propUri, store);
            if (tupleFunction == null) continue;
            return tupleFunction;
        }
        logger.warn("No TupleFunctionParser for magic property: {}", (Object)propUri);
        throw new MalformedSpinException(String.format("No TupleFunctionParser for magic property: %s", propUri));
    }

    public Map<IRI, Argument> parseArguments(final IRI moduleUri, final TripleSource store) throws RDF4JException {
        try {
            return (Map)this.argumentCache.get((Object)moduleUri, (Callable)new Callable<Map<IRI, Argument>>(){

                @Override
                public Map<IRI, Argument> call() throws RDF4JException {
                    HashMap args = new HashMap();
                    SpinParser.this.parseArguments(moduleUri, store, args);
                    return Collections.unmodifiableMap(args);
                }
            });
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RDF4JException) {
                throw (RDF4JException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseArguments(IRI moduleUri, TripleSource store, Map<IRI, Argument> args) throws RDF4JException {
        try (CloseableIteration<? extends Resource, QueryEvaluationException> argIter = TripleSources.getObjectResources(moduleUri, SPIN.CONSTRAINT_PROPERTY, store);){
            while (argIter.hasNext()) {
                Resource possibleArg = (Resource)argIter.next();
                Statement argTmpl = TripleSources.single(possibleArg, RDF.TYPE, SPL.ARGUMENT_TEMPLATE, store);
                if (argTmpl == null) continue;
                Value argPred = TripleSources.singleValue(possibleArg, SPL.PREDICATE_PROPERTY, store);
                Value valueType = TripleSources.singleValue(possibleArg, SPL.VALUE_TYPE_PROPERTY, store);
                boolean optional = TripleSources.booleanValue(possibleArg, SPL.OPTIONAL_PROPERTY, store);
                Value defaultValue = TripleSources.singleValue(possibleArg, SPL.DEFAULT_VALUE_PROPERTY, store);
                IRI argUri = (IRI)argPred;
                args.put(argUri, new Argument(argUri, (IRI)valueType, optional, defaultValue));
            }
        }
    }

    private ParsedOperation parseText(Resource queryResource, IRI queryType, TripleSource store) throws RDF4JException {
        Value text = TripleSources.singleValue(queryResource, SP.TEXT_PROPERTY, store);
        if (text != null) {
            if (QUERY_TYPES.contains(queryType)) {
                return QueryParserUtil.parseQuery(QueryLanguage.SPARQL, text.stringValue(), null);
            }
            if (UPDATE_TYPES.contains(queryType)) {
                return QueryParserUtil.parseUpdate(QueryLanguage.SPARQL, text.stringValue(), null);
            }
            throw new MalformedSpinException(String.format("Unrecognised command type: %s", queryType));
        }
        return null;
    }

    private ParsedOperation parseRDF(Resource queryResource, IRI queryType, TripleSource store) throws RDF4JException {
        if (SP.CONSTRUCT_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitConstruct(queryResource);
            return new ParsedGraphQuery(visitor.getTupleExpr());
        }
        if (SP.SELECT_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitSelect(queryResource);
            return new ParsedTupleQuery(visitor.getTupleExpr());
        }
        if (SP.ASK_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitAsk(queryResource);
            return new ParsedBooleanQuery(visitor.getTupleExpr());
        }
        if (SP.DESCRIBE_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitDescribe(queryResource);
            return new ParsedDescribeQuery(visitor.getTupleExpr());
        }
        if (SP.MODIFY_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitModify(queryResource);
            ParsedUpdate parsedUpdate = new ParsedUpdate();
            parsedUpdate.addUpdateExpr(visitor.getUpdateExpr());
            return parsedUpdate;
        }
        if (SP.DELETE_WHERE_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitDeleteWhere(queryResource);
            ParsedUpdate parsedUpdate = new ParsedUpdate();
            parsedUpdate.addUpdateExpr(visitor.getUpdateExpr());
            return parsedUpdate;
        }
        if (SP.INSERT_DATA_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitInsertData(queryResource);
            ParsedUpdate parsedUpdate = new ParsedUpdate();
            parsedUpdate.addUpdateExpr(visitor.getUpdateExpr());
            return parsedUpdate;
        }
        if (SP.DELETE_DATA_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitDeleteData(queryResource);
            ParsedUpdate parsedUpdate = new ParsedUpdate();
            parsedUpdate.addUpdateExpr(visitor.getUpdateExpr());
            return parsedUpdate;
        }
        if (SP.LOAD_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitLoad(queryResource);
            ParsedUpdate parsedUpdate = new ParsedUpdate();
            parsedUpdate.addUpdateExpr(visitor.getUpdateExpr());
            return parsedUpdate;
        }
        if (SP.CLEAR_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitClear(queryResource);
            ParsedUpdate parsedUpdate = new ParsedUpdate();
            parsedUpdate.addUpdateExpr(visitor.getUpdateExpr());
            return parsedUpdate;
        }
        if (SP.CREATE_CLASS.equals(queryType)) {
            SpinVisitor visitor = new SpinVisitor(store);
            visitor.visitCreate(queryResource);
            ParsedUpdate parsedUpdate = new ParsedUpdate();
            parsedUpdate.addUpdateExpr(visitor.getUpdateExpr());
            return parsedUpdate;
        }
        throw new MalformedSpinException(String.format("Unrecognised command type: %s", queryType));
    }

    public ValueExpr parseExpression(Value expr, TripleSource store) throws RDF4JException {
        SpinVisitor visitor = new SpinVisitor(store);
        return visitor.visitExpression(expr);
    }

    public void reset(IRI ... uris) {
        if (uris != null && uris.length > 0) {
            List<IRI> uriList = Arrays.asList(uris);
            this.templateCache.invalidateAll(uriList);
            this.argumentCache.invalidateAll(uriList);
        } else {
            this.templateCache.invalidateAll();
            this.argumentCache.invalidateAll();
        }
    }

    public static List<IRI> orderArguments(Set<IRI> args) {
        TreeSet<IRI> sortedArgs = new TreeSet<IRI>(new Comparator<IRI>(){

            @Override
            public int compare(IRI uri1, IRI uri2) {
                return uri1.getLocalName().compareTo(uri2.getLocalName());
            }
        });
        sortedArgs.addAll(args);
        int numArgs = sortedArgs.size();
        ArrayList<IRI> orderedArgs = new ArrayList<IRI>(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            IRI arg = SpinParser.toArgProperty(i);
            if (!sortedArgs.remove(arg)) {
                arg = (IRI)sortedArgs.first();
                sortedArgs.remove(arg);
            }
            orderedArgs.add(arg);
        }
        return orderedArgs;
    }

    private static IRI toArgProperty(int i) {
        switch (i) {
            case 1: {
                return SP.ARG1_PROPERTY;
            }
            case 2: {
                return SP.ARG2_PROPERTY;
            }
            case 3: {
                return SP.ARG3_PROPERTY;
            }
            case 4: {
                return SP.ARG4_PROPERTY;
            }
            case 5: {
                return SP.ARG5_PROPERTY;
            }
        }
        return SimpleValueFactory.getInstance().createIRI("http://spinrdf.org/sp#", "arg" + i);
    }

    private static class DataVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        final StringBuilder buf = new StringBuilder(1024);

        DataVisitor() {
            this.appendPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.appendPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            this.appendPrefix("sesame", "http://www.openrdf.org/schema/sesame#");
            this.appendPrefix("owl", "http://www.w3.org/2002/07/owl#");
            this.appendPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
            this.appendPrefix("fn", "http://www.w3.org/2005/xpath-functions#");
            this.buf.append(" ");
        }

        void appendPrefix(String prefix, String namespace) {
            this.buf.append("PREFIX ").append(prefix).append(": <").append(namespace).append("> \n");
        }

        String getData() {
            return this.buf.toString();
        }

        @Override
        public void meet(StatementPattern node) throws RuntimeException {
            if (node.getContextVar() != null) {
                this.buf.append("GRAPH <").append(node.getContextVar().getValue()).append("> { ");
            }
            this.buf.append("<").append(node.getSubjectVar().getValue()).append("> <").append(node.getPredicateVar().getValue()).append("> <").append(node.getObjectVar().getValue()).append("> .");
            if (node.getContextVar() != null) {
                this.buf.append(" } ");
            }
        }
    }

    private class SpinVisitor {
        final TripleSource store;
        TupleExpr tupleRoot;
        TupleExpr tupleNode;
        UpdateExpr updateRoot;
        Var namedGraph;
        Map<String, ProjectionElem> projElems;
        Group group;
        Map<Resource, String> vars = new HashMap<Resource, String>();
        Collection<AggregateOperator> aggregates = new ArrayList<AggregateOperator>();

        SpinVisitor(TripleSource store) {
            this.store = store;
        }

        public TupleExpr getTupleExpr() {
            return this.tupleRoot;
        }

        public UpdateExpr getUpdateExpr() {
            return this.updateRoot;
        }

        public void visitConstruct(Resource construct) throws RDF4JException {
            Value templates = TripleSources.singleValue(construct, SP.TEMPLATES_PROPERTY, this.store);
            if (!(templates instanceof Resource)) {
                throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.TEMPLATES_PROPERTY));
            }
            this.projElems = new LinkedHashMap<String, ProjectionElem>();
            UnaryTupleOperator projection = this.visitTemplates((Resource)templates);
            TupleExpr whereExpr = this.visitWhere(construct);
            projection.setArg(whereExpr);
            this.addSourceExpressions(projection, this.projElems.values());
        }

        public void visitDescribe(Resource describe) throws RDF4JException {
            Value resultNodes = TripleSources.singleValue(describe, SP.RESULT_NODES_PROPERTY, this.store);
            if (!(resultNodes instanceof Resource)) {
                throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.RESULT_NODES_PROPERTY));
            }
            this.projElems = new LinkedHashMap<String, ProjectionElem>();
            Projection projection = this.visitResultNodes((Resource)resultNodes);
            TupleExpr whereExpr = this.visitWhere(describe);
            projection.setArg(whereExpr);
            this.addSourceExpressions(projection, this.projElems.values());
        }

        public void visitSelect(Resource select) throws RDF4JException {
            boolean distinct;
            Value having;
            Value resultVars = TripleSources.singleValue(select, SP.RESULT_VARIABLES_PROPERTY, this.store);
            if (!(resultVars instanceof Resource)) {
                throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.RESULT_VARIABLES_PROPERTY));
            }
            Map<String, ProjectionElem> oldProjElems = this.projElems;
            this.projElems = new LinkedHashMap<String, ProjectionElem>();
            Projection projection = this.visitResultVariables((Resource)resultVars, oldProjElems);
            TupleExpr whereExpr = this.visitWhere(select);
            projection.setArg(whereExpr);
            Value groupBy = TripleSources.singleValue(select, SP.GROUP_BY_PROPERTY, this.store);
            if (groupBy instanceof Resource) {
                this.visitGroupBy((Resource)groupBy);
            }
            if (this.group != null) {
                this.group.setArg(projection.getArg());
                projection.setArg(this.group);
            }
            if ((having = TripleSources.singleValue(select, SP.HAVING_PROPERTY, this.store)) instanceof Resource) {
                TupleExpr havingExpr = this.visitHaving((Resource)having);
                projection.setArg(havingExpr);
            }
            this.addSourceExpressions(projection, this.projElems.values());
            this.projElems = oldProjElems;
            Value orderby = TripleSources.singleValue(select, SP.ORDER_BY_PROPERTY, this.store);
            if (orderby instanceof Resource) {
                Order order = this.visitOrderBy((Resource)orderby);
                order.setArg(projection.getArg());
                projection.setArg(order);
            }
            if (distinct = TripleSources.booleanValue(select, SP.DISTINCT_PROPERTY, this.store)) {
                this.tupleRoot = new Distinct(this.tupleRoot);
            }
            long offset = -1L;
            Value offsetValue = TripleSources.singleValue(select, SP.OFFSET_PROPERTY, this.store);
            if (offsetValue instanceof Literal) {
                offset = ((Literal)offsetValue).longValue();
            }
            long limit = -1L;
            Value limitValue = TripleSources.singleValue(select, SP.LIMIT_PROPERTY, this.store);
            if (limitValue instanceof Literal) {
                limit = ((Literal)limitValue).longValue();
            }
            if (offset > 0L || limit >= 0L) {
                Slice slice = new Slice(this.tupleRoot);
                if (offset > 0L) {
                    slice.setOffset(offset);
                }
                if (limit >= 0L) {
                    slice.setLimit(limit);
                }
                this.tupleRoot = slice;
            }
        }

        public void visitAsk(Resource ask) throws RDF4JException {
            TupleExpr whereExpr = this.visitWhere(ask);
            this.tupleRoot = new Slice(whereExpr, 0L, 1L);
        }

        private void addSourceExpressions(UnaryTupleOperator op, Collection<ProjectionElem> elems) {
            Extension ext = null;
            for (ProjectionElem projElem : elems) {
                ExtensionElem extElem = projElem.getSourceExpression();
                if (extElem == null) continue;
                if (ext == null) {
                    ext = new Extension(op.getArg());
                    op.setArg(ext);
                }
                ext.addElement(extElem);
            }
        }

        private UnaryTupleOperator visitTemplates(Resource templates) throws RDF4JException {
            UnaryTupleOperator expr;
            UnaryTupleOperator proj;
            ArrayList<ProjectionElemList> projElemLists = new ArrayList<ProjectionElemList>();
            Iteration<? extends Resource, QueryEvaluationException> iter = TripleSources.listResources(templates, this.store);
            while (iter.hasNext()) {
                Resource r = iter.next();
                ProjectionElemList projElems = this.visitTemplate(r);
                projElemLists.add(projElems);
            }
            if (projElemLists.size() > 1) {
                proj = new MultiProjection();
                ((MultiProjection)proj).setProjections(projElemLists);
                expr = proj;
            } else {
                proj = new Projection();
                ((Projection)proj).setProjectionElemList((ProjectionElemList)projElemLists.get(0));
                expr = proj;
            }
            Reduced reduced = new Reduced();
            reduced.setArg(expr);
            this.tupleRoot = reduced;
            return expr;
        }

        private ProjectionElemList visitTemplate(Resource r) throws RDF4JException {
            ProjectionElemList projElems = new ProjectionElemList();
            Value subj = TripleSources.singleValue(r, SP.SUBJECT_PROPERTY, this.store);
            projElems.addElement(this.createProjectionElem(subj, "subject", null));
            Value pred = TripleSources.singleValue(r, SP.PREDICATE_PROPERTY, this.store);
            projElems.addElement(this.createProjectionElem(pred, "predicate", null));
            Value obj = TripleSources.singleValue(r, SP.OBJECT_PROPERTY, this.store);
            projElems.addElement(this.createProjectionElem(obj, "object", null));
            return projElems;
        }

        private Projection visitResultNodes(Resource resultNodes) throws RDF4JException {
            ProjectionElemList projElemList = new ProjectionElemList();
            Iteration<? extends Resource, QueryEvaluationException> iter = TripleSources.listResources(resultNodes, this.store);
            while (iter.hasNext()) {
                Resource r = iter.next();
                ProjectionElem projElem = this.visitResultNode(r);
                projElemList.addElement(projElem);
            }
            Projection proj = new Projection();
            proj.setProjectionElemList(projElemList);
            this.tupleRoot = new DescribeOperator(proj);
            return proj;
        }

        private ProjectionElem visitResultNode(Resource r) throws RDF4JException {
            return this.createProjectionElem(r, null, null);
        }

        private Projection visitResultVariables(Resource resultVars, Map<String, ProjectionElem> previousProjElems) throws RDF4JException {
            ProjectionElemList projElemList = new ProjectionElemList();
            Iteration<? extends Resource, QueryEvaluationException> iter = TripleSources.listResources(resultVars, this.store);
            while (iter.hasNext()) {
                Resource r = iter.next();
                ProjectionElem projElem = this.visitResultVariable(r, previousProjElems);
                projElemList.addElement(projElem);
            }
            Projection proj = new Projection();
            proj.setProjectionElemList(projElemList);
            this.tupleRoot = proj;
            return proj;
        }

        private ProjectionElem visitResultVariable(Resource r, Map<String, ProjectionElem> previousProjElems) throws RDF4JException {
            return this.createProjectionElem(r, null, previousProjElems);
        }

        private void visitGroupBy(Resource groupby) throws RDF4JException {
            if (this.group == null) {
                this.group = new Group();
            }
            Iteration<? extends Resource, QueryEvaluationException> iter = TripleSources.listResources(groupby, this.store);
            while (iter.hasNext()) {
                Resource r = iter.next();
                ValueExpr groupByExpr = this.visitExpression(r);
                if (!(groupByExpr instanceof Var)) {
                    throw new UnsupportedOperationException("TODO!");
                }
                this.group.addGroupBindingName(((Var)groupByExpr).getName());
            }
        }

        private TupleExpr visitHaving(Resource having) throws RDF4JException {
            UnaryTupleOperator op = (UnaryTupleOperator)this.group.getParentNode();
            op.setArg(new Extension(this.group));
            Iteration<? extends Resource, QueryEvaluationException> iter = TripleSources.listResources(having, this.store);
            while (iter.hasNext()) {
                Resource r = iter.next();
                ValueExpr havingExpr = this.visitExpression(r);
                Filter filter = new Filter(op.getArg(), havingExpr);
                op.setArg(filter);
                op = filter;
            }
            return op;
        }

        private Order visitOrderBy(Resource orderby) throws RDF4JException {
            Order order = new Order();
            Iteration<? extends Resource, QueryEvaluationException> iter = TripleSources.listResources(orderby, this.store);
            while (iter.hasNext()) {
                Resource r = iter.next();
                OrderElem orderElem = this.visitOrderByCondition(r);
                order.addElement(orderElem);
            }
            return order;
        }

        private OrderElem visitOrderByCondition(Resource r) throws RDF4JException {
            Value expr = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
            ValueExpr valueExpr = this.visitExpression(expr);
            Statement descStmt = TripleSources.single(r, RDF.TYPE, SP.DESC_CLASS, this.store);
            boolean asc = descStmt == null;
            return new OrderElem(valueExpr, asc);
        }

        private ProjectionElem createProjectionElem(Value v, String projName, Map<String, ProjectionElem> previousProjElems) throws RDF4JException {
            ValueExpr valueExpr;
            String varName;
            Collection<AggregateOperator> oldAggregates = this.aggregates;
            this.aggregates = Collections.emptyList();
            if (v instanceof Literal) {
                if (projName == null) {
                    throw new MalformedSpinException(String.format("Expected a projection var: %s", v));
                }
                varName = TupleExprs.getConstVarName(v);
                valueExpr = new ValueConstant(v);
            } else {
                varName = this.getVarName((Resource)v);
                if (varName != null) {
                    Value expr = TripleSources.singleValue((Resource)v, SP.EXPRESSION_PROPERTY, this.store);
                    if (expr != null) {
                        this.aggregates = new ArrayList<AggregateOperator>();
                        valueExpr = this.visitExpression(expr);
                    } else {
                        valueExpr = new Var(varName);
                    }
                    if (projName == null) {
                        projName = varName;
                    }
                } else {
                    if (projName == null) {
                        throw new MalformedSpinException(String.format("Expected a projection var: %s", v));
                    }
                    varName = TupleExprs.getConstVarName(v);
                    valueExpr = new ValueConstant(v);
                }
            }
            ProjectionElem projElem = new ProjectionElem(varName, projName);
            projElem.setSourceExpression(new ExtensionElem(valueExpr, varName));
            if (!this.aggregates.isEmpty()) {
                projElem.setAggregateOperatorInExpression(true);
                if (this.group == null) {
                    this.group = new Group();
                }
                for (AggregateOperator op : this.aggregates) {
                    this.group.addGroupElement(new GroupElem(projName, op));
                }
            }
            this.aggregates = oldAggregates;
            if (this.projElems != null) {
                this.projElems.put(varName, projElem);
            }
            if (previousProjElems != null) {
                previousProjElems.remove(projName);
            }
            return projElem;
        }

        public void visitModify(Resource query) throws RDF4JException {
            TupleExpr insertExpr;
            TupleExpr deleteExpr;
            Value with = TripleSources.singleValue(query, SP.WITH_PROPERTY, this.store);
            if (with != null) {
                this.namedGraph = TupleExprs.createConstVar(with);
            }
            SingletonSet stub = new SingletonSet();
            this.tupleRoot = new QueryRoot(stub);
            this.tupleNode = stub;
            Value delete = TripleSources.singleValue(query, SP.DELETE_PATTERN_PROPERTY, this.store);
            if (delete != null) {
                this.visitDelete((Resource)delete);
                deleteExpr = this.tupleNode;
                deleteExpr.setParentNode(null);
            } else {
                deleteExpr = null;
            }
            this.tupleRoot = new QueryRoot(stub);
            this.tupleNode = stub;
            Value insert = TripleSources.singleValue(query, SP.INSERT_PATTERN_PROPERTY, this.store);
            if (insert != null) {
                this.visitInsert((Resource)insert);
                insertExpr = this.tupleNode;
                insertExpr.setParentNode(null);
            } else {
                insertExpr = null;
            }
            Value where = TripleSources.singleValue(query, SP.WHERE_PROPERTY, this.store);
            TupleExpr whereExpr = where != null ? this.visitGroupGraphPattern((Resource)where) : null;
            this.updateRoot = new Modify(deleteExpr, insertExpr, whereExpr);
        }

        public void visitDeleteWhere(Resource query) throws RDF4JException {
            TupleExpr whereExpr = this.visitWhere(query);
            this.updateRoot = new Modify(whereExpr, null, whereExpr.clone());
        }

        public void visitInsertData(Resource query) throws RDF4JException {
            SingletonSet stub = new SingletonSet();
            this.tupleRoot = new QueryRoot(stub);
            this.tupleNode = stub;
            Value insert = TripleSources.singleValue(query, SP.DATA_PROPERTY, this.store);
            if (!(insert instanceof Resource)) {
                throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.DATA_PROPERTY));
            }
            this.visitInsert((Resource)insert);
            TupleExpr insertExpr = this.tupleNode;
            insertExpr.setParentNode(null);
            DataVisitor visitor = new DataVisitor();
            insertExpr.visit(visitor);
            this.updateRoot = new InsertData(visitor.getData());
        }

        public void visitDeleteData(Resource query) throws RDF4JException {
            SingletonSet stub = new SingletonSet();
            this.tupleRoot = new QueryRoot(stub);
            this.tupleNode = stub;
            Value delete = TripleSources.singleValue(query, SP.DATA_PROPERTY, this.store);
            if (!(delete instanceof Resource)) {
                throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.DATA_PROPERTY));
            }
            this.visitDelete((Resource)delete);
            TupleExpr deleteExpr = this.tupleNode;
            deleteExpr.setParentNode(null);
            DataVisitor visitor = new DataVisitor();
            deleteExpr.visit(visitor);
            this.updateRoot = new DeleteData(visitor.getData());
        }

        public void visitLoad(Resource query) throws RDF4JException {
            Value document = TripleSources.singleValue(query, SP.DOCUMENT_PROPERTY, this.store);
            Value into = TripleSources.singleValue(query, SP.INTO_PROPERTY, this.store);
            Load load = new Load(new ValueConstant(document));
            load.setGraph(new ValueConstant(into));
            boolean isSilent = TripleSources.booleanValue(query, SP.SILENT_PROPERTY, this.store);
            load.setSilent(isSilent);
            this.updateRoot = load;
        }

        public void visitClear(Resource query) throws RDF4JException {
            Value graph = TripleSources.singleValue(query, SP.GRAPH_IRI_PROPERTY, this.store);
            Clear clear = new Clear(new ValueConstant(graph));
            boolean isSilent = TripleSources.booleanValue(query, SP.SILENT_PROPERTY, this.store);
            clear.setSilent(isSilent);
            this.updateRoot = clear;
        }

        public void visitCreate(Resource query) throws RDF4JException {
            Value graph = TripleSources.singleValue(query, SP.GRAPH_IRI_PROPERTY, this.store);
            Create create = new Create(new ValueConstant(graph));
            boolean isSilent = TripleSources.booleanValue(query, SP.SILENT_PROPERTY, this.store);
            create.setSilent(isSilent);
            this.updateRoot = create;
        }

        public TupleExpr visitWhere(Resource query) throws RDF4JException {
            Value where = TripleSources.singleValue(query, SP.WHERE_PROPERTY, this.store);
            if (!(where instanceof Resource)) {
                throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.WHERE_PROPERTY));
            }
            return this.visitGroupGraphPattern((Resource)where);
        }

        public TupleExpr visitGroupGraphPattern(Resource group) throws RDF4JException {
            Map.Entry entry2;
            this.tupleNode = new SingletonSet();
            QueryRoot groupRoot = new QueryRoot(this.tupleNode);
            LinkedHashMap<Resource, Set<? extends IRI>> patternTypes = new LinkedHashMap<Resource, Set<? extends IRI>>();
            Iteration<? extends Resource, QueryEvaluationException> groupIter = TripleSources.listResources(group, this.store);
            while (groupIter.hasNext()) {
                Resource r = groupIter.next();
                patternTypes.put(r, Iterations.asSet(TripleSources.getObjectURIs(r, RDF.TYPE, this.store)));
            }
            TupleExpr currentNode = this.tupleNode;
            SingletonSet nextNode = new SingletonSet();
            this.tupleNode = nextNode;
            Iterator iter = patternTypes.entrySet().iterator();
            while (iter.hasNext()) {
                entry2 = iter.next();
                if (!((Set)entry2.getValue()).contains(SP.FILTER_CLASS)) continue;
                this.visitFilter((Resource)entry2.getKey());
                iter.remove();
            }
            currentNode.replaceWith(this.tupleNode);
            currentNode = this.tupleNode = nextNode;
            nextNode = new SingletonSet();
            this.tupleNode = nextNode;
            iter = patternTypes.entrySet().iterator();
            while (iter.hasNext()) {
                entry2 = iter.next();
                if (!((Set)entry2.getValue()).contains(SP.BIND_CLASS)) continue;
                this.visitBind((Resource)entry2.getKey());
                iter.remove();
            }
            currentNode.replaceWith(this.tupleNode);
            this.tupleNode = nextNode;
            for (Map.Entry entry2 : patternTypes.entrySet()) {
                this.visitPattern((Resource)entry2.getKey(), (Set)entry2.getValue(), groupRoot.getArg());
            }
            TupleExpr groupExpr = groupRoot.getArg();
            groupExpr.setParentNode(null);
            return groupExpr;
        }

        private void visitInsert(Resource insert) throws RDF4JException {
            Iteration<? extends Resource, QueryEvaluationException> groupIter = TripleSources.listResources(insert, this.store);
            while (groupIter.hasNext()) {
                Resource r;
                Value type = TripleSources.singleValue(r = groupIter.next(), RDF.TYPE, this.store);
                this.visitPattern(r, type != null ? Collections.singleton((IRI)type) : Collections.emptySet(), null);
            }
        }

        private void visitDelete(Resource delete) throws RDF4JException {
            Iteration<? extends Resource, QueryEvaluationException> groupIter = TripleSources.listResources(delete, this.store);
            while (groupIter.hasNext()) {
                Resource r;
                Value type = TripleSources.singleValue(r = groupIter.next(), RDF.TYPE, this.store);
                this.visitPattern(r, type != null ? Collections.singleton((IRI)type) : Collections.emptySet(), null);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void visitPattern(Resource r, Set<IRI> types, TupleExpr currentGroupExpr) throws RDF4JException {
            Value elements;
            Value subj;
            TupleExpr currentNode = this.tupleNode;
            Value pred = TripleSources.singleValue(r, SP.PREDICATE_PROPERTY, this.store);
            if (pred != null) {
                subj = TripleSources.singleValue(r, SP.SUBJECT_PROPERTY, this.store);
                Value obj = TripleSources.singleValue(r, SP.OBJECT_PROPERTY, this.store);
                StatementPattern.Scope stmtScope = this.namedGraph != null ? StatementPattern.Scope.NAMED_CONTEXTS : StatementPattern.Scope.DEFAULT_CONTEXTS;
                this.tupleNode = new StatementPattern(stmtScope, this.getVar(subj), this.getVar(pred), this.getVar(obj), this.namedGraph);
            } else if (types.contains(SP.NAMED_GRAPH_CLASS)) {
                Var oldGraph = this.namedGraph;
                Value graphValue = TripleSources.singleValue(r, SP.GRAPH_NAME_NODE_PROPERTY, this.store);
                this.namedGraph = this.getVar(graphValue);
                Value elements2 = TripleSources.singleValue(r, SP.ELEMENTS_PROPERTY, this.store);
                if (!(elements2 instanceof Resource)) {
                    throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.ELEMENTS_PROPERTY));
                }
                this.tupleNode = this.visitGroupGraphPattern((Resource)elements2);
                this.namedGraph = oldGraph;
            } else if (types.contains(SP.UNION_CLASS)) {
                elements = TripleSources.singleValue(r, SP.ELEMENTS_PROPERTY, this.store);
                if (!(elements instanceof Resource)) {
                    throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.ELEMENTS_PROPERTY));
                }
                Iteration<? extends Resource, QueryEvaluationException> iter = TripleSources.listResources((Resource)elements, this.store);
                TupleExpr prev = null;
                while (iter.hasNext()) {
                    Resource entry = iter.next();
                    TupleExpr groupExpr = this.visitGroupGraphPattern(entry);
                    if (prev != null) {
                        this.tupleNode = groupExpr = new Union(prev, groupExpr);
                    }
                    prev = groupExpr;
                }
            } else if (types.contains(SP.OPTIONAL_CLASS)) {
                elements = TripleSources.singleValue(r, SP.ELEMENTS_PROPERTY, this.store);
                if (!(elements instanceof Resource)) {
                    throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.ELEMENTS_PROPERTY));
                }
                TupleExpr groupExpr = this.visitGroupGraphPattern((Resource)elements);
                LeftJoin leftJoin = new LeftJoin();
                currentGroupExpr.replaceWith(leftJoin);
                leftJoin.setLeftArg(currentGroupExpr);
                leftJoin.setRightArg(groupExpr);
                this.tupleNode = leftJoin;
                currentNode = null;
            } else if (types.contains(SP.MINUS_CLASS)) {
                elements = TripleSources.singleValue(r, SP.ELEMENTS_PROPERTY, this.store);
                if (!(elements instanceof Resource)) {
                    throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.ELEMENTS_PROPERTY));
                }
                TupleExpr groupExpr = this.visitGroupGraphPattern((Resource)elements);
                Difference difference = new Difference();
                currentGroupExpr.replaceWith(difference);
                difference.setLeftArg(currentGroupExpr);
                difference.setRightArg(groupExpr);
                this.tupleNode = difference;
                currentNode = null;
            } else if (types.contains(SP.SUB_QUERY_CLASS)) {
                Value q = TripleSources.singleValue(r, SP.QUERY_PROPERTY, this.store);
                TupleExpr oldRoot = this.tupleRoot;
                this.visitSelect((Resource)q);
                this.tupleNode = this.tupleRoot;
                this.tupleRoot = oldRoot;
            } else if (types.contains(SP.VALUES_CLASS)) {
                BindingSetAssignment bsa = new BindingSetAssignment();
                LinkedHashSet<String> varNames = new LinkedHashSet<String>();
                Value varNameList = TripleSources.singleValue(r, SP.VAR_NAMES_PROPERTY, this.store);
                Iteration<? extends Value, QueryEvaluationException> varNameIter = TripleSources.list((Resource)varNameList, this.store);
                while (varNameIter.hasNext()) {
                    Value v = varNameIter.next();
                    if (!(v instanceof Literal)) continue;
                    varNames.add(((Literal)v).getLabel());
                }
                bsa.setBindingNames(varNames);
                ArrayList<BindingSet> bindingSets = new ArrayList<BindingSet>();
                Value bindingsList = TripleSources.singleValue(r, SP.BINDINGS_PROPERTY, this.store);
                Iteration<? extends Value, QueryEvaluationException> bindingsIter = TripleSources.list((Resource)bindingsList, this.store);
                while (bindingsIter.hasNext()) {
                    Value valueList = bindingsIter.next();
                    QueryBindingSet bs = new QueryBindingSet();
                    Iterator nameIter = varNames.iterator();
                    Iteration<? extends Value, QueryEvaluationException> valueIter = TripleSources.list((Resource)valueList, this.store);
                    while (nameIter.hasNext() && valueIter.hasNext()) {
                        String name = (String)nameIter.next();
                        Value value = valueIter.next();
                        bs.addBinding(name, value);
                    }
                    bindingSets.add(bs);
                }
                bsa.setBindingSets(bindingSets);
                this.tupleNode = bsa;
            } else if (types.contains(RDF.LIST) || TripleSources.singleValue(r, RDF.FIRST, this.store) != null) {
                this.tupleNode = this.visitGroupGraphPattern(r);
            } else if (types.contains(SP.TRIPLE_PATH_CLASS)) {
                subj = TripleSources.singleValue(r, SP.SUBJECT_PROPERTY, this.store);
                Value obj = TripleSources.singleValue(r, SP.OBJECT_PROPERTY, this.store);
                Resource path = (Resource)TripleSources.singleValue(r, SP.PATH_PROPERTY, this.store);
                Set<? extends IRI> pathTypes = Iterations.asSet(TripleSources.getObjectURIs(path, RDF.TYPE, this.store));
                if (!pathTypes.contains(SP.MOD_PATH_CLASS)) throw new UnsupportedOperationException(types.toString());
                Resource subPath = (Resource)TripleSources.singleValue(path, SP.SUB_PATH_PROPERTY, this.store);
                Literal minPath = (Literal)TripleSources.singleValue(path, SP.MOD_MIN_PROPERTY, this.store);
                Literal maxPath = (Literal)TripleSources.singleValue(path, SP.MOD_MAX_PROPERTY, this.store);
                if (maxPath == null || maxPath.intValue() != -2) {
                    throw new UnsupportedOperationException("Unsupported mod path");
                }
                Var subjVar = this.getVar(subj);
                Var objVar = this.getVar(obj);
                this.tupleNode = new ArbitraryLengthPath(subjVar, new StatementPattern(subjVar, this.getVar(subPath), objVar), objVar, minPath.longValue());
            } else {
                String exprString;
                if (!types.contains(SP.SERVICE_CLASS)) throw new UnsupportedOperationException(types.toString());
                Value serviceUri = TripleSources.singleValue(r, SP.SERVICE_URI_PROPERTY, this.store);
                Value elements3 = TripleSources.singleValue(r, SP.ELEMENTS_PROPERTY, this.store);
                if (!(elements3 instanceof Resource)) {
                    throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.ELEMENTS_PROPERTY));
                }
                TupleExpr groupExpr = this.visitGroupGraphPattern((Resource)elements3);
                boolean isSilent = TripleSources.booleanValue(r, SP.SILENT_PROPERTY, this.store);
                try {
                    exprString = new SPARQLQueryRenderer().render(new ParsedTupleQuery(groupExpr));
                    exprString = exprString.substring(exprString.indexOf(123) + 1, exprString.lastIndexOf(125));
                }
                catch (Exception e) {
                    throw new QueryEvaluationException(e);
                }
                HashMap<String, String> prefixDecls = new HashMap<String, String>(8);
                prefixDecls.put("sp", "http://spinrdf.org/sp#");
                prefixDecls.put("spin", "http://spinrdf.org/spin#");
                prefixDecls.put("spl", "http://spinrdf.org/spl#");
                Service service = new Service(this.getVar(serviceUri), this.tupleNode, exprString, prefixDecls, null, isSilent);
                this.tupleNode = service;
            }
            if (currentNode instanceof SingletonSet) {
                currentNode.replaceWith(this.tupleNode);
                return;
            } else {
                if (currentNode == null) return;
                Join join = new Join();
                currentNode.replaceWith(join);
                join.setLeftArg(currentNode);
                join.setRightArg(this.tupleNode);
                this.tupleNode = join;
            }
        }

        private void visitFilter(Resource r) throws RDF4JException {
            Value expr = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
            ValueExpr valueExpr = this.visitExpression(expr);
            this.tupleNode = new Filter(this.tupleNode, valueExpr);
        }

        private void visitBind(Resource r) throws RDF4JException {
            Value expr = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
            ValueExpr valueExpr = this.visitExpression(expr);
            Value varValue = TripleSources.singleValue(r, SP.VARIABLE_PROPERTY, this.store);
            if (!(varValue instanceof Resource)) {
                throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.VARIABLE_PROPERTY));
            }
            String varName = this.getVarName((Resource)varValue);
            this.tupleNode = new Extension(this.tupleNode, new ExtensionElem(valueExpr, varName));
        }

        private ValueExpr visitExpression(Value v) throws RDF4JException {
            ValueExpr expr;
            if (v instanceof Literal) {
                expr = new ValueConstant(v);
            } else {
                Resource r = (Resource)v;
                String varName = this.getVarName(r);
                if (varName != null) {
                    expr = this.createVar(varName);
                } else {
                    Set<IRI> exprTypes = Iterations.asSet(TripleSources.getObjectURIs(r, RDF.TYPE, this.store));
                    exprTypes.remove(RDF.PROPERTY);
                    exprTypes.remove(RDFS.RESOURCE);
                    exprTypes.remove(RDFS.CLASS);
                    if (exprTypes.size() > 1) {
                        if (exprTypes.remove(SPIN.FUNCTIONS_CLASS)) {
                            exprTypes.remove(SPIN.MODULES_CLASS);
                            if (exprTypes.size() > 1) {
                                Iterator<IRI> iter = exprTypes.iterator();
                                while (iter.hasNext()) {
                                    IRI f = iter.next();
                                    Value abstractValue = TripleSources.singleValue(f, SPIN.ABSTRACT_PROPERTY, this.store);
                                    if (!BooleanLiteral.TRUE.equals(abstractValue)) continue;
                                    iter.remove();
                                }
                            }
                            if (exprTypes.isEmpty()) {
                                throw new MalformedSpinException(String.format("Function missing RDF type: %s", r));
                            }
                        } else if (exprTypes.remove(SP.AGGREGATION_CLASS)) {
                            exprTypes.remove(SP.SYSTEM_CLASS);
                            if (exprTypes.isEmpty()) {
                                throw new MalformedSpinException(String.format("Aggregation missing RDF type: %s", r));
                            }
                        } else {
                            exprTypes = Collections.emptySet();
                        }
                    }
                    expr = null;
                    if (exprTypes.size() == 1) {
                        IRI func = exprTypes.iterator().next();
                        expr = this.toValueExpr(r, func);
                    }
                    if (expr == null) {
                        expr = new ValueConstant(v);
                    }
                }
            }
            return expr;
        }

        private ValueExpr toValueExpr(Resource r, IRI func) throws RDF4JException {
            AbstractQueryModelNode expr;
            Compare.CompareOp compareOp = this.toCompareOp(func);
            if (compareOp != null) {
                List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY, SP.ARG2_PROPERTY);
                if (args.size() != 2) {
                    throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                }
                expr = new Compare(args.get(0), args.get(1), compareOp);
            } else {
                MathExpr.MathOp mathOp = this.toMathOp(func);
                if (mathOp != null) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY, SP.ARG2_PROPERTY);
                    if (args.size() != 2) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new MathExpr(args.get(0), args.get(1), mathOp);
                } else if (SP.AND.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY, SP.ARG2_PROPERTY);
                    if (args.size() != 2) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new And(args.get(0), args.get(1));
                } else if (SP.OR.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY, SP.ARG2_PROPERTY);
                    if (args.size() != 2) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new Or(args.get(0), args.get(1));
                } else if (SP.NOT.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new Not(args.get(0));
                } else if (SP.COUNT_CLASS.equals(func)) {
                    Value arg = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
                    boolean distinct = TripleSources.booleanValue(r, SP.DISTINCT_PROPERTY, this.store);
                    Count count = new Count(this.visitExpression(arg), distinct);
                    this.aggregates.add(count);
                    expr = count;
                } else if (SP.MAX_CLASS.equals(func)) {
                    Value arg = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
                    boolean distinct = TripleSources.booleanValue(r, SP.DISTINCT_PROPERTY, this.store);
                    Max max = new Max(this.visitExpression(arg), distinct);
                    this.aggregates.add(max);
                    expr = max;
                } else if (SP.MIN_CLASS.equals(func)) {
                    Value arg = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
                    boolean distinct = TripleSources.booleanValue(r, SP.DISTINCT_PROPERTY, this.store);
                    Min min = new Min(this.visitExpression(arg), distinct);
                    this.aggregates.add(min);
                    expr = min;
                } else if (SP.SUM_CLASS.equals(func)) {
                    Value arg = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
                    boolean distinct = TripleSources.booleanValue(r, SP.DISTINCT_PROPERTY, this.store);
                    Sum sum = new Sum(this.visitExpression(arg), distinct);
                    this.aggregates.add(sum);
                    expr = sum;
                } else if (SP.AVG_CLASS.equals(func)) {
                    Value arg = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
                    boolean distinct = TripleSources.booleanValue(r, SP.DISTINCT_PROPERTY, this.store);
                    Avg avg = new Avg(this.visitExpression(arg), distinct);
                    this.aggregates.add(avg);
                    expr = avg;
                } else if (SP.GROUP_CONCAT_CLASS.equals(func)) {
                    Value arg = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
                    boolean distinct = TripleSources.booleanValue(r, SP.DISTINCT_PROPERTY, this.store);
                    GroupConcat groupConcat = new GroupConcat(this.visitExpression(arg), distinct);
                    this.aggregates.add(groupConcat);
                    expr = groupConcat;
                } else if (SP.SAMPLE_CLASS.equals(func)) {
                    Value arg = TripleSources.singleValue(r, SP.EXPRESSION_PROPERTY, this.store);
                    boolean distinct = TripleSources.booleanValue(r, SP.DISTINCT_PROPERTY, this.store);
                    Sample sample = new Sample(this.visitExpression(arg), distinct);
                    this.aggregates.add(sample);
                    expr = sample;
                } else if (SP.EXISTS.equals(func)) {
                    Value elements = TripleSources.singleValue(r, SP.ELEMENTS_PROPERTY, this.store);
                    if (!(elements instanceof Resource)) {
                        throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.ELEMENTS_PROPERTY));
                    }
                    TupleExpr currentNode = this.tupleNode;
                    TupleExpr groupExpr = this.visitGroupGraphPattern((Resource)elements);
                    expr = new Exists(groupExpr);
                    this.tupleNode = currentNode;
                } else if (SP.NOT_EXISTS.equals(func)) {
                    Value elements = TripleSources.singleValue(r, SP.ELEMENTS_PROPERTY, this.store);
                    if (!(elements instanceof Resource)) {
                        throw new MalformedSpinException(String.format("Value of %s is not a resource", SP.ELEMENTS_PROPERTY));
                    }
                    TupleExpr currentNode = this.tupleNode;
                    TupleExpr groupExpr = this.visitGroupGraphPattern((Resource)elements);
                    expr = new Not(new Exists(groupExpr));
                    this.tupleNode = currentNode;
                } else if (SP.BOUND.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new Bound((Var)args.get(0));
                } else if (SP.IF.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY, SP.ARG2_PROPERTY, SP.ARG3_PROPERTY);
                    if (args.size() != 3) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new If(args.get(0), args.get(1), args.get(2));
                } else if (SP.COALESCE.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, new IRI[0]);
                    expr = new Coalesce(args);
                } else if (SP.IS_IRI.equals(func) || SP.IS_URI.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new IsURI(args.get(0));
                } else if (SP.IS_BLANK.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new IsBNode(args.get(0));
                } else if (SP.IS_LITERAL.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new IsLiteral(args.get(0));
                } else if (SP.IS_NUMERIC.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new IsNumeric(args.get(0));
                } else if (SP.STR.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new Str(args.get(0));
                } else if (SP.LANG.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new Lang(args.get(0));
                } else if (SP.DATATYPE.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new Datatype(args.get(0));
                } else if (SP.IRI.equals(func) || SP.URI.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new IRIFunction(args.get(0));
                } else if (SP.BNODE.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    ValueExpr arg = args.size() == 1 ? args.get(0) : null;
                    expr = new BNodeGenerator(arg);
                } else if (SP.REGEX.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY, SP.ARG2_PROPERTY, SP.ARG3_PROPERTY);
                    if (args.size() < 2) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    ValueExpr flagsArg = args.size() == 3 ? args.get(2) : null;
                    expr = new Regex(args.get(0), args.get(1), flagsArg);
                } else if (AFN.LOCALNAME.equals(func)) {
                    List<ValueExpr> args = this.getArgs(r, func, SP.ARG1_PROPERTY);
                    if (args.size() != 1) {
                        throw new MalformedSpinException(String.format("Invalid number of arguments for function: %s", func));
                    }
                    expr = new LocalName(args.get(0));
                } else {
                    Statement funcTypeStmt;
                    String funcName = (String)SpinParser.this.wellKnownFunctions.apply((Object)func);
                    if (funcName == null && (funcTypeStmt = TripleSources.single(func, RDF.TYPE, SPIN.FUNCTION_CLASS, this.store)) != null) {
                        funcName = func.stringValue();
                    }
                    if (funcName == null && !SpinParser.this.strictFunctionChecking) {
                        funcName = func.stringValue();
                    }
                    if (funcName != null) {
                        List<ValueExpr> args = this.getArgs(r, func, null);
                        expr = new FunctionCall(funcName, args);
                    } else {
                        expr = null;
                    }
                }
            }
            return expr;
        }

        private Compare.CompareOp toCompareOp(IRI func) {
            if (SP.EQ.equals(func)) {
                return Compare.CompareOp.EQ;
            }
            if (SP.NE.equals(func)) {
                return Compare.CompareOp.NE;
            }
            if (SP.LT.equals(func)) {
                return Compare.CompareOp.LT;
            }
            if (SP.LE.equals(func)) {
                return Compare.CompareOp.LE;
            }
            if (SP.GE.equals(func)) {
                return Compare.CompareOp.GE;
            }
            if (SP.GT.equals(func)) {
                return Compare.CompareOp.GT;
            }
            return null;
        }

        private MathExpr.MathOp toMathOp(IRI func) {
            if (SP.ADD.equals(func)) {
                return MathExpr.MathOp.PLUS;
            }
            if (SP.SUB.equals(func)) {
                return MathExpr.MathOp.MINUS;
            }
            if (SP.MUL.equals(func)) {
                return MathExpr.MathOp.MULTIPLY;
            }
            if (SP.DIVIDE.equals(func)) {
                return MathExpr.MathOp.DIVIDE;
            }
            return null;
        }

        private List<ValueExpr> getArgs(Resource r, IRI func, IRI ... knownArgs) throws RDF4JException {
            ValueExpr argValue;
            Collection<IRI> args = knownArgs != null ? Arrays.asList(knownArgs) : SpinParser.this.parseArguments(func, this.store).keySet();
            HashMap<IRI, ValueExpr> argBindings = new HashMap<IRI, ValueExpr>();
            if (!args.isEmpty()) {
                for (IRI arg : args) {
                    Value value = TripleSources.singleValue(r, arg, this.store);
                    if (value == null) continue;
                    argValue = this.visitExpression(value);
                    argBindings.put(arg, argValue);
                }
            } else {
                Value value;
                int i = 1;
                do {
                    IRI arg;
                    if ((value = TripleSources.singleValue(r, arg = SpinParser.toArgProperty(i++), this.store)) == null) continue;
                    argValue = this.visitExpression(value);
                    argBindings.put(arg, argValue);
                } while (value != null);
            }
            ArrayList<ValueExpr> argValues = new ArrayList<ValueExpr>(argBindings.size());
            List<IRI> orderedArgs = SpinParser.orderArguments(argBindings.keySet());
            for (IRI IRI2 : orderedArgs) {
                ValueExpr argExpr = (ValueExpr)argBindings.get(IRI2);
                argValues.add(argExpr);
            }
            return argValues;
        }

        private String getVarName(Resource r) throws RDF4JException {
            String varName = this.vars.get(r);
            if (varName == null && r instanceof IRI && (varName = (String)SpinParser.this.wellKnownVars.apply((Object)((IRI)r))) != null) {
                this.vars.put(r, varName);
            }
            if (varName == null) {
                Value nameValue = TripleSources.singleValue(r, SP.VAR_NAME_PROPERTY, this.store);
                if (nameValue instanceof Literal) {
                    varName = ((Literal)nameValue).getLabel();
                    if (varName != null) {
                        this.vars.put(r, varName);
                    }
                } else if (nameValue != null) {
                    throw new MalformedSpinException(String.format("Value of %s is not a literal", SP.VAR_NAME_PROPERTY));
                }
            }
            return varName;
        }

        private Var getVar(Value v) throws RDF4JException {
            String varName;
            Var var = null;
            if (v instanceof Resource && (varName = this.getVarName((Resource)v)) != null) {
                var = this.createVar(varName);
            }
            if (var == null) {
                var = TupleExprs.createConstVar(v);
            }
            return var;
        }

        private Var createVar(String varName) {
            ExtensionElem extElem;
            ProjectionElem projElem;
            if (this.projElems != null && (projElem = this.projElems.get(varName)) != null && (extElem = projElem.getSourceExpression()) != null && extElem.getExpr() instanceof Var) {
                this.projElems.remove(varName);
            }
            return new Var(varName);
        }
    }

    public static enum Input {
        TEXT_FIRST(true, true),
        TEXT_ONLY(true, false),
        RDF_FIRST(false, true),
        RDF_ONLY(false, false);

        final boolean textFirst;
        final boolean canFallback;

        private Input(boolean textFirst, boolean canFallback) {
            this.textFirst = textFirst;
            this.canFallback = canFallback;
        }
    }
}

