/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.constraint;

import org.eclipse.rdf4j.sparqlbuilder.constraint.Aggregate;
import org.eclipse.rdf4j.sparqlbuilder.constraint.BinaryOperation;
import org.eclipse.rdf4j.sparqlbuilder.constraint.BinaryOperator;
import org.eclipse.rdf4j.sparqlbuilder.constraint.ConnectiveOperation;
import org.eclipse.rdf4j.sparqlbuilder.constraint.ConnectiveOperator;
import org.eclipse.rdf4j.sparqlbuilder.constraint.CustomFunction;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Function;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Operand;
import org.eclipse.rdf4j.sparqlbuilder.constraint.SparqlAggregate;
import org.eclipse.rdf4j.sparqlbuilder.constraint.SparqlFunction;
import org.eclipse.rdf4j.sparqlbuilder.constraint.UnaryOperation;
import org.eclipse.rdf4j.sparqlbuilder.constraint.UnaryOperator;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfLiteral;

public class Expressions {
    private Expressions() {
    }

    public static Expression<?> abs(Number operand) {
        return Expressions.abs(Rdf.literalOf(operand));
    }

    public static Expression<?> abs(Operand operand) {
        return Expressions.function(SparqlFunction.ABS, operand);
    }

    public static Expression<?> bnode() {
        return Expressions.function(SparqlFunction.BNODE, new Operand[0]);
    }

    public static Expression<?> bnode(RdfLiteral<?> literal) {
        return Expressions.function(SparqlFunction.BNODE, literal);
    }

    public static Expression<?> bnode(String literal) {
        return Expressions.function(SparqlFunction.BNODE, Rdf.literalOf(literal));
    }

    public static Expression<?> bound(Variable var) {
        return Expressions.function(SparqlFunction.BOUND, var);
    }

    public static Expression<?> ceil(Operand operand) {
        return Expressions.function(SparqlFunction.CEIL, operand);
    }

    public static Expression<?> coalesce(Operand ... operands) {
        return Expressions.function(SparqlFunction.COALESCE, operands);
    }

    public static Expression<?> concat(Operand ... operands) {
        return Expressions.function(SparqlFunction.CONCAT, operands);
    }

    public static Expression<?> regex(Operand testString, String pattern) {
        return Expressions.regex(testString, Rdf.literalOf(pattern));
    }

    public static Expression<?> regex(Operand testString, String pattern, String flags) {
        return Expressions.regex(testString, Rdf.literalOf(pattern), Rdf.literalOf(flags));
    }

    public static Expression<?> regex(Operand testString, Operand pattern) {
        return Expressions.function(SparqlFunction.REGEX, testString, pattern);
    }

    public static Expression<?> regex(Operand testString, Operand pattern, Operand flags) {
        return Expressions.function(SparqlFunction.REGEX, testString, pattern, flags);
    }

    public static Expression<?> str(Operand operand) {
        return Expressions.function(SparqlFunction.STRING, operand);
    }

    public static Expression<?> custom(Iri functionIri, Operand ... operands) {
        return new CustomFunction(functionIri).addOperand(operands);
    }

    public static Expression<?> function(SparqlFunction function, Operand ... operands) {
        return new Function(function).addOperand(operands);
    }

    public static Expression<?> not(Operand operand) {
        return Expressions.unaryExpression(UnaryOperator.NOT, operand);
    }

    public static Expression<?> plus(Operand operand) {
        return Expressions.unaryExpression(UnaryOperator.UNARY_PLUS, operand);
    }

    public static Expression<?> minus(Operand operand) {
        return Expressions.unaryExpression(UnaryOperator.UNARY_MINUS, operand);
    }

    private static UnaryOperation unaryExpression(UnaryOperator operator, Operand operand) {
        return (UnaryOperation)new UnaryOperation(operator).addOperand(operand);
    }

    public static Expression<?> equals(Operand left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.EQUALS, left, right);
    }

    public static Expression<?> notEquals(Operand left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.NOT_EQUALS, left, right);
    }

    public static Expression<?> gt(Number left, Number right) {
        return Expressions.binaryExpression(BinaryOperator.GREATER_THAN, Rdf.literalOf(left), Rdf.literalOf(right));
    }

    public static Expression<?> gt(Number left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.GREATER_THAN, Rdf.literalOf(left), right);
    }

    public static Expression<?> gt(Operand left, Number right) {
        return Expressions.binaryExpression(BinaryOperator.GREATER_THAN, left, Rdf.literalOf(right));
    }

    public static Expression<?> gt(Operand left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.GREATER_THAN, left, right);
    }

    public static Expression<?> gte(Operand left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.GREATER_THAN_EQUALS, left, right);
    }

    public static Expression<?> lt(Number left, Number right) {
        return Expressions.binaryExpression(BinaryOperator.LESS_THAN, Rdf.literalOf(left), Rdf.literalOf(right));
    }

    public static Expression<?> lt(Number left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.LESS_THAN, Rdf.literalOf(left), right);
    }

    public static Expression<?> lt(Operand left, Number right) {
        return Expressions.binaryExpression(BinaryOperator.LESS_THAN, left, Rdf.literalOf(right));
    }

    public static Expression<?> lt(Operand left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.LESS_THAN, left, right);
    }

    public static Expression<?> lte(Operand left, Operand right) {
        return Expressions.binaryExpression(BinaryOperator.LESS_THAN_EQUALS, left, right);
    }

    private static BinaryOperation binaryExpression(BinaryOperator operator, Operand op1, Operand op2) {
        BinaryOperation op = new BinaryOperation(operator);
        ((BinaryOperation)op.addOperand(op1)).addOperand(op2);
        return op;
    }

    public static Expression<?> and(Operand ... operands) {
        return Expressions.connectiveExpression(ConnectiveOperator.AND, operands);
    }

    public static Expression<?> or(Operand ... operands) {
        return Expressions.connectiveExpression(ConnectiveOperator.OR, operands);
    }

    public static Expression<?> add(Operand ... operands) {
        return Expressions.connectiveExpression(ConnectiveOperator.ADD, operands);
    }

    public static Expression<?> subtract(Operand ... operands) {
        return Expressions.connectiveExpression(ConnectiveOperator.SUBTRACT, operands);
    }

    public static Expression<?> multiply(Operand ... operands) {
        return Expressions.connectiveExpression(ConnectiveOperator.MULTIPLY, operands);
    }

    public static Expression<?> divide(Operand ... operands) {
        return Expressions.connectiveExpression(ConnectiveOperator.DIVIDE, operands);
    }

    private static ConnectiveOperation connectiveExpression(ConnectiveOperator operator, Operand ... operands) {
        ConnectiveOperation op = new ConnectiveOperation(operator);
        for (Operand operand : operands) {
            op.addOperand(operand);
        }
        return op;
    }

    public static Aggregate avg(Operand operand) {
        return (Aggregate)new Aggregate(SparqlAggregate.AVG).addOperand(operand);
    }

    public static Aggregate count(Operand operand) {
        return (Aggregate)new Aggregate(SparqlAggregate.COUNT).addOperand(operand);
    }

    public static Aggregate countAll() {
        return new Aggregate(SparqlAggregate.COUNT).countAll();
    }

    public static Aggregate group_concat(Operand ... operands) {
        return (Aggregate)new Aggregate(SparqlAggregate.GROUP_CONCAT).addOperand(operands);
    }

    public static Aggregate group_concat(String separator, Operand ... operands) {
        return ((Aggregate)new Aggregate(SparqlAggregate.GROUP_CONCAT).addOperand(operands)).separator(separator);
    }

    public static Aggregate max(Operand operand) {
        return (Aggregate)new Aggregate(SparqlAggregate.MAX).addOperand(operand);
    }

    public static Aggregate min(Operand operand) {
        return (Aggregate)new Aggregate(SparqlAggregate.MIN).addOperand(operand);
    }

    public static Aggregate sample(Operand operand) {
        return (Aggregate)new Aggregate(SparqlAggregate.SAMPLE).addOperand(operand);
    }

    public static Aggregate sum(Operand operand) {
        return (Aggregate)new Aggregate(SparqlAggregate.SUM).addOperand(operand);
    }
}

