/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointClassification;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.FederationEvaluationStrategyFactory;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.NamingThreadFactory;
import org.eclipse.rdf4j.federated.evaluation.concurrent.TaskWrapper;
import org.eclipse.rdf4j.federated.evaluation.union.ControlledWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.SynchronousWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.WorkerUnionBase;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationManager {
    private static final Logger log = LoggerFactory.getLogger(FederationManager.class);
    private FederationContext federationContext;
    private FedX federation;
    private ExecutorService executor;
    private FederationEvalStrategy strategy;
    private FederationType type;
    private ControlledWorkerScheduler<BindingSet> joinScheduler;
    private ControlledWorkerScheduler<BindingSet> leftJoinScheduler;
    private ControlledWorkerScheduler<BindingSet> unionScheduler;

    public void init(FedX federation, FederationContext federationContext) {
        this.federation = federation;
        this.federationContext = federationContext;
        this.executor = Executors.newCachedThreadPool(new NamingThreadFactory("FedX Executor"));
        this.updateStrategy();
        this.reset();
    }

    public void reset() {
        if (log.isDebugEnabled()) {
            log.debug("Scheduler for join and union are reset.");
        }
        Optional<TaskWrapper> taskWrapper = this.federationContext.getConfig().getTaskWrapper();
        if (this.joinScheduler != null) {
            this.joinScheduler.abort();
        }
        this.joinScheduler = new ControlledWorkerScheduler(this.federationContext.getConfig().getJoinWorkerThreads(), "Join Scheduler");
        taskWrapper.ifPresent(this.joinScheduler::setTaskWrapper);
        if (this.unionScheduler != null) {
            this.unionScheduler.abort();
        }
        this.unionScheduler = new ControlledWorkerScheduler(this.federationContext.getConfig().getUnionWorkerThreads(), "Union Scheduler");
        taskWrapper.ifPresent(this.unionScheduler::setTaskWrapper);
        if (this.leftJoinScheduler != null) {
            this.leftJoinScheduler.abort();
        }
        this.leftJoinScheduler = new ControlledWorkerScheduler(this.federationContext.getConfig().getLeftJoinWorkerThreads(), "Left Join Scheduler");
        taskWrapper.ifPresent(this.leftJoinScheduler::setTaskWrapper);
    }

    public Executor getExecutor() {
        Optional<TaskWrapper> taskWrapper = this.federationContext.getConfig().getTaskWrapper();
        return runnable -> {
            Runnable wrappedRunnable = taskWrapper.map(tw -> tw.wrap(runnable)).orElse(runnable);
            this.executor.execute(wrappedRunnable);
        };
    }

    public FedX getFederation() {
        return this.federation;
    }

    public FederationEvalStrategy getStrategy() {
        return this.strategy;
    }

    public ControlledWorkerScheduler<BindingSet> getJoinScheduler() {
        return this.joinScheduler;
    }

    public ControlledWorkerScheduler<BindingSet> getLeftJoinScheduler() {
        return this.leftJoinScheduler;
    }

    public ControlledWorkerScheduler<BindingSet> getUnionScheduler() {
        return this.unionScheduler;
    }

    public FederationType getFederationType() {
        return this.type;
    }

    public void addEndpoint(Endpoint e, boolean ... updateStrategy) throws FedXRuntimeException {
        log.info("Adding endpoint " + e.getId() + " to federation ...");
        for (Endpoint member : this.federation.getMembers()) {
            if (!member.getEndpoint().equals(e.getEndpoint())) continue;
            throw new FedXRuntimeException("Adding failed: there exists already an endpoint with location " + e.getEndpoint() + " (eid=" + member.getId() + ")");
        }
        this.federation.addMember(e);
        this.federationContext.getEndpointManager().addEndpoint(e);
        if (updateStrategy == null || updateStrategy.length == 0 || updateStrategy.length == 1 && updateStrategy[0]) {
            this.updateStrategy();
        }
    }

    public void addAll(List<Endpoint> endpoints) {
        log.info("Adding " + endpoints.size() + " endpoints to the federation.");
        for (Endpoint e : endpoints) {
            this.addEndpoint(e, false);
        }
        this.updateStrategy();
    }

    public void removeEndpoint(Endpoint e, boolean ... updateStrategy) throws RepositoryException {
        log.info("Removing endpoint " + e.getId() + " from federation ...");
        if (!this.federation.getMembers().contains(e)) {
            throw new FedXRuntimeException("Endpoint " + e.getId() + " is not a member of the current federation.");
        }
        this.federation.removeMember(e);
        this.federationContext.getEndpointManager().removeEndpoint(e);
        if (updateStrategy == null || updateStrategy.length == 0 || updateStrategy.length == 1 && updateStrategy[0]) {
            this.updateStrategy();
        }
    }

    public void removeAll() throws RepositoryException {
        log.info("Removing all endpoints from federation.");
        for (Endpoint e : new ArrayList<Endpoint>(this.federation.getMembers())) {
            this.removeEndpoint(e, false);
        }
        this.updateStrategy();
    }

    public synchronized void shutDown() throws FedXException {
        log.info("Shutting down federation and all underlying repositories ...");
        this.federationContext.getQueryManager().shutdown();
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to shutdown executor:" + e.getMessage());
            log.debug("Details:", (Throwable)e);
        }
        try {
            this.joinScheduler.shutdown();
        }
        catch (Exception e) {
            log.warn("Failed to shutdown join scheduler: " + e.getMessage());
            log.debug("Details: ", (Throwable)e);
        }
        try {
            this.unionScheduler.shutdown();
        }
        catch (Exception e) {
            log.warn("Failed to shutdown union scheduler: " + e.getMessage());
            log.debug("Details: ", (Throwable)e);
        }
        try {
            this.leftJoinScheduler.shutdown();
        }
        catch (Exception e) {
            log.warn("Failed to shutdown left join scheduler: " + e.getMessage());
            log.debug("Details: ", (Throwable)e);
        }
        this.federationContext.getFederatedServiceResolver().shutDown();
    }

    public WorkerUnionBase<BindingSet> createWorkerUnion(QueryInfo queryInfo) {
        FederationEvalStrategy strategy = this.getStrategy();
        if (this.type == FederationType.LOCAL) {
            return new SynchronousWorkerUnion<BindingSet>(strategy, queryInfo);
        }
        return new ControlledWorkerUnion<BindingSet>(strategy, this.unionScheduler, queryInfo);
    }

    public void updateStrategy() {
        int localCount = 0;
        int remoteCount = 0;
        for (Endpoint e : this.federation.getMembers()) {
            if (e.getEndpointClassification() == EndpointClassification.Remote) {
                ++remoteCount;
                continue;
            }
            ++localCount;
        }
        boolean updated = false;
        if (remoteCount == 0) {
            if (this.type != FederationType.LOCAL) {
                this.type = FederationType.LOCAL;
                updated = true;
            }
        } else if (localCount == 0) {
            if (this.type != FederationType.REMOTE) {
                this.type = FederationType.REMOTE;
                updated = true;
            }
        } else if (this.type != FederationType.HYBRID) {
            this.type = FederationType.HYBRID;
            updated = true;
        }
        if (updated) {
            this.strategy = FederationEvaluationStrategyFactory.getEvaluationStrategy(this.type, this.federationContext);
            log.info("Federation updated. Type: " + (Object)((Object)this.type) + ", evaluation strategy is " + this.strategy.getClass().getSimpleName());
        }
    }

    public static enum FederationType {
        LOCAL,
        REMOTE,
        HYBRID;

    }
}

