/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.eclipse.rdf4j.sail.lucene.AbstractReaderMonitor;
import org.eclipse.rdf4j.sail.lucene.LuceneIndex;

public class ReaderMonitor
extends AbstractReaderMonitor {
    private IndexSearcher indexSearcher;
    private IOException indexSearcherCreateException;

    public ReaderMonitor(LuceneIndex index, Directory directory) {
        super(index);
        try {
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            this.indexSearcher = new IndexSearcher((IndexReader)indexReader);
        }
        catch (IOException e) {
            this.indexSearcherCreateException = e;
        }
    }

    @Override
    protected void handleClose() throws IOException {
        try {
            if (this.indexSearcher != null) {
                this.indexSearcher.getIndexReader().close();
            }
        }
        finally {
            this.indexSearcher = null;
        }
    }

    protected IndexSearcher getIndexSearcher() throws IOException {
        if (this.indexSearcherCreateException != null) {
            throw this.indexSearcherCreateException;
        }
        return this.indexSearcher;
    }
}

