/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.memory.model.MemLiteral;

public class DecimalMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = 6760727653986046772L;
    private final BigDecimal value;

    public DecimalMemLiteral(Object creator, BigDecimal value) {
        this(creator, value, XSD.DECIMAL);
    }

    public DecimalMemLiteral(Object creator, BigDecimal value, IRI datatype) {
        this(creator, value.toPlainString(), value, datatype);
    }

    public DecimalMemLiteral(Object creator, String label, BigDecimal value, IRI datatype) {
        super(creator, label, datatype);
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return this.value.toBigInteger();
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value;
    }
}

