/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SimpleBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindSelect
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(BindSelect.class);
    private final SailConnection connection;
    private final Function<BindingSet, ValidationTuple> mapper;
    private final String query;
    private final List<StatementMatcher.Variable> vars;
    private final int bulkSize;
    private final PlanNode source;
    private final EffectiveTarget.Extend direction;
    private final boolean includePropertyShapeValues;
    private final List<String> varNames;
    private final ConstraintComponent.Scope scope;
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public BindSelect(SailConnection connection, String query, List<StatementMatcher.Variable> vars, PlanNode source, List<String> varNames, ConstraintComponent.Scope scope, int bulkSize, EffectiveTarget.Extend direction, boolean includePropertyShapeValues) {
        this.connection = connection;
        this.mapper = bindingSet -> new ValidationTuple((BindingSet)bindingSet, varNames, scope, includePropertyShapeValues);
        this.varNames = varNames;
        this.scope = scope;
        this.vars = vars;
        this.bulkSize = bulkSize;
        this.source = source = PlanNodeHelper.handleSorting(this, source);
        if (query.trim().equals("")) {
            throw new IllegalStateException();
        }
        this.query = query;
        this.direction = direction;
        this.includePropertyShapeValues = includePropertyShapeValues;
    }

    private void updateQuery(ParsedQuery parsedQuery, final List<BindingSet> newBindindingset, final int expectedSize) {
        try {
            parsedQuery.getTupleExpr().visit(new AbstractQueryModelVisitor<Exception>(){

                @Override
                public void meet(BindingSetAssignment node) throws Exception {
                    Set<String> bindingNames = node.getBindingNames();
                    if (bindingNames.size() == expectedSize) {
                        node.setBindingSets(newBindindingset);
                    }
                    super.meet(node);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            final CloseableIteration<? extends ValidationTuple, SailException> iterator;
            List<ValidationTuple> bulk;
            ParsedQuery parsedQuery;
            {
                this.iterator = BindSelect.this.source.iterator();
                this.bulk = new ArrayList<ValidationTuple>(BindSelect.this.bulkSize);
                this.parsedQuery = null;
            }

            public void calculateNext() {
                while (this.bindingSet == null || !this.bindingSet.hasNext()) {
                    ValidationTuple next;
                    if (this.bindingSet != null) {
                        this.bindingSet.close();
                    }
                    if (this.bulk.isEmpty() && !this.iterator.hasNext()) {
                        return;
                    }
                    if (this.bulk.isEmpty()) {
                        next = (ValidationTuple)this.iterator.next();
                        this.bulk.add(next);
                    } else {
                        next = this.bulk.get(0);
                    }
                    if (BindSelect.this.includePropertyShapeValues) {
                        assert (next.getScope() == ConstraintComponent.Scope.propertyShape);
                        assert (next.hasValue());
                    }
                    int targetChainSize = BindSelect.this.includePropertyShapeValues || next.getScope() != ConstraintComponent.Scope.propertyShape ? next.getFullChainSize(true) : next.getFullChainSize(BindSelect.this.includePropertyShapeValues);
                    if (this.parsedQuery == null) {
                        this.parsedQuery = BindSelect.this.getParsedQuery(targetChainSize);
                    }
                    while (this.bulk.size() < BindSelect.this.bulkSize && this.iterator.hasNext()) {
                        this.bulk.add((ValidationTuple)this.iterator.next());
                    }
                    List varNames = BindSelect.this.direction == EffectiveTarget.Extend.right ? BindSelect.this.vars.stream().limit(targetChainSize).map(StatementMatcher.Variable::getName).collect(Collectors.toList()) : BindSelect.this.vars.stream().skip(BindSelect.this.vars.size() - targetChainSize).map(StatementMatcher.Variable::getName).collect(Collectors.toList());
                    HashSet varNamesSet = new HashSet(varNames);
                    List bindingSets = this.bulk.stream().filter(t -> {
                        int temp = BindSelect.this.includePropertyShapeValues || t.getScope() != ConstraintComponent.Scope.propertyShape ? t.getFullChainSize(true) : t.getFullChainSize(BindSelect.this.includePropertyShapeValues);
                        return temp == targetChainSize;
                    }).map(t -> new SimpleBindingSet(varNamesSet, varNames, t.getTargetChain(BindSelect.this.includePropertyShapeValues))).collect(Collectors.toList());
                    this.bulk = this.bulk.stream().filter(t -> {
                        int temp = BindSelect.this.includePropertyShapeValues || t.getScope() != ConstraintComponent.Scope.propertyShape ? t.getFullChainSize(true) : t.getFullChainSize(BindSelect.this.includePropertyShapeValues);
                        return temp != targetChainSize;
                    }).collect(Collectors.toCollection(ArrayList::new));
                    BindSelect.this.updateQuery(this.parsedQuery, bindingSets, targetChainSize);
                    this.bindingSet = BindSelect.this.connection.evaluate(this.parsedQuery.getTupleExpr(), this.parsedQuery.getDataset(), EmptyBindingSet.getInstance(), true);
                }
            }

            @Override
            public void localClose() throws SailException {
                try {
                    this.bulk = null;
                    this.parsedQuery = null;
                    assert (!this.iterator.hasNext());
                    this.iterator.close();
                }
                finally {
                    if (this.bindingSet != null) {
                        this.bindingSet.close();
                    }
                }
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.bindingSet != null && this.bindingSet.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                return (ValidationTuple)BindSelect.this.mapper.apply((BindingSet)this.bindingSet.next());
            }
        };
    }

    private ParsedQuery getParsedQuery(int targetChainSize) {
        ParsedQuery parsedQuery;
        int i;
        StringBuilder values = new StringBuilder("\nVALUES( ");
        if (this.direction == EffectiveTarget.Extend.right) {
            for (i = 0; i < targetChainSize; ++i) {
                values.append("?").append(this.vars.get(i).getName()).append(" ");
            }
        } else if (this.direction == EffectiveTarget.Extend.left) {
            for (i = this.vars.size() - targetChainSize; i < this.vars.size(); ++i) {
                values.append("?").append(this.vars.get(i).getName()).append(" ");
            }
        } else {
            throw new IllegalStateException("Unknown direction: " + (Object)((Object)this.direction));
        }
        values.append("){}\n");
        String query = this.query;
        query = query.replace("#VALUES_INJECTION_POINT#", values.toString());
        query = "select * where { " + values + query + "\n}";
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
        try {
            parsedQuery = queryParserFactory.getParser().parseQuery(query, null);
        }
        catch (MalformedQueryException e) {
            logger.error("Malformed query: \n{}", (Object)query);
            throw e;
        }
        return parsedQuery;
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.source.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindSelect that = (BindSelect)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return this.bulkSize == that.bulkSize && this.includePropertyShapeValues == that.includePropertyShapeValues && ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && this.varNames.equals(that.varNames) && this.scope.equals((Object)that.scope) && this.query.equals(that.query) && this.vars.equals(that.vars) && this.source.equals(that.source) && this.direction == that.direction;
        }
        return this.bulkSize == that.bulkSize && this.includePropertyShapeValues == that.includePropertyShapeValues && this.connection.equals(that.connection) && this.varNames.equals(that.varNames) && this.scope.equals((Object)that.scope) && this.query.equals(that.query) && this.vars.equals(that.vars) && this.source.equals(that.source) && this.direction == that.direction;
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(new Object[]{((MemoryStoreConnection)this.connection).getSail(), this.varNames, this.scope, this.query, this.vars, this.bulkSize, this.source, this.direction, this.includePropertyShapeValues});
        }
        return Objects.hash(new Object[]{this.connection, this.varNames, this.scope, this.query, this.vars, this.bulkSize, this.source, this.direction, this.includePropertyShapeValues});
    }

    public String toString() {
        return "BindSelect{query='" + this.query.replace("\n", "\t") + '\'' + ", vars=" + this.vars + ", bulkSize=" + this.bulkSize + ", source=" + this.source + ", direction=" + (Object)((Object)this.direction) + ", includePropertyShapeValues=" + this.includePropertyShapeValues + ", varNames=" + this.varNames + ", scope=" + (Object)((Object)this.scope) + '}';
    }
}

