/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;

public class ConjunctiveFilterExpr
extends AbstractQueryModelNode
implements FilterValueExpr {
    private static final long serialVersionUID = -4016335014136286638L;
    protected List<FilterExpr> expressions;

    public ConjunctiveFilterExpr(FilterExpr expr1, FilterExpr expr2) {
        this.expressions = new ArrayList<FilterExpr>(3);
        this.addExpression(expr1);
        this.addExpression(expr2);
    }

    public ConjunctiveFilterExpr(Collection<FilterExpr> expressions) {
        if (expressions.size() < 2) {
            throw new IllegalArgumentException("Conjunctive Expression must have at least two arguments.");
        }
        this.expressions = new ArrayList<FilterExpr>(expressions.size());
        for (FilterExpr expr : expressions) {
            this.addExpression(expr);
        }
    }

    public void addExpression(FilterExpr expr) {
        this.expressions.add(expr);
    }

    public List<FilterExpr> getExpressions() {
        return this.expressions;
    }

    @Override
    public ConjunctiveFilterExpr clone() {
        return (ConjunctiveFilterExpr)super.clone();
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        super.visitChildren(visitor);
        for (FilterExpr expr : this.expressions) {
            expr.getExpression().visit(visitor);
        }
    }
}

